/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ripper.h"

extern mysqldatabase *database;
extern rcdatei settingsfile;

ripperdialog::ripperdialog(QWidget *pointer)
{
  //define sizes fo widgets
  QSize combosize(400,30);
  QSize spinboxsize(80,30);
  //make new Groupboxes for the layout
  ripperlayout=new QGroupBox(5,Qt::Vertical,pointer);
  multitagbox=new QGroupBox(4,Qt::Horizontal,ripperlayout);
  multitagbox->setTitle(i18n("Album information"));
  //artist-widgets
  artistlabel=new QLabel(i18n("Artist"),multitagbox);
  artistbox=new QComboBox(TRUE,multitagbox);
  artistbox->setAutoCompletion(settingsfile.vervollstaendigen);
  artistbox->setDuplicatesEnabled(FALSE);
  artistbox->setMinimumSize(combosize);
  //albumwidgets
  albumlabel=new QLabel(i18n("Album"),multitagbox);
  albumbox=new QComboBox(TRUE,multitagbox);
  albumbox->setAutoCompletion(settingsfile.vervollstaendigen);
  albumbox->setDuplicatesEnabled(FALSE);
  albumbox->setMinimumSize(combosize);
  //genrewidgets
  genrelabel=new QLabel(i18n("Genre"),multitagbox);
  genrebox=new QComboBox(TRUE,multitagbox);
  genrebox->setAutoCompletion(settingsfile.vervollstaendigen);
  genrebox->setDuplicatesEnabled(FALSE);
  genrebox->setMinimumSize(combosize);
  if(settingsfile.mysql)
    {
      //fill all comboboxes,if we are using mysqldatabase
      database->fillCombo(genrebox,"genres","genrename");
      database->fillCombo(albumbox,"albums","albumname");
      database->fillCombo(artistbox,"artists","artistname");
    }//yearwidgets
  yearlabel=new QLabel(i18n("Releaseyear"),multitagbox);
  yearbox=new QSpinBox(multitagbox);
  yearbox->setMinimumSize(spinboxsize);
  yearbox->setMaximumSize(spinboxsize);
  yearbox->setRange(0,9999);
  //fill songbox with cd-contents using cdparanoia
  songbox=new QGroupBox(1,Qt::Horizontal,ripperlayout);
  songbox->setTitle(i18n("Songinformation"));
  //initialize every pointer with NULL
  songs=NULL;
  scrollarea=NULL;
  selectallbutton=NULL;
  cd=NULL;
  scrollarea=new QScrollView(songbox);
  songs=new albumdialog(scrollarea,cd);//generate an empty songwidget conaining only text
  buttonbox=new QGroupBox(3,Qt::Vertical,ripperlayout);
  buttonbox->setTitle(i18n("Ripping options"));
  bitrate=new QButtonGroup(1,Qt::Vertical,i18n("Bitrate"),buttonbox);
  bitrate128=new QRadioButton("128kBit",bitrate);
  bitrate160=new QRadioButton("160kBit",bitrate);
  bitrate192=new QRadioButton("192kBit",bitrate);
  bitrate256=new QRadioButton("256kBit",bitrate);
  bitrate320=new QRadioButton("320kBit",bitrate);
  bitratevbr=new QRadioButton("Vbr",bitrate);
  //get right bitrate from settingsfile for init
  if (settingsfile.bitrate==128)
    bitrate128->setChecked(TRUE);
  if (settingsfile.bitrate==160)
    bitrate160->setChecked(TRUE);
  if (settingsfile.bitrate==192)
    bitrate192->setChecked(TRUE);
  if (settingsfile.bitrate==256)
    bitrate256->setChecked(TRUE);
  if (settingsfile.bitrate==320)
    bitrate320->setChecked(TRUE);
  if (settingsfile.bitrate==0)
    bitratevbr->setChecked(TRUE);
  actionbox=new QGroupBox(2,Qt::Horizontal,buttonbox);
  startbutton=new QPushButton(i18n("Start ripping"),actionbox);
  refreshbutton=new QPushButton(i18n("Refresh CD-info"),actionbox);
  startbutton->setEnabled(FALSE);
  connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
  connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
  connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
  connect(refreshbutton,SIGNAL(clicked()),SLOT(refreshcdinfoSlot()));
  connect(startbutton,SIGNAL(clicked()),SLOT(readinDiscSlot()));
}

ripperdialog::~ ripperdialog()
{
  delete songs;
  delete cd;
  delete artistlabel;
  delete albumlabel;
  delete yearlabel;
  delete genrelabel;
  delete bitrate;
  delete bitrate128;
  delete bitrate160;
  delete bitrate192;
  delete bitrate256;
  delete bitrate320;
  delete bitratevbr;
  delete startbutton;
  delete refreshbutton;
  delete actionbox;
  delete multitagbox;
  delete songbox;
  delete buttonbox;
  delete artistbox;
  delete albumbox;
  delete genrebox;
  delete pathbox;
  delete ripperlayout;
}

void ripperdialog::refreshcdinfoSlot()
{
  selectall=FALSE;
  progressmainwindow *progresswindow=new progressmainwindow(FALSE);
  progresswindow->show();
  progressinfoonly *progress=progresswindow->startInfoOnly(i18n("Reading Disc-Info"));
  progress->setText(i18n("Checking for CD"));
  if (songs)
    delete songs;
  if (scrollarea)
    delete scrollarea;
  if (selectallbutton)
    delete selectallbutton;
  if (cd)
    delete cd;
  cd=new compactdisc();
  scrollarea=new QScrollView(songbox);
  songs=new albumdialog(scrollarea,cd);
  if (cd->cdcontent->trackcount)//if we have a cd in cdrom
    {
      progress->setText(i18n("Checking local database for CD"));
      bool found=FALSE;
      if (settingsfile.mysql)
        {
          //first try to find cd in own database
          found=database->checkdiscid(cd->discid,artistbox,albumbox);
          if (found)
            {
              QStringList songlist;
              long albumid=database->translatealbum(albumbox->currentText());
              long artistid=database->translateartist(artistbox->currentText());
              if (database->albumexists(artistid,albumid,&songlist))
                {
                  //enter the values of the stringlist into the songledits
                  songs->setalltracks(&songlist);
                  //fetch the year of album
                  long year=database->getyear(albumid);
                  yearbox->setValue(year);
                }
            }
        }
      if (!found)
        {
          progress->setText(i18n("Fetching songs from CDDB"));
          freedbconnect *freedb=new freedbconnect();
          freedb->getcdinfo(cd->cddbquery,cd->discid);
          if (freedb->queryOk)
            {
              if (settingsfile.mysql)
                {
                  //when mysql is used, save the album into database
                  database->writealbum(cd->discid,freedb->artist,freedb->album,freedb->genre,freedb->releaseyear,freedb->tracklist);
                }
              //deactivate the connections to the boxes, while we are changing them
              disconnect(artistbox,SIGNAL(textChanged(const QString &)),this,SLOT(artistChanged()));
              disconnect(albumbox,SIGNAL(textChanged(const QString &)),this,SLOT(albumChanged()));
              disconnect(genrebox,SIGNAL(textChanged(const QString &)),this,SLOT(genreChanged()));
              //set all combos to the values got by freedb
              artistbox->setCurrentText(freedb->artist);
              albumbox->setCurrentText(freedb->album);
              genrebox->setCurrentText(freedb->genre);
              yearbox->setValue(freedb->releaseyear);
              //put all songnames into the songs-widget
              songs->setalltracks(freedb->tracklist);
              connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
              connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
              connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
            }
          else
            {
              QMessageBox::information(this,i18n("Freedb-Search"),i18n("Got no result from freedb."));
            }
          delete freedb;
        }
    }
  else
    {
      QMessageBox::information(this,i18n("Disc-error"),i18n("There is no audio-cd in your cdrom!"));
    }
  scrollarea->repaintContents(TRUE);
  scrollarea->show();
  if (songs->counter)
    {
      selectallbutton=new QPushButton(i18n("Select all"),songbox);
      selectallbutton->show();
      connect(selectallbutton,SIGNAL(clicked()),SLOT(selectallslot()));
      startbutton->setEnabled(TRUE);
    }
  else
    {
      selectallbutton=NULL;
      startbutton->setEnabled(FALSE);
    }
  delete progresswindow;
}


void ripperdialog::readinDiscSlot()
{
  if (bitrate->selected()==bitratevbr)
    settingsfile.bitrate=0;
  if (bitrate->selected()==bitrate128)
    settingsfile.bitrate=128;
  if (bitrate->selected()==bitrate160)
    settingsfile.bitrate=160;
  if (bitrate->selected()==bitrate192)
    settingsfile.bitrate=192;
  if (bitrate->selected()==bitrate256)
    settingsfile.bitrate=256;
  if (bitrate->selected()==bitrate320)
    settingsfile.bitrate=320;
  settingsfile.speichern();
  QStringList *readymp3Songs=new QStringList();
  long itemcounter=0;
  progressmainwindow *progresswindow=new progressmainwindow(TRUE);
  for (int tracknumber=1;tracknumber<=((cd->cdcontent->trackcount));tracknumber++)
    {
      if (songs->songfield[tracknumber-1]->songcheck->isChecked())
        {
          //Construct wavname
          id3tag *Song=new id3tag();
          Song->album=albumbox->currentText();
          Song->artist=artistbox->currentText();
          Song->genre=genrebox->currentText();
          Song->number=tracknumber;
          Song->year=yearbox->value();
          QString mp3name;
          QString wavname;
          if (!(songs->songfield[tracknumber-1]->songledit->text().isEmpty()))
            {
              Song->titel=songs->songfield[tracknumber-1]->songledit->text();
              wavname=QString("%1%2.wav").arg(settingsfile.mp3_dir,songs->songfield[tracknumber-1]->songledit->text());
              mp3name=QString("%1%2.mp3").arg(settingsfile.mp3_dir,songs->songfield[tracknumber-1]->songledit->text());
            }
          else
            {
              Song->titel=QString("Track%1").arg(QString::number(tracknumber));
              wavname=QString("%1Track%2.wav").arg(settingsfile.mp3_dir,QString::number(tracknumber));
              mp3name=QString("%1Track%2.mp3").arg(settingsfile.mp3_dir,QString::number(tracknumber));
            }
          if(!progresswindow->isChancelled)
            cd->getTrack(tracknumber,wavname,progresswindow);
          if(!progresswindow->isChancelled)
            {
              new lamecode(wavname,mp3name,settingsfile.bitrate,Song,progresswindow);
              readymp3Songs->append(mp3name);
              itemcounter++;
            }
        }
    }
  while (progresswindow->runningprogresses)
    kapp->processEvents();
  delete progresswindow;
  if (itemcounter)
    {
      cleanup *filemove=new cleanup(this);
      if (filemove->filterok&&filemove->directoriesok)
        {
          filemove->cleanupcd(readymp3Songs,itemcounter);
          delete filemove;
          QMessageBox::information(this,i18n("Process finished"),i18n("Selected Tracks where ripped."),"&Ok");
        }
      else
        delete filemove;
    }
  else
    QMessageBox::information(this,i18n("Process finished"),i18n("You have to select some tracks for ripping."),"&Ok");
}

void ripperdialog::selectallslot()
{
  if (selectall==0)
    {
      selectall=TRUE;
      selectallbutton->setText(i18n("Deselect all"));
    }
  else
    {
      selectall=FALSE;
      selectallbutton->setText(i18n("Select all"));
    }
  {
    for (int tracknumber=1;tracknumber<=((cd->cdcontent->trackcount));tracknumber++)
      songs->songfield[tracknumber-1]->songcheck->setChecked(selectall);
  }
}

void ripperdialog::artistChanged()
{
  if(settingsfile.mysql)
    {
      //deactivate all other comboslots,to stop recursion
      disconnect(artistbox,SIGNAL(textChanged(const QString &)),this,SLOT(artistChanged()));
      disconnect(albumbox,SIGNAL(textChanged(const QString &)),this,SLOT(albumChanged()));
      disconnect(genrebox,SIGNAL(textChanged(const QString &)),this,SLOT(genreChanged()));
      //Read in all Combos, and build a sql-query with them
      QString artist=artistbox->currentText();
      QString album=albumbox->currentText();
      QString genre=genrebox->currentText();
      long artistid=database->translateartist(artist);
      if (!artistid)
        {
          //if no artist with that name in database,reread all boxes
          database->fillCombo(artistbox,"artists","artistname");
          database->fillCombo(albumbox,"albums","albumname");
          database->fillCombo(genrebox,"genres","genrename");
        }
      else
        {
          long albumid=database->translatealbum(album);
          long genreid=database->translategenre(genre);
          QString querystring=QString("artist_id=\"%1\"").arg(artistid);
          database->fillSortedCombo(albumbox,"albums",querystring,"albumname");
          database->fillSortedCombo(genrebox,"tracks",querystring,"genre_id","genres");
          //refetch albumcombo
          album=albumbox->currentText();
          albumid=database->translatealbum(album);
          //Check if a right combination is in the comboboxes, and than modify all songledits
          if(artistid&&albumid)
            {
              QStringList songlist;
              if (database->albumexists(artistid,albumid,&songlist))
                {
                  //enter the values of the stringlist into the songledits
                  songs->setalltracks(&songlist);
                  //fetch the year of album
                  long year=database->getyear(albumid);
                  yearbox->setValue(year);
                }
            }
        }
      //reactivate all slots
      connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
      connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
      connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
    }
}

void ripperdialog::albumChanged()
{
  if (settingsfile.mysql)
    {
      //deactivate all other comboslots,to stop recursion
      disconnect(artistbox,SIGNAL(textChanged(const QString &)),this,SLOT(artistChanged()));
      disconnect(albumbox,SIGNAL(textChanged(const QString &)),this,SLOT(albumChanged()));
      disconnect(genrebox,SIGNAL(textChanged(const QString &)),this,SLOT(genreChanged()));
      //Read in all Combos, and build a sql-query with them
      QString artist=artistbox->currentText();
      QString album=albumbox->currentText();
      QString genre=genrebox->currentText();
      long albumid=database->translatealbum(album);
      if (!albumid)
        {
          //if no album with that name in database,reread all boxes
          database->fillCombo(artistbox,"artists","artistname");
          database->fillCombo(albumbox,"albums","albumname");
          database->fillCombo(genrebox,"genres","genrename");
        }
      else
        {
          long artistid=database->translateartist(artist);
          long genreid=database->translategenre(genre);
          QString querystring=QString("album_id=\"%1\"").arg(albumid);
          database->fillSortedCombo(artistbox,"tracks",querystring,"artist_id","artists");
          database->fillSortedCombo(genrebox,"tracks",querystring,"genre_id","genres");
          //refetch albumcombo
          artist=artistbox->currentText();
          artistid=database->translateartist(artist);
          //Check if a right combination is in the comboboxes, and than modify all songledits
          if(artistid&&albumid)
            {
              QStringList songlist;
              if (database->albumexists(artistid,albumid,&songlist))
                {
                  //enter the values of the stringlist into the songledits
                  songs->setalltracks(&songlist);
                  //fetch the year of album
                  long year=database->getyear(albumid);
                  yearbox->setValue(year);
                }
            }
        }
      //reactivate all slots
      connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
      connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
      connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
    }
}

void ripperdialog::genreChanged()
{
  if (settingsfile.mysql)
    {
      //deactivate all other comboslots,to stop recursion
      disconnect(artistbox,SIGNAL(textChanged(const QString &)),this,SLOT(artistChanged()));
      disconnect(albumbox,SIGNAL(textChanged(const QString &)),this,SLOT(albumChanged()));
      disconnect(genrebox,SIGNAL(textChanged(const QString &)),this,SLOT(genreChanged()));
      //Read in all Combos, and build a sql-query with them
      QString artist=artistbox->currentText();
      QString album=albumbox->currentText();
      QString genre=genrebox->currentText();
      long genreid=database->translategenre(genre);
      if (!genreid)
        {
          //if no album with that name in database,reread all boxes
          database->fillCombo(artistbox,"artists","artistname");
          database->fillCombo(albumbox,"albums","albumname");
          database->fillCombo(genrebox,"genres","genrename");
        }
      else
        {
          long artistid=database->translateartist(artist);
          long albumid=database->translatealbum(album);
          QString querystring=QString("genre_id=\"%1\"").arg(genreid);
          database->fillSortedCombo(artistbox,"tracks",querystring,"artist_id","artists");
          database->fillSortedCombo(albumbox,"tracks",querystring,"album_id","albums");
          //refetch albumcombo and artistcombo
          album=albumbox->currentText();
          albumid=database->translatealbum(album);
          artist=artistbox->currentText();
          artistid=database->translateartist(artist);
          //Check if a right combination is in the comboboxes, and than modify all songledits
          if(artistid&&albumid)
            {
              QStringList songlist;
              if (database->albumexists(artistid,albumid,&songlist))
                {
                  //enter the values of the stringlist into the songledits
                  songs->setalltracks(&songlist);
                  //fetch the year of album
                  long year=database->getyear(albumid);
                  yearbox->setValue(year);
                }
            }
        }
      //reactivate all slots
      connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
      connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
      connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
    }
}

void ripperdialog::setAutocomplete(bool autocomplete)
{
  artistbox->setAutoCompletion(autocomplete);
  albumbox->setAutoCompletion(autocomplete);
  genrebox->setAutoCompletion(autocomplete);
}
