/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#define SCHREIBEN TRUE

#include "tagdialog.h"

extern mysqldatabase *database;
extern verzeichnis *verzeichnisbaum;
extern rcdatei settingsfile;

tagdialog::tagdialog(QWidget *pointer)
{
  loader=new KIconLoader();
  QPixmap pixmap;
  QString picname;
  //Grsse fr alle Comboboxen festlegen
  QSize combosize(300,30);
  QSize spinboxsize(80,30);
  QSize listviewsize(300,200);
  QSize infozeilesize(1600,30);
  //Treeview zum Files selektieren
  tagdialoglayout=new QVBoxLayout(pointer);
  splitteraufteilung=new QSplitter(QSplitter::Horizontal,pointer);
  tagdialoglayout->addWidget(splitteraufteilung);
  infozeile=new QStatusBar(pointer,"Status");
  infozeile->setMaximumSize(infozeilesize);
  //tagdialoglayout->addWidget(infozeile);
  hauptbox=new QGroupBox(7,Qt::Vertical,"ID3-Tags",splitteraufteilung);
  hauptbox->setInsideMargin(10);
  auswahlbaum=new QListView(splitteraufteilung);
  auswahlbaum->setSelectionMode(QListView::Extended);
  auswahlbaum->setRootIsDecorated(TRUE);
  auswahlbaum->setResizeMode(QListView::AllColumns);
  auswahlbaum->addColumn(i18n("directory-tree"),-1);
  auswahlbaum->setMinimumSize(listviewsize);
  splitteraufteilung->moveToFirst(auswahlbaum);
  //Alle Layoutzeiger anlegen
  mainlayout=new QHBoxLayout(pointer);
  mainlayout->addWidget(splitteraufteilung);
  mainlayout->setSpacing(5);
  mainlayout->setMargin(5);
  //Alle Gruppierungsboxen erzeugen
  gruppegroupbox=new QGroupBox(2,Qt::Horizontal,hauptbox);
  albumgroupbox=new QGroupBox(2,Qt::Horizontal,hauptbox);
  titelgroupbox=new QGroupBox(3,Qt::Horizontal,hauptbox);
  genregroupbox=new QGroupBox(2,Qt::Horizontal,hauptbox);
  jahrgroupbox=new QGroupBox(2,Qt::Horizontal,hauptbox);

  //Covers noch nicht implementiert
  //covergroupbox=new QGroupBox(2,Qt::Horizontal,"CD-Cover",hauptbox);

  //Zeile1 Gruppe
  artistlabel=new QLabel(i18n("artist"),gruppegroupbox);
  artistbox=new QComboBox(SCHREIBEN,gruppegroupbox);
  artistbox->setAutoCompletion(settingsfile.vervollstaendigen);
  artistbox->setDuplicatesEnabled(FALSE);
  artistbox->setMinimumSize(combosize);
  //Zeile2 Album
  albumlabel=new QLabel(i18n("album"),albumgroupbox);
  albumbox=new QComboBox(SCHREIBEN,albumgroupbox);
  albumbox->setAutoCompletion(settingsfile.vervollstaendigen);
  albumbox->setDuplicatesEnabled(FALSE);
  albumbox->setMinimumSize(combosize);
  //Zeile3 Track und Titel
  tracklabel=new QLabel(i18n("track"),titelgroupbox);
  tracknumberbox=new QSpinBox(titelgroupbox);
  tracknumberbox->setRange(0,99);
  tracknumberbox->setMinimumSize(spinboxsize);
  tracknumberbox->setMaximumSize(spinboxsize);
  trackbox=new QComboBox(SCHREIBEN,titelgroupbox);
  trackbox->setAutoCompletion(settingsfile.vervollstaendigen);
  trackbox->setDuplicatesEnabled(FALSE);
  trackbox->setMinimumSize(combosize);
  //Zeile4 genre
  genrelabel=new QLabel(i18n("genre"),genregroupbox);
  genrebox=new QComboBox(SCHREIBEN,genregroupbox);
  genrebox->setDuplicatesEnabled(FALSE);
  genrebox->setAutoCompletion(settingsfile.vervollstaendigen);
  genrebox->setMinimumSize(combosize);
  //Zeile 5 Jahr
  yearlabel=new QLabel(i18n("releaseyear"),jahrgroupbox);
  yearbox=new QSpinBox(jahrgroupbox);
  yearbox->setRange(0,9999);
  yearbox->setMinimumSize(spinboxsize);
  yearbox->setMaximumSize(spinboxsize);

  //zeile6 Coverbild
  //Covers noch nicht implementiert
  //  coverdatei="/usr/kde/share/apps/k-yamo/test.jpg";
  //  coverbild.load(coverdatei);
  //  QImage coverbild2;
  //  coverbild2=coverbild;
  //  coverbild2=coverbild2.smoothScale(300,300,QImage::ScaleMin);
  //  coverbild=coverbild2;
  //  coverlabel=new QLabel(covergroupbox);
  //  coverlabel->setPixmap(coverbild);
  //  coverknopf=new QPushButton(covergroupbox);

  picname="filesave.png";
  pixmap=loader->loadIcon(picname,KIcon::Desktop);
  QIconSet buttonset(pixmap);
  speichernknopf=new QPushButton(i18n("save file"),hauptbox);
  speichernknopf->setIconSet(buttonset);
  picname="wizard.png";
  pixmap=loader->loadIcon(picname,KIcon::Desktop);
  buttonset=QIconSet(pixmap);
  cleanupbutton=new QPushButton(i18n("Cleanup"),hauptbox);
  cleanupbutton->setIconSet(buttonset);

  //alle Eingaben auf rechter Seite sperren, bis Datei(en) ausgesucht sind
  infozeile->message(i18n("no files selected"));
  eingabensperren();
  //Connections fr die ComboBoxen
  connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
  connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
  connect(trackbox,SIGNAL(textChanged(const QString &)),SLOT(trackChanged()));
  connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
  connect(speichernknopf,SIGNAL(clicked()),this,SLOT(tagschreiben()));
  connect(cleanupbutton,SIGNAL(clicked()),this,SLOT(cleanupslot()));
  //Covers noch nicht implementiert
  //  connect(coverknopf,SIGNAL(clicked()),this,SLOT(bildladen()));

  connect(auswahlbaum,SIGNAL(selectionChanged()),this,SLOT(multitagupdate()));
  if (settingsfile.mysql)
    boxenholen();
}

tagdialog::~tagdialog()
{
  delete infozeile;
  delete loader;
  delete mainlayout;
  delete tagdialoglayout;
  delete splitteraufteilung;
  delete hauptbox;
  delete gruppegroupbox;
  delete albumgroupbox;
  delete titelgroupbox;
  delete genregroupbox;
  delete jahrgroupbox;
  delete covergroupbox;
  delete coverknopf;
  delete artistlabel;
  delete albumlabel;
  delete tracklabel;
  delete genrelabel;
  delete yearlabel;
  delete artistbox;
  delete albumbox;
  delete trackbox;
  delete genrebox;
  delete auswahlbaum;
  delete tracknumberbox;
  delete yearbox;
  delete speichernknopf;
}

void tagdialog::setvervollstaendigen(bool vervollstaendigen)
{
  artistbox->setAutoCompletion(vervollstaendigen);
  albumbox->setAutoCompletion(vervollstaendigen);
  trackbox->setAutoCompletion(vervollstaendigen);
  genrebox->setAutoCompletion(vervollstaendigen);
}

void tagdialog::listboxholen()
{
  progressmainwindow *progresswindow=new progressmainwindow(FALSE);
  progresswindow->show();
  if (verzeichnisbaum)
    delete verzeichnisbaum;
  verzeichnisbaum=new verzeichnis(settingsfile.reading_dir);
  verzeichnisbaum->abbruch=FALSE;
  auswahlbaum->clear();//alten Baum lschen
  if (!verzeichnisbaum->abortscan)
    {
      // Lehren Ordner mit Working-Dir-Path als namen generieren
      QListViewItem *startordner=new QListViewItem(auswahlbaum,settingsfile.reading_dir);
      startordner->setExpandable(TRUE);
      //Restlichen Baum holen
      progressinfo *scanprocess=progresswindow->startInfo(i18n("Scanning for files"));
      connect(scanprocess,SIGNAL(chancelled()),verzeichnisbaum,SLOT(abbruchslot()));
      verzeichnisbaum->treemodus(settingsfile.reading_dir,startordner,scanprocess);
      progresswindow->killProgress(scanprocess);
      //Falls brauchbare Dateien gefunden,und MYSQL benutzt wird, Dateien mit Datenbank vergleichen
      if ((verzeichnisbaum->musikgefunden())&&(settingsfile.mysql)&&!verzeichnisbaum->abortscan)
        {
          progresswithbar *progressbar=progresswindow->startProgress(i18n("Matching directories to MySQL"),verzeichnisbaum->dzaehler);
          verzeichnisbaum->scanverzeichnis(progressbar);

        }
      startordner->setOpen(TRUE);
      delete progresswindow;
    }
  else
    {
      delete progresswindow;
    }
}

void tagdialog::tagupdate(QListViewItem *inhalt)
{
  disconnect(artistbox,SIGNAL(textChanged(const QString &)),this,SLOT(artistChanged()));
  disconnect(albumbox,SIGNAL(textChanged(const QString &)),this,SLOT(albumChanged()));
  disconnect(trackbox,SIGNAL(textChanged(const QString &)),this,SLOT(trackChanged()));
  disconnect(genrebox,SIGNAL(textChanged(const QString &)),this,SLOT(genreChanged()));
  if (inhalt->isExpandable())
    {
      //Pfad bis zu Startverzeichnis auflsen
      QString Pfad=inhalt->text(0);
      QListViewItem *pfadpuffer=inhalt;
      while (pfadpuffer->parent())
        {
          pfadpuffer=pfadpuffer->parent();
          Pfad=QString("%1/%2").arg(pfadpuffer->text(0),Pfad);
        }
    }
  else
    {
      //Pfad bis zu Startverzeichnis auflsen
      aktuelledatei=inhalt->text(0);
      QListViewItem *pfadpuffer=inhalt;
      while (pfadpuffer->parent())
        {
          pfadpuffer=pfadpuffer->parent();
          aktuelledatei=QString("%1/%2").arg(pfadpuffer->text(0),aktuelledatei);
        }
    }
  if (!aktuelledatei.isEmpty()&&singleselect)
    {
      musikdatei datei;
      id3tag *Song;
      Song=datei.lesenTag(aktuelledatei);
      artistbox->setCurrentText(Song->artist);
      albumbox->setCurrentText(Song->album);
      trackbox->setCurrentText(Song->titel);
      genrebox->setCurrentText(Song->genre);
      yearbox->setValue(Song->year);
      tracknumberbox->setValue(Song->number);
      delete Song;
    }
  connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
  connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
  connect(trackbox,SIGNAL(textChanged(const QString &)),SLOT(trackChanged()));
  connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
}

void tagdialog::multitagupdate()
{
  disconnect(artistbox,SIGNAL(textChanged(const QString &)),this,SLOT(artistChanged()));
  disconnect(albumbox,SIGNAL(textChanged(const QString &)),this,SLOT(albumChanged()));
  disconnect(trackbox,SIGNAL(textChanged(const QString &)),this,SLOT(trackChanged()));
  disconnect(genrebox,SIGNAL(textChanged(const QString &)),this,SLOT(genreChanged()));
  speichernknopf->setEnabled(FALSE);
  QListViewItemIterator auswahl(auswahlbaum,QListViewItemIterator::Selected);
  this->auswahlliste.clear();
  eingabensperren();
  itemcounter=0;
  musikdatei datei;
  id3tag *Song;
  while (auswahl.current())
    {
      if (!(auswahl.current()->isExpandable()))
        {
          auswahlliste.append(auswahl.current());
          itemcounter++;
        }
      else
        {
          //Verzeichnis rekursiv hinzufgen
          rekursivtag(auswahl.current());
          //alles was zu Verzeichnis gehrt aus select entfernen, um Dateien nicht mehrfach zu selektieren

        }
      auswahl++;
    }
  if (itemcounter==0)
    {
      infozeile->message(i18n("no files selected"));
    }
  else if (itemcounter==1)
    {
      singleselect=1;
      eingabenfreigebensingle();
      tagupdate (auswahlliste.first());
      infozeile->message(i18n("1 file selected"));
    }
  else if (itemcounter>1)
    {
      QString bandvergleich,albumvergleich,titelvergleich,genrevergleich;
      int jahrvergleich=0,nummervergleich=0;
      singleselect=0;
      infozeile->message(i18n("%1 files selected").arg(itemcounter));
      //Stringliste fr die kompletten Dateinamen
      QListViewItem *pfadpuffer;
      auswahlliste.first();
      long i=0;
      bandabbruch=FALSE;
      albumabbruch=FALSE;
      titelabbruch=FALSE;
      genreabbruch=FALSE;
      jahrabbruch=FALSE;
      nummerabbruch=FALSE;
      bool komplettabbruch=FALSE;
      while ((i<itemcounter)&&!(komplettabbruch))
        {
          pfadpuffer=auswahlliste.current();
          aktuelledatei=pfadpuffer->text(0);
          while (pfadpuffer->parent())
            {
              pfadpuffer=pfadpuffer->parent();
              aktuelledatei=QString("%1/%2").arg(pfadpuffer->text(0),aktuelledatei);
            }
          Song=datei.lesenTag(aktuelledatei);
          if (i==0)
            {
              //Vergleichswerte in Strings einlesen
              bandvergleich=Song->artist;
              albumvergleich=Song->album;
              titelvergleich=Song->titel;
              genrevergleich=Song->genre;
              jahrvergleich=Song->year;
              nummervergleich=Song->number;
            }
          else
            {
              //Tags aktueller Datei mit Vergleichswerten berprfen und bei nichtbereinstimmung, nicht mehr weiter prfen
              if (!bandvergleich.isEmpty()||bandabbruch)
                {
                  if (bandvergleich.compare(Song->artist))
                    {
                      bandvergleich="";
                      bandabbruch=TRUE;
                    }
                }
              if (!albumvergleich.isEmpty()||albumabbruch)
                {
                  if (albumvergleich.compare(Song->album))
                    {
                      albumvergleich="";
                      albumabbruch=TRUE;
                    }
                }
              if (!titelvergleich.isEmpty()||titelabbruch)
                {
                  if (titelvergleich.compare(Song->titel))
                    {
                      titelvergleich="";
                      titelabbruch=TRUE;
                    }
                }
              if (!genrevergleich.isEmpty()||genreabbruch)
                {
                  if (genrevergleich.compare(Song->genre))
                    {
                      genrevergleich="";
                      genreabbruch=TRUE;
                    }
                }
              if (!jahrabbruch)
                {
                  if (!(jahrvergleich==Song->year))
                    {
                      jahrvergleich=0;
                      jahrabbruch=TRUE;
                    }
                }
              if (!nummerabbruch)
                {
                  if (!(nummervergleich==Song->number))
                    {
                      nummervergleich=0;
                      nummerabbruch=TRUE;
                    }
                }
            }
          delete Song;
          auswahlliste.next();
          if (bandabbruch&&albumabbruch&&titelabbruch&&genreabbruch&&nummerabbruch&&jahrabbruch)
            komplettabbruch=TRUE;
          i++;
        }
      artistbox->setCurrentText(bandvergleich);
      albumbox->setCurrentText(albumvergleich);
      trackbox->setCurrentText(titelvergleich);
      genrebox->setCurrentText(genrevergleich);
      yearbox->setValue(jahrvergleich);
      tracknumberbox->setValue(nummervergleich);
      eingabenfreigebenmulti();
    }
  connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
  connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
  connect(trackbox,SIGNAL(textChanged(const QString &)),SLOT(trackChanged()));
  connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
}

void tagdialog::rekursivtag(QListViewItem *verzeichnis)
{
  QListViewItem *puffer=verzeichnis->firstChild();
  if (puffer)
    {
      puffer->setSelected(FALSE);
      if (puffer->isExpandable())
        {
          rekursivtag(puffer);//nchste Rekursionstufe
        }
      else
        {
          auswahlliste.append(puffer);
          itemcounter++;
        }
      while (puffer=puffer->nextSibling())
        {
          puffer->setSelected(FALSE);
          if (puffer->isExpandable())
            {
              rekursivtag(puffer);//nchste Rekursionstufe
            }
          else
            {
              auswahlliste.append(puffer);
              itemcounter++;
            }
        };
    }
}

void tagdialog::tagschreiben()
{
  if (itemcounter)
    {
      if (singleselect)
        {
          id3tag *Song;
          musikdatei datei;
          Song=datei.lesenTag(aktuelledatei);
          Song->artist=artistbox->currentText();
          Song->album=albumbox->currentText();
          Song->titel=trackbox->currentText();
          Song->genre=genrebox->currentText();
          Song->number=tracknumberbox->value();
          Song->year=yearbox->value();
          bool erfolg=datei.schreibenTag(aktuelledatei,Song);
          if (!erfolg)
            {
              QMessageBox::warning(this,i18n("write error"),i18n("file could not be written"),"&Ok",QString::null,QString::null,1);
              if(settingsfile.mysql)
                database->writetag(Song);
            }
          else
            QMessageBox::information(this,i18n("Transaction report"),i18n("file  ")+aktuelledatei+i18n(" was written successfully"));
          delete Song;
        }
      else
        {
          progressmainwindow *progresswindow=new progressmainwindow(FALSE);
          progresswindow->show();
          progresswithbar *writestatus=progresswindow->startProgress( i18n("saving edited files"),itemcounter);
          QListViewItem *pfadpuffer;
          id3tag *Song=NULL;
          bool abbruch=FALSE;
          musikdatei datei;
          long fehler=0;
          long counter=0;
          QPtrList<QListViewItem>::Iterator index = this->auswahlliste.begin();
          while( index != this->auswahlliste.end()&&!abbruch)
            {
              pfadpuffer=*index;
              aktuelledatei=pfadpuffer->text(0);
              writestatus->setProgress(++counter);
              if (writestatus->isChancelled||abbruch)
                {
                  abbruch=TRUE;
                }
              while (pfadpuffer->parent())
                {
                  pfadpuffer=pfadpuffer->parent();
                  if (pfadpuffer->text(0).endsWith("/"))
                    aktuelledatei=QString("%1%2").arg(pfadpuffer->text(0),aktuelledatei);
                  else
                    aktuelledatei=QString("%1/%2").arg(pfadpuffer->text(0),aktuelledatei);
                }
              Song=datei.lesenTag(aktuelledatei);
              if (gruppegroupbox->isChecked())
                Song->artist=artistbox->currentText();
              if (albumgroupbox->isChecked())
                Song->album=albumbox->currentText();
              if (titelgroupbox->isChecked())
                {
                  Song->titel=trackbox->currentText();
                  Song->number=tracknumberbox->value();
                }
              if (genregroupbox->isChecked())
                Song->genre=genrebox->currentText();
              if (jahrgroupbox->isChecked())
                Song->year=yearbox->value();
              if (!datei.schreibenTag(aktuelledatei,Song))
                {
                  if (QMessageBox::warning(this,i18n("write error"),i18n("file could not be written"),"&Ok",i18n("&Cancel"),QString::null,1))
                    abbruch=TRUE;
                  fehler++;
                }
              else if(settingsfile.mysql)
                database->writetag(Song);
              index++;
            };
          delete progresswindow;
          if (fehler)
            {
              QMessageBox::information(this,i18n("Transaction report"),i18n("action terminated with ")+QString::number(fehler)+i18n(" errors"),i18n("&Ok"));
            }
          else
            QMessageBox::information(this,i18n("Transaction report"),i18n("action terminated without errors"));
          delete Song;
        }
    }
}

//Covers noch nicht implementiert
// void tagdialog::bildladen()
// {
//   coverdatei=QFileDialog::getOpenFileName("/",i18n("Bilddateien (*.jpg)"),this,i18n("Datei laden"),i18n("Bitte Datei auswhlen"));
//   coverbild.load(coverdatei);
//   QImage coverbild2;
//   coverbild2=coverbild;
//   coverbild2=coverbild2.smoothScale(300,300,QImage::ScaleMin);
//   coverbild=coverbild2;
//   coverlabel->setPixmap(coverbild);
// }


void tagdialog::eingabensperren()
{
  artistbox->setEnabled(FALSE);
  albumbox->setEnabled(FALSE);
  trackbox->setEnabled(FALSE);
  genrebox->setEnabled(FALSE);
  tracknumberbox->setEnabled(FALSE);
  yearbox->setEnabled(FALSE);

  //Covers noch nicht implemntiert
  //coverknopf->setEnabled(FALSE);

  speichernknopf->setEnabled(FALSE);
  cleanupbutton->setEnabled(FALSE);
  gruppegroupbox->setCheckable(FALSE);
  gruppegroupbox->setCheckable(FALSE);
  albumgroupbox->setCheckable(FALSE);
  titelgroupbox->setCheckable(FALSE);
  genregroupbox->setCheckable(FALSE);
  jahrgroupbox->setCheckable(FALSE);
  //covergroupbox->setCheckable(FALSE);
}

void tagdialog::eingabenfreigebensingle()
{
  artistbox->setEnabled(TRUE);
  albumbox->setEnabled(TRUE);
  trackbox->setEnabled(TRUE);
  genrebox->setEnabled(TRUE);
  tracknumberbox->setEnabled(TRUE);
  yearbox->setEnabled(TRUE);
  //coverknopf->setEnabled(TRUE);
  speichernknopf->setText(i18n("Save file"));
  speichernknopf->setEnabled(TRUE);
  cleanupbutton->setText(i18n("Cleanup file"));
  cleanupbutton->setEnabled(TRUE);
  gruppegroupbox->setCheckable(FALSE);
  albumgroupbox->setCheckable(FALSE);
  titelgroupbox->setCheckable(FALSE);
  genregroupbox->setCheckable(FALSE);
  jahrgroupbox->setCheckable(FALSE);
  //covergroupbox->setCheckable(FALSE);
}

void tagdialog::eingabenfreigebenmulti()
{
  //coverknopf->setEnabled(TRUE);
  speichernknopf->setText(i18n("Save files"));
  speichernknopf->setEnabled(TRUE);
  cleanupbutton->setText(i18n("Cleanup files"));
  cleanupbutton->setEnabled(TRUE);
  gruppegroupbox->setCheckable(TRUE);
  albumgroupbox->setCheckable(TRUE);
  titelgroupbox->setCheckable(TRUE);
  genregroupbox->setCheckable(TRUE);
  jahrgroupbox->setCheckable(TRUE);
  artistbox->setEnabled(TRUE);
  albumbox->setEnabled(TRUE);
  trackbox->setEnabled(TRUE);
  genrebox->setEnabled(TRUE);
  tracknumberbox->setEnabled(TRUE);
  yearbox->setEnabled(TRUE);
  gruppegroupbox->setChecked(!bandabbruch);
  albumgroupbox->setChecked(!albumabbruch);
  titelgroupbox->setChecked(!titelabbruch&&!nummerabbruch);
  genregroupbox->setChecked(!genreabbruch);
  jahrgroupbox->setChecked(!jahrabbruch);
  //covergroupbox->setCheckable(TRUE);
}

void tagdialog::boxenholen()
{
  if (settingsfile.mysql)
    {
      database->fillCombo(artistbox,"artists","artistname");
      database->fillCombo(albumbox,"albums","albumname");
      database->fillCombo(genrebox,"genres","genrename");
      database->fillCombo(trackbox,"tracks","trackname");
    }
  else
    {
      //only clear boxes, and put back old values
      QString oldartist=artistbox->currentText();
      QString oldalbum=albumbox->currentText();
      QString oldtrack=trackbox->currentText();
      QString oldgenre=genrebox->currentText();
      artistbox->clear();
      albumbox->clear();
      trackbox->clear();
      genrebox->clear();
      artistbox->setCurrentText(oldartist);
      albumbox->setCurrentText(oldalbum);
      trackbox->setCurrentText(oldtrack);
      genrebox->setCurrentText(oldgenre);
    }
}

void tagdialog::cleanupslot()
{
  //copy all selected filenames into StringList,and give that StringList to cleanuproutine
  QStringList *selectedFiles=new QStringList;
  QString actualfile;
  QListViewItem *pathbuffer;
  QPtrList<QListViewItem>::Iterator index = this->auswahlliste.begin();
  while( index != this->auswahlliste.end())
    {
      pathbuffer=*index;
      actualfile=pathbuffer->text(0);
      while (pathbuffer->parent())//go down directory tree till root
        {
          pathbuffer=pathbuffer->parent();
          if (pathbuffer->text(0).endsWith("/"))
            actualfile=QString("%1%2").arg(pathbuffer->text(0),actualfile);
          else
            actualfile=QString("%1/%2").arg(pathbuffer->text(0),actualfile);
        }
      selectedFiles->append(actualfile);
      index++;
    }
  /*  QStringList::Iterator index2=selectedFiles->begin();
    while (index2!=selectedFiles->end())
      {
        cout<<*index2<<endl;
        index2++;
      }*/
  cleanup *filemove=new cleanup(this);
  if (filemove->filterok&&filemove->directoriesok)
    {
      filemove->cleanupdir(selectedFiles,itemcounter);
      delete filemove;
    }
  else
    delete filemove;
  if (settingsfile.loeschen)
    {
      bool mysqlflag=settingsfile.mysql;
      settingsfile.mysql=FALSE;
      listboxholen();
      settingsfile.mysql=mysqlflag;
    }
}

void tagdialog::artistChanged()
{
  //deactivate all other comboslots,to stop recursion
  if (settingsfile.mysql)
    {
      disconnect(artistbox,SIGNAL(textChanged(const QString &)),this,SLOT(artistChanged()));
      disconnect(albumbox,SIGNAL(textChanged(const QString &)),this,SLOT(albumChanged()));
      disconnect(trackbox,SIGNAL(textChanged(const QString &)),this,SLOT(trackChanged()));
      disconnect(genrebox,SIGNAL(textChanged(const QString &)),this,SLOT(genreChanged()));
      //Read in all Combos, and build a sql-query with them
      QString artist=artistbox->currentText();
      QString album=albumbox->currentText();
      QString genre=genrebox->currentText();
      long artistid=database->translateartist(artist);
      if (!artistid)
        {
          //if no artist with that name in database,reread all boxes
          database->fillCombo(artistbox,"artists","artistname");
          database->fillCombo(albumbox,"albums","albumname");
          database->fillCombo(genrebox,"genres","genrename");
        }
      else
        {
          long albumid=database->translatealbum(album);
          long genreid=database->translategenre(genre);
          QString querystring=QString("artist_id=\"%1\"").arg(artistid);
          database->fillSortedCombo(albumbox,"albums",querystring,"albumname");
          database->fillSortedCombo(genrebox,"tracks",querystring,"genre_id","genres");
          //refetch albumcombo
          album=albumbox->currentText();
          albumid=database->translatealbum(album);
          //Check if a right combination is in the comboboxes, and than modify all songledits
          if(artistid&&albumid)
            {
              querystring=QString("artist_id=\"%1\" AND album_id=\"%2\"").arg(QString::number(artistid),QString::number(albumid));
              database->fillSortedCombo(trackbox,"tracks",querystring,"trackname");
              long year=database->getyear(albumid);
              yearbox->setValue(year);
              //look for tracknumber, and than insert the right track
              int tracknumber=tracknumberbox->value();
              if (tracknumber)
                database->gettrack(trackbox,artistid,albumid,tracknumber);
            }
          else
            {
              querystring=QString("artist_id=\"%1\"").arg(artistid);
              database->fillSortedCombo(trackbox,"tracks",querystring,"trackname");
            }
        }
      //reactivate all slots
      connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
      connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
      connect(trackbox,SIGNAL(textChanged(const QString &)),SLOT(trackChanged()));
      connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
      connect(tracknumberbox,SIGNAL(valueChanged(int)),SLOT(tracknumberChanged(int)));
    }
}

void tagdialog::albumChanged()
{
  if (settingsfile.mysql)
    {
      //deactivate all other comboslots,to stop recursion
      disconnect(artistbox,SIGNAL(textChanged(const QString &)),this,SLOT(artistChanged()));
      disconnect(albumbox,SIGNAL(textChanged(const QString &)),this,SLOT(albumChanged()));
      disconnect(trackbox,SIGNAL(textChanged(const QString &)),this,SLOT(trackChanged()));
      disconnect(genrebox,SIGNAL(textChanged(const QString &)),this,SLOT(genreChanged()));
      //Read in all Combos, and build a sql-query with them
      QString artist=artistbox->currentText();
      QString album=albumbox->currentText();
      QString genre=genrebox->currentText();
      long albumid=database->translatealbum(album);
      if (!albumid)
        {
          //if no album with that name in database,reread all boxes
          database->fillCombo(artistbox,"artists","artistname");
          database->fillCombo(albumbox,"albums","albumname");
          database->fillCombo(genrebox,"genres","genrename");
        }
      else
        {
          long artistid=database->translateartist(artist);
          long genreid=database->translategenre(genre);
          QString querystring=QString("album_id=\"%1\"").arg(albumid);
          database->fillSortedCombo(artistbox,"tracks",querystring,"artist_id","artists");
          database->fillSortedCombo(genrebox,"tracks",querystring,"genre_id","genres");
          //refetch albumcombo
          artist=artistbox->currentText();
          artistid=database->translateartist(artist);
          //Check if a right combination is in the comboboxes, and than modify all songledits
          if(artistid&&albumid)
            {
              querystring=QString("artist_id=\"%1\" AND album_id=\"%2\"").arg(QString::number(artistid),QString::number(albumid));
              database->fillSortedCombo(trackbox,"tracks",querystring,"trackname");
              long year=database->getyear(albumid);
              yearbox->setValue(year);
              //look for tracknumber, and than insert the right track
              int tracknumber=tracknumberbox->value();
              if (tracknumber)
                database->gettrack(trackbox,artistid,albumid,tracknumber);
            }
          else
            {
              querystring=QString("album_id=\"%1\"").arg(albumid);
              database->fillSortedCombo(trackbox,"tracks",querystring,"trackname");
            }
        }
      //reactivate all slots
      connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
      connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
      connect(trackbox,SIGNAL(textChanged(const QString &)),SLOT(trackChanged()));
      connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
    }
}

void tagdialog::genreChanged()
{
  if (settingsfile.mysql)
    {
      //deactivate all other comboslots,to stop recursion
      disconnect(artistbox,SIGNAL(textChanged(const QString &)),this,SLOT(artistChanged()));
      disconnect(albumbox,SIGNAL(textChanged(const QString &)),this,SLOT(albumChanged()));
      disconnect(trackbox,SIGNAL(textChanged(const QString &)),this,SLOT(trackChanged()));
      disconnect(genrebox,SIGNAL(textChanged(const QString &)),this,SLOT(genreChanged()));
      //Read in all Combos, and build a sql-query with them
      QString artist=artistbox->currentText();
      QString album=albumbox->currentText();
      QString genre=genrebox->currentText();
      long genreid=database->translategenre(genre);
      if (!genreid)
        {
          //if no album with that name in database,reread all boxes
          database->fillCombo(artistbox,"artists","artistname");
          database->fillCombo(albumbox,"albums","albumname");
          database->fillCombo(genrebox,"genres","genrename");
        }
      else
        {
          long artistid=database->translateartist(artist);
          long albumid=database->translatealbum(album);
          QString querystring=QString("genre_id=\"%1\"").arg(genreid);
          database->fillSortedCombo(artistbox,"tracks",querystring,"artist_id","artists");
          database->fillSortedCombo(albumbox,"tracks",querystring,"album_id","albums");
          //refetch albumcombo and artistcombo
          album=albumbox->currentText();
          albumid=database->translatealbum(album);
          artist=artistbox->currentText();
          artistid=database->translateartist(artist);
          //Check if a right combination is in the comboboxes, and than modify all songledits
          if(artistid&&albumid)
            {
              querystring=QString("artist_id=\"%1\" AND album_id=\"%2\"").arg(QString::number(artistid),QString::number(albumid));
              database->fillSortedCombo(trackbox,"tracks",querystring,"trackname");
              long year=database->getyear(albumid);
              yearbox->setValue(year);
              //look for tracknumber, and than insert the right track
              int tracknumber=tracknumberbox->value();
              if (tracknumber)
                database->gettrack(trackbox,artistid,albumid,tracknumber);
            }
          else
            {
              querystring=QString("album_id=\"%1\"").arg(albumid);
              database->fillSortedCombo(trackbox,"tracks",querystring,"trackname");
            }
        }
      //reactivate all slots
      connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
      connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
      connect(trackbox,SIGNAL(textChanged(const QString &)),SLOT(trackChanged()));
      connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
    }
}

void tagdialog::trackChanged()
{
  if (settingsfile.mysql)
    {
      disconnect(artistbox,SIGNAL(textChanged(const QString &)),this,SLOT(artistChanged()));
      disconnect(albumbox,SIGNAL(textChanged(const QString &)),this,SLOT(albumChanged()));
      disconnect(trackbox,SIGNAL(textChanged(const QString &)),this,SLOT(trackChanged()));
      disconnect(genrebox,SIGNAL(textChanged(const QString &)),this,SLOT(genreChanged()));
      //Read in all Combos, and build a sql-query with them
      QString artist=artistbox->currentText();
      QString album=albumbox->currentText();
      QString genre=genrebox->currentText();
      QString track=trackbox->currentText();
      long genreid=database->translategenre(genre);
      long artistid=database->translateartist(artist);
      long albumid=database->translatealbum(album);
      QString querystring=QString("trackname=\"%1\"").arg(track);
      database->fillSortedCombo(artistbox,"tracks",querystring,"artist_id","artists");
      database->fillSortedCombo(albumbox,"tracks",querystring,"album_id","albums");
      database->fillSortedCombo(genrebox,"tracks",querystring,"genre_id","genres");
      //reactivate all slots
      connect(artistbox,SIGNAL(textChanged(const QString &)),SLOT(artistChanged()));
      connect(albumbox,SIGNAL(textChanged(const QString &)),SLOT(albumChanged()));
      connect(trackbox,SIGNAL(textChanged(const QString &)),SLOT(trackChanged()));
      connect(genrebox,SIGNAL(textChanged(const QString &)),SLOT(genreChanged()));
    }
}

void tagdialog::tracknumberChanged(int tracknumber)
{
  if (settingsfile.mysql)
    {
      disconnect(trackbox,SIGNAL(textChanged(const QString &)),this,SLOT(trackChanged()));
      QString artist=artistbox->currentText();
      QString album=albumbox->currentText();
      QString querystring;
      long artistid=database->translateartist(artist);
      long albumid=database->translatealbum(album);
      if(artistid&&albumid)
        {
          querystring=QString("artist_id=\"%1\" AND album_id=\"%2\"").arg(QString::number(artistid),QString::number(albumid));
          database->fillSortedCombo(trackbox,"tracks",querystring,"trackname");
          long year=database->getyear(albumid);
          yearbox->setValue(year);
          //look for tracknumber, and than insert the right track
          int tracknumber=tracknumberbox->value();
          if (tracknumber)
            database->gettrack(trackbox,artistid,albumid,tracknumber);
        }
      else
        {
          querystring=QString("album_id=\"%1\"").arg(albumid);
          database->fillSortedCombo(trackbox,"tracks",querystring,"trackname");
        }
      connect(trackbox,SIGNAL(textChanged(const QString &)),SLOT(trackChanged()));
    }
}
