/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _VERZEICHNIS_H_
#define _VERZEICHNIS_H_

#include <qstring.h>
#include <qstringlist.h>
#include <qdir.h>
#include <qmessagebox.h>

#include <iostream>

#include "taglibschnittstelle.h"

#include "mysqlinterface.h"
#include "tagdialog.h"
#include "rcdatei.h"
#include "tableiste.h"
#include "progress.h"

class tagdialog;

class verzeichnis : public QObject
  {
    Q_OBJECT
    friend class aufraeumendialog;
  private:
    QDir *arbeitsverzeichnis;
    QStringList verzeichnisliste;
    QStringList dateiliste;
    long vzaehler;
    long dzaehler;
    long progress;
    friend class tagdialog;
  public:
    bool vor;
    bool abortscan;
    bool abbruch;
    verzeichnis(QString);
    ~verzeichnis();
    QString verzeichnisname;
    void rekursivmodus(QString);
    void treemodus(QString,QListViewItem *,progressinfo *);
    void scanverzeichnis(progresswithbar *);
    int musikgefunden();
    void zaehlen();
  public slots:
  void abbruchslot();
  };


#endif  //_VERZEICHNIS_H_
