/***************************************************************************
 *
 *  $Id: kzencategorydialog.cpp,v 1.4 2005/06/02 07:09:01 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <klocale.h>

#include <qlayout.h>
#include <qheader.h>
#include <qlabel.h>

#include "kzencategories.h"

#include "kzencategorydialog.h"

KZenCategoryDialog::KZenCategoryDialog(QWidget* parent, const char* name)
  :KDialogBase(parent, name, true, i18n("Category - KZenExplorer"), Ok|Cancel)
{
  makeVBoxMainWidget();
  
  QWidget * privateLayoutWidget = new QWidget(mainWidget(), "privateLayoutWidget");
  QVBoxLayout * fTopLayout = new QVBoxLayout(privateLayoutWidget, 11, 6, "TopLayout"); 

  QLabel * label = new QLabel(i18n("Please select categories for the selected tracks"),
			      privateLayoutWidget);

  fTopLayout->addWidget(label);

  fCategories = new KListView(privateLayoutWidget,"categories");
  fCategories->addColumn("Category");
  fCategories->setSorting(-1);
  fCategories->header()->hide();
  
  fTopLayout->addWidget(fCategories);
  
  fItems.setAutoDelete(false);
  
  QCheckListItem * last = 0;
  for (uint i=0;i<gCategories->count();i++) {
    if (last==0) {
      last = new QCheckListItem(fCategories,gCategories->category(i),QCheckListItem::CheckBox);
    } else {
      last = new QCheckListItem(fCategories,last,gCategories->category(i),QCheckListItem::CheckBox);
    }
    fItems.append(last);
  }
}

uint KZenCategoryDialog::count()
{
  return fItems.count();
}

bool KZenCategoryDialog::isChecked(uint idx)
{
  return fItems.at(idx)->isOn();
}

void KZenCategoryDialog::setChecked(uint idx, bool value)
{
  fItems.at(idx)->setOn(value);
}

void KZenCategoryDialog::setTrack(KZenTrack * track)
{
  for (uint i=0;i<track->getCategories().size();i++) {
    fItems.at(i)->setOn(track->getCategories().testBit(i));
  }
}

KZenCategoryDialog::~KZenCategoryDialog()
{
  
}

void KZenCategoryDialog::languageChange()
{
  setCaption(i18n("Category - KZenExplorer"));
}

#include "kzencategorydialog.moc"
