/***************************************************************************
 *
 *  $Id: kzenconfig.cpp,v 1.13 2005/07/01 23:25:17 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <libnjb.h>

#include <kdebug.h>
#include <kglobalsettings.h>
#include <klocale.h>

#include "kzenconfig.h"

KZenConfig * KZenConfig::fgConfig = 0;

KZenConfig::KZenConfig()
{
  fLocalLibrary.setPath(KGlobalSettings::documentPath());
  fSavePath = "%artist/%album";
  fSaveName = "%artist-%title";
  fShowDetailsArtist = true;
  fShowDetailsAlbum = true;
  fShowDetailsGenre = true;
  fShowDetailsPlayList = true;
  fSmartImport = true;
  fQuickStart = false;
  fSyncLibrary = true;
  fSyncPlayLists = true;
  fPlayListOverride = true;
  fCaseSensitiveSearch = false;
  fExactSearch = true;
}

KZenConfig::~KZenConfig()
{

}

KZenConfig * KZenConfig::get()
{
  if (!fgConfig) {
    fgConfig = new KZenConfig();
  }
  return fgConfig;
}

void KZenConfig::saveConfig(KConfig * cfg)
{
  kdDebug() << "saveConfig" << endl;

  cfg->setGroup("General");

  cfg->writeEntry("Library", fLocalLibrary.path());
  cfg->writeEntry("SavePath", fSavePath);
  cfg->writeEntry("SaveName", fSaveName);
  cfg->writeEntry("ShowDetailsArtist", fShowDetailsArtist);
  cfg->writeEntry("ShowDetailsAlbum", fShowDetailsAlbum);
  cfg->writeEntry("ShowDetailsGenre", fShowDetailsGenre);
  cfg->writeEntry("ShowDetailsPlayList", fShowDetailsPlayList);
  cfg->writeEntry("SmartImport", fSmartImport);
  cfg->writeEntry("QuickStart", fQuickStart);

  cfg->setGroup("Synchronization");

  cfg->writeEntry("SyncLibrary", fSyncLibrary);
  cfg->writeEntry("ExcludeFromSync", fExcludeFromSync);
  cfg->writeEntry("SyncPlayLists", fSyncPlayLists);
  cfg->writeEntry("PlayListOverride", fPlayListOverride);

  cfg->setGroup("Search");
  cfg->writeEntry("CaseSensitive", fCaseSensitiveSearch);
  cfg->writeEntry("Exact", fExactSearch);
}

void KZenConfig::readConfig(KConfig * cfg)
{
  kdDebug() << "readConfig" << endl;

  if (cfg->hasGroup("General")) {
    cfg->setGroup("General");
    
    QString path = cfg->readEntry("Library",
				  KGlobalSettings::documentPath());
    kdDebug() << "Library=" << path << endl;
    fLocalLibrary.setPath(path);
    if (!fLocalLibrary.isValid() && !fLocalLibrary.isLocalFile()) {
      fLocalLibrary.setPath(KGlobalSettings::documentPath());
    }
    
    fSavePath = cfg->readEntry("SavePath", "%artist/%album");
    kdDebug() << "SavePath=" << fSavePath << endl;

    fSaveName = cfg->readEntry("SaveName", "%artist-%title");
    kdDebug() << "SaveName=" << fSaveName << endl;

    fShowDetailsArtist = cfg->readBoolEntry("ShowDetailsArtist", true);
    kdDebug() << "ShowDetailsArtist=" << fShowDetailsArtist << endl;

    fShowDetailsAlbum = cfg->readBoolEntry("ShowDetailsAlbum", true);
    kdDebug() << "ShowDetailsAlbum=" << fShowDetailsAlbum << endl;

    fShowDetailsGenre = cfg->readBoolEntry("ShowDetailsGenre", true);
    kdDebug() << "ShowDetailsGenre=" << fShowDetailsGenre << endl;

    fShowDetailsPlayList = cfg->readBoolEntry("ShowDetailsPlayList", true);
    kdDebug() << "ShowDetailsPlayList=" << fShowDetailsPlayList << endl;

    fSmartImport = cfg->readBoolEntry("SmartImport", true);
    kdDebug() << "SmartImport=" << fSmartImport << endl;
  }

  if (cfg->hasGroup("Synchronization")) {
    cfg->setGroup("Synchronization");
    
    fSyncLibrary = cfg->readBoolEntry("SyncLibrary", true);
    kdDebug() << "SyncLibrary=" << fSyncLibrary << endl;    

    fExcludeFromSync = cfg->readListEntry("ExcludeFromSync");
    
    fSyncPlayLists = cfg->readBoolEntry("SyncPlayLists", true);
    kdDebug() << "SyncPlayLists=" << fSyncPlayLists << endl;    

    fPlayListOverride = cfg->readBoolEntry("PlayListOverride", true);
    kdDebug() << "PlayListOverride=" << fPlayListOverride << endl;
  }

  if (cfg->hasGroup("Search")) {
    cfg->setGroup("Search");
    
    fCaseSensitiveSearch = cfg->readBoolEntry("CaseSensitive", false);
    kdDebug() << "CaseSensitiveSearch=" << fCaseSensitiveSearch << endl;    
    
    fExactSearch = cfg->readBoolEntry("Exact", true);
    kdDebug() << "ExactSearch=" << fExactSearch << endl;    
  }
}

void KZenConfig::setExcludeFromSync(const QStringList & l)
{
  fExcludeFromSync = l;
}
