/***************************************************************************
 *
 *  $Id: kzenexplorerview.h,v 1.25 2005/07/03 18:27:52 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENEXPLORERVIEW_H
#define KZENEXPLORERVIEW_H

#include <qwidget.h>
#include <qsplitter.h>
#include <qptrlist.h>

#include <klistview.h>
#include <kaction.h>
#include <kmultitabbar.h>

#include "kzenglobal.h"
#include "kzentrack.h"
#include "kzenartist.h"
#include "kzengenre.h"
#include "kzenalbum.h"
#include "kzenplaylist.h"
#include "kzensmartplaylist.h"
#include "kzennavigationview.h"
#include "kzentrackview.h"
#include "kzenusagebar.h"

class KPopupMenu;

class KZenExplorer;
class KZenItem;

/**
@author Andreas Mussgiller
*/
class KZenExplorerView : public QWidget , public KZen
{
  Q_OBJECT

 public:

  KZenExplorerView(KZenExplorer * parent, const char *name);
  ~KZenExplorerView();
  
  void                        setupActions();

  void                        displayTrackList(QPtrList<KZenTrack> *, ViewMode vm);
  void                        displayTrackListPL(KZenPlayList * pl);
  void                        displayArtistList(QPtrList<KZenArtist> *);
  void                        displayGenreList(QPtrList<KZenGenre> *);
  void                        displayPlayLists(QPtrList<KZenPlayList> *,
					       QPtrList<KZenSmartPlayList> *);

  QPtrList<KZenTrack> *       currentTrackList() { return fCurrentTrackList; }

  void                        trackUpdated(KZenTrack *);

  void                        addTrack(KZenTrack * track);
  void                        setSearchText(const char * text);
  void                        setSortColumn(KZen::TagField c);

  int                         getNaviWidth();
  void                        setNaviWidth(int w);

  QPtrList<KZenTrackItem> &   selectedTracks();

  void                        refresh();

 public slots:

  void                        contextMenuTracks(QListViewItem * item, const QPoint & pos, int col);
  void                        contextMenuNavi(QListViewItem * item, const QPoint & pos, int col);

  void                        removeTrackItem(KZenTrackItem *);
  void                        removeNaviItem(KZenItem *);

  void                        selectNaviItem(KZenItem *);
  void                        selectionChangedNavi(QListViewItem *);

  void                        removeArtist(const char *);
  void                        removeGenre(const char *);
  void                        removeAlbum(const char *, const char *);

  void                        playTracks();
  void                        queueTracks();
  void                        editTracks();
  void                        saveTracks();
  void                        deleteTracks();
  void                        destroyTracks();

  void                        renamePlayList();
  void                        editSmartPlayList();
  void                        updatePlayList();
  void                        deleteNaviItem();
  void                        destroyNaviItem();

  void                        shufflePlayList();

  void                        addPlayList(KZenPlayList * pl, bool showtab = true);
  void                        addPlayList(KZenSmartPlayList * pl, bool showtab = true);
  
  void                        setUsage(int used, int total);
  void                        setBusy(bool busy = true);

  void                        selectAll();

  void                        naviTabClicked(int);

  void                        isCompilationClicked();

  void                        showDetails();

 signals:

  void                        editTracks(QPtrList<KZenTrackItem> &);
  void                        deleteTracks(QPtrList<KZenTrackItem> &, KZenPlayList * pl);
  void                        destroyTracks(QPtrList<KZenTrackItem> &);
  
 private:

  void                        setArtistsVisible(bool visible);
  void                        setAlbumsVisible(bool visible);
  void                        setGenresVisible(bool visible);
  void                        setPlayListsVisible(bool visible);

  KZenExplorer               *fExplorer;
  ViewMode                    fViewMode;
  KZenPlayList               *fPlayList;

  KMultiTabBar               *fNaviBar;
  int                         fCurrentNaviTab;

  QSplitter                  *fMainSplitter;
  KZenNavigationView         *fNaviView;
  int                         fNaviWidth;
  QPtrList<KZenArtistItem>    fArtistItems;
  QPtrList<KZenGenreItem>     fGenreItems;
  QPtrList<KZenAlbumItemTL>   fAlbumItems;
  QPtrList<KZenPlayListItem>  fPlayListItems;

  QPtrList<KZenTrack> *       fCurrentTrackList;

  KZenTrackView              *fTrackView;

  KZenUsageBar               *fUsageBar;

  KZenItem                   *fAllArtists;
  KZenItem                   *fCurrentNaviItem;

  KPopupMenu                 *fTrackContextMenu;
  KAction                    *fPlayTracks;
  KAction                    *fQueueTracks;
  KAction                    *fStopPlay;
  KAction                    *fEditTracks;
  KAction                    *fSaveTracks;
  KAction                    *fDeleteTracks;
  KAction                    *fDestroyTracks;

  KPopupMenu                 *fNaviContextMenuJukebox;

  KPopupMenu                 *fNaviContextMenuAlbum;

  KPopupMenu                 *fNaviContextMenuPlayList;
  KPopupMenu                 *fNaviContextMenuSmartPlayList;

  KAction                    *fNewPlayList;
  KAction                    *fNewSmartPlayList;
  KAction                    *fRenamePlayList;
  KAction                    *fEditSmartPlayList;
  KAction                    *fShufflePlayList;
  KAction                    *fUpdatePlayList;
  KAction                    *fDeletePlayList;
  KAction                    *fDestroy;
  KAction                    *fSelectAll;
  KAction                    *fPlayListFromSelection;
  KAction                    *fIsCompilation;
  KAction                    *fShowDetails;

  bool                        fBusy;
};

extern QWidget * fgTrackSource;
extern QWidget * fgNaviSource;

#endif
