/***************************************************************************
 *
 *  $Id: kzenglobal.h,v 1.12 2005/06/15 11:13:18 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENGLOBAL_H
#define KZENGLOBAL_H

#include <qcolor.h>

#include <klistview.h>

class KZenArtistItem;

/**
@author Andreas Mussgiller
*/
class KZen
{
 public:

  enum NavigationTabs {
    TabAll = 0,
    TabArtists,
    TabAlbums,
    TabGenres,
    TabPlayLists
  };

  enum ViewMode {
    ViewModeAll = 0,
    ViewModeSearch,
    ViewModeArtist,
    ViewModeAlbum,
    ViewModePlayList
  };
  
  enum TagField {
    FieldArtist = 0,
    FieldAlbum,
    FieldTitle,
    FieldTrack,
    FieldGenre,
    FieldYear,
    FieldLength,
    FieldCodec,
    FieldRating,
    FieldCategory,
    FieldUnknown    
  };
  
  enum TagFieldType {
    FieldTypeText = 0,
    FieldTypeInt,
    FieldTypeRating,
    FieldTypeTime,
    FieldTypeUnknown
  };

  static int                  getColumn(TagField field);

  static const char *         getTitle(int c);
  static const int            getWidth(int c);
  static TagField             getTagField(int c);
  static TagFieldType         getTagFieldType(int c);
  static Qt::AlignmentFlags   getAlignment(int c);
  static QListView::WidthMode getWidthMode(int c);
  static bool                 getResizable(int c);
  static bool                 getRenameable(int c);

  static QString              formatTime(uint);

  static KZenArtistItem *     artistItem(QListViewItem *);

  static const QColor         backgroundColor(KListViewItem * item, int column = 0);
};

#endif
