//LabPlot : GraphIMAGE.h

#ifndef GRAPHIMAGE_H
#define GRAPHIMAGE_H

#include <qpixmap.h>
#include <qtextstream.h>
#include <qprogressdialog.h>
#include "Graph.h"

class GraphIMAGE: public Graph
{
public:
	GraphIMAGE(QString n="", QString l="", LRange r[3]=0, LSource src=SFUNCTION, PType t=PSURFACE, Style *st=0, 
		Symbol *sy=0, QPixmap pm=0, int dimx=0, int dimy=0, bool s=true);
	GraphIMAGE *Clone();		// clone this graph
	QPixmap Pixmap() { return pixmap; }
	void setPixmap(QPixmap pm) { pixmap = pm; }
	LRange Range(int i) { return range[i]; }
	void setRange(LRange r[3]) { range[0]=r[0];range[1]=r[1];range[2]=r[2]; }
	int width() { return (int)range[0].rMax(); }
	int height() { return (int)range[1].rMax(); }
	void setWidth(int w) { range[0] = LRange(0,w); }
	void setHeight(int h) { range[1] = LRange(0,h); }
	QStringList Info();
	void save(QTextStream *t);
	void open(QTextStream *t, int version, QProgressDialog *progress);
	void saveXML(QDomDocument doc, QDomElement graphtag);
	void openXML(QDomNode node);
private:
	LRange range[3];
	QPixmap pixmap;
};

#endif // GRAPHIMAGE_H
