//LabPlot : LImage.cc

#include <iostream>
#include <qimage.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include "LImage.h"

using namespace std;

LImage::LImage(Point p,QString n, double s, double a) {
	pos = p;
	name = n;
	scale = s;
	angle = a;
}

QStringList LImage::Info() {
	QStringList s;

	if(name.isEmpty())
		return s;

	s << QString::number(pos.X())+"/"+QString::number(pos.Y());
	s << name;
	s << QString::number(scale);
	s << QString::number(angle);

	return s;
}

// draw the image on the worksheet
void LImage::draw(QPainter *p, double X, double Y) {
	//kdDebug()<<"DRAW Image \n";

	if (!name.isEmpty()) {
		int x = (int) (pos.X()*X);
		int y = (int) (pos.Y()*Y);
		QImage *image = new QImage(name);
		if (!image) { 
			kdDebug()<<"Error opening image !"<<endl;
		}
		else {
			QImage tmpimage = image->smoothScale((int)(image->width()*scale),
				(int)(image->height()*scale),QImage::ScaleMin);
			p->translate(x,y);
			p->rotate(angle);
			p->drawImage(0,0,tmpimage);
			p->rotate(-angle);
			p->translate(-x,-y);
		}
	}
}

// save
void LImage::save(QTextStream *t) {
	*t<<pos.X()<<' '<<pos.Y()<<endl;
	*t<<name<<endl;
	*t<<scale<<' '<<angle<<endl;
}

// open
void LImage::open(QTextStream *t,int) {
//	kdDebug()<<"LImage::open() : "<<version<<endl;
	double x,y;
	
	*t>>x>>y;
	pos.setPoint(x,y);
	t->readLine();
	name=t->readLine();
	*t>>scale>>angle;

//	kdDebug()<<"X/Y :"<<x<<' '<<y<<endl;
//	kdDebug()<<"IMAGE :"<<name<<' '<<scale<<' '<<angle<<endl;
}

QDomElement LImage::saveXML(QDomDocument doc) {
	QDomElement imagetag = doc.createElement( "Image" );

	QDomElement tag = doc.createElement( "Position" );
	tag.setAttribute("x",pos.X());
	tag.setAttribute("y",pos.Y());
    	imagetag.appendChild( tag );
	tag = doc.createElement( "Name" );
    	imagetag.appendChild( tag );
  	QDomText t = doc.createTextNode( name );
    	tag.appendChild( t );
	tag = doc.createElement( "Scale" );
    	imagetag.appendChild( tag );
  	t = doc.createTextNode( QString::number(scale) );
    	tag.appendChild( t );
	tag = doc.createElement( "Angle" );
    	imagetag.appendChild( tag );
  	t = doc.createTextNode( QString::number(angle) );
    	tag.appendChild( t );
	
	return imagetag;
}

void LImage::openXML(QDomNode node) {
	while(!node.isNull()) {
		QDomElement e = node.toElement();
		kdDebug()<<"IMAGE TAG = "<<e.tagName()<<endl;
		kdDebug()<<"IMAGE TEXT = "<<e.text()<<endl;
	
		if(e.tagName() == "Position")
			pos.setPoint(e.attribute("x").toDouble(),e.attribute("y").toDouble());
		else if(e.tagName() == "Name")
			name = e.text();
		else if(e.tagName() == "Scale")
			scale = e.text().toDouble();
		else if(e.tagName() == "Angle")
			angle = e.text().toDouble();

		node = node.nextSibling();
	}
}

bool LImage::inside(int x, int y, int w, int h) {
	if(name.isEmpty())
		return false;
		
	QImage *image = new QImage(name);
	
	if (x>pos.X()*w && x<pos.X()*w+image->width()*scale &&
		y>pos.Y()*h && y<pos.Y()*h+image->height()*scale )
		return true;

	return false;
}
