/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_XMALLOC_H__
#define __LADCCA_XMALLOC_H__


#ifdef LADCCA_BUILD
#define _GNU_SOURCE
#include "ac-config.h"
#endif /* LADCCA_BUILD */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif


#ifdef LADCCA_DEBUG

#define cca_malloc   malloc
#define cca_realloc  realloc
#define cca_strdup   strdup

#else

#define cca_malloc   cca_xmalloc
#define cca_realloc  cca_xrealloc
#define cca_strdup   cca_xstrdup

#endif

void * cca_malloc0  (size_t);


void * cca_xmalloc  (size_t);
void * cca_xrealloc (void *, size_t);
char * cca_xstrdup  (const char *);



#ifdef __cplusplus
}
#endif

#endif /* __LADCCA_XMALLOC_H__ */
