/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QDebug>
#include <QPainter>

#include "watermarkbox.h"


WatermarkBox::WatermarkBox( QWidget *parent )
    : QGroupBox( parent )
{
}


void
WatermarkBox::paintEvent( QPaintEvent *event )
{
    QGroupBox::paintEvent( event );

    QPainter painter( this );
    painter.drawPixmap( frameGeometry().width() - m_watermark.size().width() - 1, frameGeometry().top(), m_watermark );
    painter.end();
}
