/*
 * $Id: cmd_hwpath.c,v 1.1 2004/12/21 23:26:18 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003 - 2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <lcrash.h>
#include <kl_hwgraph.h>

/* Function prototypes
 */
void print_pathnames(command_t *, path_t *);

/*
 * hwpath_cmd() -- Run the 'hwpath' command.
 */
int
hwpath_cmd(command_t *cmd)
{
	path_t *path;

	if (cmd->nargs == 0) {
		if ((path = kl_get_hw_pathnames(K_PERM))) {
			print_pathnames(cmd, path);
		}
		kl_free_path_table(path);
	} else {
	}
	return(0);
}

#define _HWPATH_USAGE "[-f] [-w outfile] [element_list]"

/*
 * hwpath_usage() -- Print the usage string for the 'hwpath' command.
 */
void
hwpath_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _HWPATH_USAGE);
}

/*
 * hwpath_help() -- Print the help information for the 'hwpath' command.
 */
void
hwpath_help(command_t *cmd)
{
	CMD_HELP(cmd, _HWPATH_USAGE,
		"Display all hwgraph pathnames that terminate with the "
		"names included in element_list, or that contain label "
		"names included in element_list. If no names are "
		"specified, display all unique pathnames in the hwgraph. "
		"Unique pathnames are ones that terminate in a file or "
		"symbolic link rather than in a directory. Note that the "
		"hwpath command provides a view of the hwgraph similar "
		"to the filesystem-like representation presented on the "
		"system.");
}

/*
 * hwpath_parse() -- Parse the command line arguments for 'hwpath'.
 */
int
hwpath_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, (C_FULL|C_WRITE|C_NEXT|C_ALL), 0)) {
		return(1);
	}
	return(0);
}

/*
 * hwpath_complete() -- Complete arguments of 'hwpath' command.
 */
char *
hwpath_complete(command_t *cmd)
{
	char *ret;

	/* complete standard options (for example, -w option) arguments
	 */
	if ((ret = complete_standard_options(cmd)) != NOT_COMPLETED) {
		return(ret);
	}
	fprintf(cmd->ofp, "\n");
	hwpath_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
