/*
 * $Id: cmd_info.c,v 1.1 2004/12/21 23:26:18 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

#define C_SFLAG (1 << C_LFLG_SHFT)

static char *keyword;
#define _STR_ENDIAN   "endian"
#define _STR_ARCH     "arch"
#define _STR_PTRSZ    "psize"
#define _STR_MEMSIZE  "memsize"
#define _STR_KRELEASE "krelease"
#define _STR_NUMCPUS  "numcpus"

/* Forward declaration
 */
void info_usage(command_t *);

int
info_cmd(command_t *cmd)
{
	int what = 0;

	if ((cmd->flags & C_SFLAG) && (!cmd->nargs)){
		if(!strcmp(keyword, _STR_ENDIAN)){
			what = KL_INFO_ENDIAN;
		} else if(!strcmp(keyword, _STR_ARCH)){
			what = KL_INFO_ARCH;
		} else if(!strcmp(keyword, _STR_PTRSZ)){
			what = KL_INFO_PTRSZ;
		} else if(!strcmp(keyword, _STR_KRELEASE)){
			what = KL_INFO_KRELEASE;
		} else if(!strcmp(keyword, _STR_MEMSIZE)){
			what = KL_INFO_MEMSIZE;
		} else if(!strcmp(keyword, _STR_NUMCPUS)){
			what = KL_INFO_NUMCPUS;
		} else {
			fprintf(KL_ERRORFP, "Invalid argument for '-s' option:"
				" %s\n", keyword);
			info_usage(cmd);
			return(1);
		}
		kl_print_dumpinfo(what);
	} else if(!(cmd->nargs) ){
		kl_print_dumpinfo(0);
	} else {
		fprintf(KL_ERRORFP, "Invalid commandline.\n");
		info_usage(cmd);
		return(1);
	}

	return(0);
}

#define _INFO_USAGE \
"\n        [-s keyword]"\
"\n        [-w outfile]"

#define _INFO_HELP \
"\nPrint dump information.\n"\
"\n -s keyword"\
"\n       Print information for specified keyword only."\
"\n       keyword can be one of \"numcpus\", \"krelease\","\
"\n       \"memsize\", \"arch\", \"endian\" or \"psize\".\n"

void
info_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _INFO_USAGE);
}

void
info_help(command_t *cmd)
{
	CMD_HELP(cmd, _INFO_USAGE, _INFO_HELP);
}

int
info_parse(command_t *cmd)
{
	option_t *op;

	keyword = NULL;

	if (set_cmd_flags(cmd, C_WRITE|C_SFLAG, "s:")) {
		return(1);
	}
	op = cmd->options;
	while (op) {
		switch(op->op_char) {
			case 's':
				cmd->flags |= C_SFLAG;
				keyword = op->op_arg;
				break;
		}
		op = op->op_next;
	}
	return(0);
}

/*
 * info_complete() -- Complete arguments of 'info' command.
 */
char *
info_complete(command_t *cmd)
{
	fprintf(cmd->ofp, "\n");
	info_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
