/*
 * $Id: cmd_rd_i386.c,v 1.2 2005/02/23 19:31:21 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

extern int defcpu;

#define _RD_USAGE "[-w outfile]"

void
rd_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _RD_USAGE);
}

void
rd_help(command_t *cmd)
{
	CMD_HELP(cmd, _RD_USAGE,
			"Display the register contents of the default cpu."
			"This command can't be used on a live system ");
}

int
rd_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, (C_WRITE), 0)) {
		return(1);
	}
	return 0;
}

int
rd_cmd(command_t *cmd)
{
	kl_dump_header_i386_t dha;
	struct kl_pt_regs_i386 * regs;

	if (cmd->nargs != 0) {
		rd_usage(cmd);
		return(1);
	}	

	if (CORE_IS_KMEM) {
		fprintf(cmd->efp, "Can't use this command on live system\n");
		return(1);
	}
	
	if (kl_get_dump_header_i386(&dha))
		return(1);

	if (defcpu == -1)
		defcpu = dha.dumping_cpu;
	
	regs = &dha.smp_regs[defcpu];

	fprintf(cmd->ofp, "CPU:    %d   EIP:    %04x:[<%08x>]\nEFLAGS: %08x\n",
		defcpu, regs->xcs & 0xffff, regs->eip, regs->eflags);
	fprintf(cmd->ofp, "eax: %08x   ebx: %08x   ecx: %08x   edx: %08x\n",
		regs->eax, regs->ebx, regs->ecx, regs->edx);
	fprintf(cmd->ofp, "esi: %08x   edi: %08x   ebp: %08x   esp: %08x\n",
		regs->esi, regs->edi, regs->ebp, regs->esp);
	fprintf(cmd->ofp, "ds: %04x   es: %04x   ss: %04x\n",
		regs->xds & 0xffff, regs->xes & 0xffff, regs->xss & 0xffff);

	return(0);
}
