/*
 * $Id: cmds_ia64.c,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002, 2004 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright (C) 2003 NEC Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

extern int defcpu_ia64_cmd(command_t *), defcpu_ia64_parse(command_t *);
extern void defcpu_ia64_help(command_t *), defcpu_ia64_usage(command_t *);

extern int rd_ia64_cmd(command_t *), rd_ia64_parse(command_t *);
extern void rd_ia64_help(command_t *), rd_ia64_usage(command_t *);

extern int unwind_cmd(command_t *), unwind_parse(command_t *);
extern void unwind_help(command_t *), unwind_usage(command_t *);
extern char *unwind_complete(command_t *);

_command_t cmdset_ia64[] = {
	{"defcpu", 0, defcpu_ia64_cmd, defcpu_ia64_parse, defcpu_ia64_help,
	 defcpu_ia64_usage, NULL},
	{"rd", 0, rd_ia64_cmd, rd_ia64_parse, rd_ia64_help, rd_ia64_usage, NULL},
	{"unwind", 0, unwind_cmd, unwind_parse, unwind_help,
	 unwind_usage, unwind_complete},
	{(char *)0 }
};
