/*
 * $Id: pci.c,v 1.1 2004/12/21 23:26:17 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003 - 2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <lcrash.h>
#include <kl_libhwconfig.h>

/*
 * cpu_banner()
 */
void
cpu_banner(FILE *ofp, int flags)
{
        if (flags & BANNER) {
                fprintf(ofp, "CPU    BRICK           VENDOR   ARCH     "
			"FAMILY  REV  SPEED\n");
	}

        if (flags & SMAJOR) {
                fprintf(ofp, "========================================="
                	"==================\n");

        } else if (flags & SMINOR) {
                fprintf(ofp, "-----------------------------------------"
                	"------------------\n");
        }
}

/*
 * print_cpu_info()
 */
int
print_cpu_info(cpuinfo_t *cpu, FILE *ofp, int flags)
{
	int val;
	uint64_t proc_freq;
	char family[32];
	char *vendor;

	fprintf(ofp, "%3d    ", cpu->id);

	fprintf(ofp, "       ");

	vendor = (char *)(unsigned long)cpu->ptr + 
		kl_member_offset("cpuinfo_ia64", "vendor");

	fprintf(ofp, "%15s  IA-64  ", vendor);

	val = KL_UINT(cpu->ptr, "cpuinfo_ia64", "family");
        switch (val) {
		case 0x07:
			memcpy(family, "Itanium", 8); 
			break;
		case 0x1f:
			memcpy(family, "Itanium 2", 10); 
			break;
		default:          
			sprintf(family, "%u", val); 
			break;
        }
	fprintf(ofp, "%s  ", family);

	val = KL_UINT(cpu->ptr, "cpuinfo_ia64", "revision");
	fprintf(ofp, "%3d  ", val);

	proc_freq = KL_UINT(cpu->ptr, "cpuinfo_ia64", "proc_freq");
	fprintf(ofp, "%5ld", (proc_freq / 1000000));

	fprintf(ofp, "\n");
	return(0);
}

/*
 * pci_dev_banner()
 */
void
pci_dev_banner(FILE *ofp, int flags)
{
        if (flags & BANNER) {
                fprintf(ofp, "BUS SLOT FUN   CLASS VENDOR DEVICE\n");
	}

        if (flags & SMAJOR) {
                fprintf(ofp, "======================================\n");

        } else if (flags & SMINOR) {
                fprintf(ofp, "--------------------------------------\n");
        }
}

/*
 * print_pci_dev()
 */
int
print_pci_dev(pci_dev_t *pci_dev, FILE *ofp, int flags)
{
	pci_device_t *pcidevp;

	fprintf(ofp, "%3d %4d %3d  %6x %6x %6x  ",
		pci_dev->bus_num,
		pci_dev->slot_num,
		pci_dev->fun_num,
		pci_dev->class,
		pci_dev->vendor,
		pci_dev->device);
	pcidevp = find_pci_device(pci_dev->vendor, pci_dev->device);
	if (pcidevp) {
		fprintf(ofp, "%s\n", pcidevp->DevDesc);
	} else {
		fprintf(ofp, "PCI_DEVICE\n");
	}
	return(0);
}
