/*
 * $Id: kl_dump_s390x.c,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <klib.h>

/*
 * function declarations
 */
int kl_write_dha_s390x(void*);

int
kl_set_dumparch_s390x(void)
{
	KLP->dump->arch.pageoffset = KL_PAGE_OFFSET_S390X;
	KLP->dump->arch.kstacksize = KL_KSTACK_SIZE_S390X;
	KLP->dump->arch.pageshift = KL_PAGE_SHIFT_S390X;
	KLP->dump->arch.pagesize = KL_PAGE_SIZE_S390X;
	KLP->dump->arch.pagemask = KL_PAGE_MASK_S390X;
	KLP->dump->arch.pgdshift = KL_PGDIR_SHIFT_S390X;
	KLP->dump->arch.pgdsize = KL_PGDIR_SIZE_S390X;
	KLP->dump->arch.pgdmask = KL_PGDIR_MASK_S390X;
	KLP->dump->arch.pmdshift = KL_PMD_SHIFT_S390X;
	KLP->dump->arch.pmdsize = KL_PMD_SIZE_S390X;
	KLP->dump->arch.pmdmask = KL_PMD_MASK_S390X;
	KLP->dump->arch.ptrsperpgd = KL_PTRS_PER_PGD_S390X;
	KLP->dump->arch.ptrsperpmd = KL_PTRS_PER_PMD_S390X;
	KLP->dump->arch.ptrsperpte = KL_PTRS_PER_PTE_S390X;
	KLP->dump->arch.kernelstack = kl_kernelstack_s390x;
	KLP->dump->arch.mmap_virtop = kl_mmap_virtop_s390x;
	KLP->dump->arch.dha_size = sizeof(kl_dump_header_s390_t);
	KLP->dump->arch.write_dha = kl_write_dha_s390x;
	return(0);
}

/*
 * kl_write_dha_s390x()
 */
int
kl_write_dha_s390x(void *buf)
{
	kl_dump_header_s390_t dha;

	memset(&dha, 0, sizeof(dha));

 	dha.magic_number = KL_DUMP_MAGIC_NUMBER_S390;
 	dha.version = KL_DUMP_VERSION_NUMBER_S390;
 	dha.header_size = sizeof(dha);

	memcpy(buf, &dha, dha.header_size);

	return(0);
}
