#ifndef __mem_h
#define __mem_h

#ifndef MEM_ALIGN
#define MEM_ALIGN	16
#endif

typedef union { char __x[MEM_ALIGN]; double __y; } align_t;

void inline *mem_alloc(int bytes);
void inline mem_free(void *ptr);
void inline mem_register_gc(void *x, int (*fn)(void *));

/* the rest of this file contains compatability things */

/* memzero function */
#ifndef HAVE_MEMZERO
#if defined(HAVE_BZERO)
#define memzero(a,b) bzero(a,b)
#elif defined(HAVE_MEMSET)
#define memzero(a,b) memset(a,0,b)
#else
void inline memzero(void *d, int len)
{
	register char *x = (char *)d;
	register int i;

	for (i = 0; i < len;) {
		*x = 0; x++;i++; if (i == len) break;
		*x = 0; x++;i++; if (i == len) break;
		*x = 0; x++;i++; if (i == len) break;
		*x = 0; x++;i++; if (i == len) break;
		*x = 0; x++;i++; if (i == len) break;
		*x = 0; x++;i++; if (i == len) break;
		*x = 0; x++;i++; if (i == len) break;
		*x = 0; x++;i++;
	}
}

#endif
#endif

/* memcpy function */
#ifndef HAVE_MEMCPY
#if defined(HAVE_BCOPY)
#define memcpy(a,b,c) bcopy(b,c,a)
#else
void inline memcpy(void *d, const void *s, int len)
{
	register const char *x = (const char *)s;
	register char *y = (char *)d;
	register int i;

	for (i = 0; i < len;) {
		*y = *x; x++;y++;i++; if (i == len) break;
		*y = *x; x++;y++;i++; if (i == len) break;
		*y = *x; x++;y++;i++; if (i == len) break;
		*y = *x; x++;y++;i++; if (i == len) break;
		*y = *x; x++;y++;i++; if (i == len) break;
		*y = *x; x++;y++;i++; if (i == len) break;
		*y = *x; x++;y++;i++; if (i == len) break;
		*y = *x; x++;y++;i++;
	}
}
#endif
#endif


/* more to come (hopefully not) */

#endif
