/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -  This software is distributed in the hope that it will be
 -  useful, but with NO WARRANTY OF ANY KIND.
 -  No author or distributor accepts responsibility to anyone for the
 -  consequences of using this software, or for whether it serves any
 -  particular purpose or works at all, unless he or she says so in
 -  writing.  Everyone is granted permission to copy, modify and
 -  redistribute this source code, for commercial or non-commercial
 -  purposes, with the following restrictions: (1) the origin of this
 -  source code must not be misrepresented; (2) modified versions must
 -  be plainly marked as such; and (3) this notice may not be removed
 -  or altered from any source or modified source distribution.
 *====================================================================*/

/*
 * morphtest1.c
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "allheaders.h"


main(int    argc,
     char **argv)
{
l_int32      i, j, w, h, val, count, zero, index;
char        *filein, *fileout;
PIX         *pixs, *pixd, *pixt;
SEL         *sel_10h;
SEL         *sel;
SELA        *sela;
FILE        *fp;
static char  mainName[] = "morphtest1";

    if (argc != 3)
	exit(ERROR_INT(" Syntax:  morphtest1 filein fileout", mainName, 1));

    filein = argv[1];
    fileout = argv[2];

    if ((pixs = pixRead(filein)) == NULL)
	exit(ERROR_INT("pix not made", mainName, 1));

    w = pixGetWidth(pixs);
    h = pixGetHeight(pixs);

    sela = selaAddBasic(NULL);

    fprintf(stderr, "Number of sels = %d\n", selaGetCount(sela));
    selaFindSelByName(sela, "sel_4", &index, &sel);
    selSetElement(sel, 0, 0, 2);
    selSetElement(sel, 1, 0, 2);
    selSetElement(sel, 2, 0, 2);
    selSetElement(sel, 3, 0, 2);
    selWriteStream(stderr, sel);

    pixd = pixClose(NULL, pixs, sel);
    pixt = pixCopy(NULL, pixs);
    pixRasterop(pixt, 0, 0, w, h, PIX_SRC ^ PIX_DST, pixd, 0, 0);
    pixZero(pixt, &zero);
    if (!zero)
	fprintf(stderr, "pixt not zero\n");
    else
	fprintf(stderr, "pixt is zero\n");
    pixCountPixels(pixt, &count, NULL);
    fprintf(stderr, "pixt pixel count = %d\n", count);

#if 0
    for (i = 0; i < h; i++)
	for (j = 0; j < w; j++) {
	    pixGetPixel(pixt, j, i, &val);
	    if (val)
		fprintf(stderr, "pixel (%d,%d) = 1\n", j, i);
	}
#endif
    
#if 0
    fp = fopen("junksel", "w+");
    selaFindSelByName(sela, "sel_10h", &index, &sel);
    selPrint(fp, sel);
    fclose(fp);
#endif


/*    pixRasterop(pixs, 0, 0, pixGetWidth(pixs), pixGetHeight(pixs), 
               PIX_SRC ^ PIX_DST, pixd, 0, 0);  */

    pixWrite(fileout, pixd, IFF_BMP);

    exit(0);
}

