/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -  This software is distributed in the hope that it will be
 -  useful, but with NO WARRANTY OF ANY KIND.
 -  No author or distributor accepts responsibility to anyone for the
 -  consequences of using this software, or for whether it serves any
 -  particular purpose or works at all, unless he or she says so in
 -  writing.  Everyone is granted permission to copy, modify and
 -  redistribute this source code, for commercial or non-commercial
 -  purposes, with the following restrictions: (1) the origin of this
 -  source code must not be misrepresented; (2) modified versions must
 -  be plainly marked as such; and (3) this notice may not be removed
 -  or altered from any source or modified source distribution.
 *====================================================================*/

/*
 * rotate180test.c
 *
 *    Tests all versions, including the left-right and top-bottom flips.
 */

#include <stdio.h>
#include <stdlib.h>
#include "allheaders.h"

#define  NTIMES   50


main(int    argc,
     char **argv)
{
l_int32      i, w, h, eq;
PIX         *pixs, *pixd, *pixt;
l_float32    pops;
char        *filein, *fileout;
static char  mainName[] = "rotate180test";

    if (argc != 3)
	exit(ERROR_INT(" Syntax:  rotate180test filein fileout", mainName, 1));

    filein = argv[1];
    fileout = argv[2];

    if ((pixs = pixRead(filein)) == NULL)
	exit(ERROR_INT("pix not made", mainName, 1));

#if 0
	/* time it */
    startTimer();
    w = pixGetWidth(pixs);
    h = pixGetHeight(pixs);
    pixd = pixCreateTemplate(pixs);
    for (i = 0; i < NTIMES; i++) {
	pixRotate180(pixd, pixs);
    }
    pops = (l_float32)(w * h * NTIMES) / stopTimer();
    fprintf(stderr, "MPops: %7.3f\n", pops / 1000000.);
#endif

#if 0
	/* test not-in-place */
    pixt = pixRotate180(NULL, pixs);
    pixd = pixRotate180(NULL, pixt);
    pixEqual(pixs, pixd, &eq);
    if (eq) fprintf(stderr, "2 rots gives I\n");
    else fprintf(stderr, "2 rots fail to give I\n");
#endif

#if 0
       /* test in-place */
    pixd = pixCopy(NULL, pixs);
    pixRotate180(pixd, pixd);
    pixRotate180(pixd, pixd);
    pixEqual(pixs, pixd, &eq);
    if (eq) fprintf(stderr, "2 rots gives I\n");
    else fprintf(stderr, "2 rots fail to give I\n");
#endif

#if 0
	/* mix rotate 180 with LR/TB */
    pixd = pixRotate180(NULL, pixs);
    pixRotateLR(pixd, pixd);
    pixRotateTB(pixd, pixd);
    pixEqual(pixs, pixd, &eq);
    if (eq) fprintf(stderr, "180 rot OK\n");
    else fprintf(stderr, "180 rot error\n");
#endif

#if 0
	/* rotate 180 */
    pixd = pixRotate180(NULL, pixs);
    pixRotate180(pixd, pixd);
    pixEqual(pixs, pixd, &eq);
    if (eq) fprintf(stderr, "180 rot OK\n");
    else fprintf(stderr, "180 rot error\n");
#endif

#if 0
	/* flip T-B */
    pixd = pixRotateTB(NULL, pixs);
    pixRotateTB(pixd, pixd);
    pixEqual(pixs, pixd, &eq);
    if (eq) fprintf(stderr, "T-B OK\n");
    else fprintf(stderr, "T-B error\n");
#endif

#if 0
	/* flip L-R */
    pixd = pixRotateLR(NULL, pixs);
    pixRotateLR(pixd, pixd);
    pixEqual(pixs, pixd, &eq);
    if (eq) fprintf(stderr, "L-R OK\n");
    else fprintf(stderr, "L-R error\n");
#endif


#if 1
	/* just rotate it */
    pixd = pixRotate180(NULL, pixs);
#endif

    if (pixGetDepth(pixd) < 8)
	pixWrite(fileout, pixd, IFF_PNG);
    else
	pixWrite(fileout, pixd, IFF_JFIF_JPEG);

    exit(0);
}

