#include "../config.h"

#if HAVE_MYSQL
	#include "mysql_backend.h"
#endif

#include "lcp3.h"
#include "cmd_lcp3.h"

#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <syslog.h>

#if HAVE_MYSQL
void do_addrbook_lookup(char *numname, int len)
{ // will replace the number in numname by the
// appropriate name if found.
	#define MAX_QUERY_LEN 400
	char query[MAX_QUERY_LEN];
	unsigned long *lengths;
	char *a, *b, *num = strdup(numname);
	MYSQL_RES *res;
	MYSQL_ROW row;

	if ( !(server->addrbook_table && server->addrbook_namecol &&
			server->addrbook_numcol && sqlbe_available() ) ) return;

	if  ( !num ) return;

	// strip spaces from num
	a = num; b = num;
	while ( *b && (b - num < len) )
	{
		while ( *b && (*b == ' ' || *b == '\t') ) b++;
		*a = *b;
		if ( !*b ) break;
		a++; b++;
	}
	*a = *b;

	snprintf(query, MAX_QUERY_LEN, "select %s from %s where REPLACE(%s, ' ', '')='%s' and %s!=''",
		server->addrbook_namecol, server->addrbook_table,
		server->addrbook_numcol, num, server->addrbook_namecol);

	if ( sqlbe_query(query) ) return; //failed

	res = mysql_store_result(mysql_con);
	if ( !res ) return;

	if ( mysql_num_rows(res) < 1 )
	{
		mysql_free_result(res);
/*		if ( server->addrbook_regnew )
		{
			// too lazy to implement it now...
			// server->addrbook_regnew: var + keyword not added yet
		}*/
		return;
	}
	
	row = mysql_fetch_row(res);
	lengths = mysql_fetch_lengths(res);
	if ( lengths[0] < len ) len = lengths[0];
	else len--;
	strncpy(numname, row[0], len);
	numname[len] = 0;

	mysql_free_result(res);
	
	return;
}
#endif

void handle_isdn_callerslog()
{
	#define MAX_LINE_LEN 200
	static FILE* fcallers;
	static char firstcall = 1;
    struct t_lcp3_info_isdn infisdn;
//    fd_set rfds;
//    struct timeval tv;
	char stdinline[MAX_LINE_LEN];
	char num1[7], num2[5], num3[20];

/*
    FD_ZERO(&rfds);
    FD_SET(0, &rfds);
    // don't wait (argument would be seconds).
    tv.tv_sec =  0;
    tv.tv_usec = 0;
    if ( !select(1, &rfds, NULL, NULL, &tv) ) return;
*/

	if ( firstcall )
	{
		firstcall = 0;
		if ( !(fcallers = fopen(server->callerslog, "r")) )
		{
			syslog(LOG_WARNING, "Unable to open %s for reading. Caller reporting disabled.",
					server->callerslog);
			server->isdn_callerslog = 0;
			return;
		}
		else
		{
			fseek(fcallers, 0, SEEK_END);
		}
	}

	while ( fgets(stdinline, MAX_LINE_LEN, fcallers) )
	{
		if ( sscanf(stdinline, "%3s %2s %8s %6s %4s %19s",
				infisdn.month, infisdn.day, infisdn.time,
				num1, num2, num3) == 6 )
		{
			snprintf(infisdn.caller, sizeof(infisdn.caller),
				"%s %s %s", num1, num2, num3);
			strcpy(infisdn.on, "<?>");
			#if HAVE_MYSQL
				do_addrbook_lookup(infisdn.caller, sizeof(infisdn.caller));
			#endif
			lcp3_cmd_broadcast(CBR3_ISDNACT, &infisdn, sizeof(struct t_lcp3_info_isdn), NULL);
		}
	}
}
