/* $Id: lingmeaningtree.h,v 1.4 2005/03/24 10:27:25 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LING_GTK_MEANING_TREE_H
#define LING_GTK_MEANING_TREE_H 1

#include <lingoteach.h>
#include <gtk/gtk.h>

#define LING_TYPE_TREE_STORE (ling_tree_store_get_type ())
#define LING_TREE_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                              LING_TYPE_TREE_STORE, LingTreeStore))
#define LING_TREE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST \
                                      ((klass),LING_TYPE_TREE_STORE, \
                                       LingTreeStoreClass))
#define LING_IS_TREE_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                 LING_TYPE_TREE_STORE))
#define LING_IS_TREE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE \
                                         ((klass), LING_TYPE_TREE_STORE))
#define LING_TREE_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS \
                                        ((obj), LING_TYPE_TREE_STORE, \
                                         LingTreeStoreClass))

typedef struct _LingTreeStore LingTreeStore;
typedef struct _LingTreeStoreClass LingTreeStoreClass;

/* the columns of the model */
enum {
     LING_TREE_ID,
     LING_TREE_LANGUAGE,
     LING_TREE_TRANS,
     LING_TREE_POINTER, /* hidden, used for editing*/
     LING_TREE_EDITED,  /* hidden, used as visible indicator */
     LING_TREE_N_COLUMNS
};

/* used for sorting */
enum {
     SORT_ID_NONE = 0,
     SORT_ID_ID,
     SORT_ID_LANG,
     SORT_ID_TRANS
};

struct _LingTreeStore
{
     GObject parent;

     lingMeaning *meaning;     /* the connected meaning tree */
     guint        num_rows;    /* total amount of rows */
     gint         stamp;       /* time stamp for verification of iters */
     gint         n_columns;   /* column amount */
     GType        column_types[LING_TREE_N_COLUMNS];
     gpointer     root;        /* first element */
};

struct _LingTreeStoreClass
{
     GObjectClass parent_class;
};

GType
ling_tree_store_get_type (void);

LingTreeStore*
ling_tree_store_new (void);

LingTreeStore*
ling_tree_store_new_with_meanings (lingMeaning *meaning);

void
ling_tree_store_set_modified (LingTreeStore *tree_store, lingMeaning *meaning);

void
ling_tree_store_insert_after (LingTreeStore *tree_store, GtkTreeIter *iter,
                              GtkTreeIter *parent, GtkTreeIter *sibling);

gboolean
ling_tree_store_remove (LingTreeStore *tree_store, GtkTreeIter *iter);

gboolean
ling_tree_store_search (GtkTreeModel  *tree_model, GtkTreeIter *iter,
                        gint column_id, gpointer data);

#endif /* LING_GTK_MEANING_TREE_H */
