/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lm-graph.h"

#include "lm-graph-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 26 "lm-graph.gob"

#include "config.h"
#include "lm-util.h"

#define GRAPH_WIDTH		200	/* fixed width */
#define GRAPH_HEIGHT		24	/* minimum height */

/* space between text and border */
#define TEXT_MARGIN		3

#line 37 "lm-graph.c"
/* self casting macros */
#define SELF(x) LM_GRAPH(x)
#define SELF_CONST(x) LM_GRAPH_CONST(x)
#define IS_SELF(x) LM_IS_GRAPH(x)
#define TYPE_SELF LM_TYPE_GRAPH
#define SELF_CLASS(x) LM_GRAPH_CLASS(x)

#define SELF_GET_CLASS(x) LM_GRAPH_GET_CLASS(x)

/* self typedefs */
typedef LMGraph Self;
typedef LMGraphClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void lm_graph_init (LMGraph * o) G_GNUC_UNUSED;
static void lm_graph_class_init (LMGraphClass * c) G_GNUC_UNUSED;
static GObject * ___3_lm_graph_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean ___4_lm_graph_configure_event (GtkWidget * widget, GdkEventConfigure * event) G_GNUC_UNUSED;
static void ___5_lm_graph_size_request (GtkWidget * widget, GtkRequisition * requisition) G_GNUC_UNUSED;
static gboolean ___6_lm_graph_expose_event (GtkWidget * widget, GdkEventExpose * event) G_GNUC_UNUSED;
static void lm_graph_redraw (LMGraph * self) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_APPLET,
	PROP_DATA,
	PROP_MARKUP
};

/* pointer to the class of our parent */
static GtkDrawingAreaClass *parent_class = NULL;

/* Short form macros */
#define self_set_data lm_graph_set_data
#define self_set_markup lm_graph_set_markup
#define self_redraw lm_graph_redraw
#define self_new lm_graph_new
GType
lm_graph_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMGraphClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_graph_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMGraph),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_graph_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_DRAWING_AREA, "LMGraph", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMGraph *)g_object_new(lm_graph_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMGraph * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMGraph *
GET_NEW_VARG (const char *first, ...)
{
	LMGraph *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMGraph *)g_object_new_valist (lm_graph_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Graph::finalize"
	LMGraph *self G_GNUC_UNUSED = LM_GRAPH (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 50 "lm-graph.gob"
	if(self->_priv->markup) { g_free ((gpointer) self->_priv->markup); self->_priv->markup = NULL; }
#line 130 "lm-graph.c"
#line 59 "lm-graph.gob"
	if(self->_priv->buffer) { cairo_surface_destroy ((gpointer) self->_priv->buffer); self->_priv->buffer = NULL; }
#line 133 "lm-graph.c"
}
#undef __GOB_FUNCTION__

static void 
lm_graph_init (LMGraph * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Graph::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LM_TYPE_GRAPH,LMGraphPrivate);
}
#undef __GOB_FUNCTION__
static void 
lm_graph_class_init (LMGraphClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Graph::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)c;

	g_type_class_add_private(c,sizeof(LMGraphPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_DRAWING_AREA);

#line 61 "lm-graph.gob"
	g_object_class->constructor = ___3_lm_graph_constructor;
#line 77 "lm-graph.gob"
	gtk_widget_class->configure_event = ___4_lm_graph_configure_event;
#line 100 "lm-graph.gob"
	gtk_widget_class->size_request = ___5_lm_graph_size_request;
#line 107 "lm-graph.gob"
	gtk_widget_class->expose_event = ___6_lm_graph_expose_event;
#line 163 "lm-graph.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("applet" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_APPLET,
		param_spec);
	param_spec = g_param_spec_pointer
		("data" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_DATA,
		param_spec);
	param_spec = g_param_spec_string
		("markup" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_MARKUP,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Graph::set_property"
{
	LMGraph *self G_GNUC_UNUSED;

	self = LM_GRAPH (object);

	switch (property_id) {
	case PROP_APPLET:
		{
#line 40 "lm-graph.gob"
self->_priv->applet = g_value_get_pointer (VAL);
#line 215 "lm-graph.c"
		}
		break;
	case PROP_DATA:
		{
#line 45 "lm-graph.gob"

      selfp->data = g_value_get_pointer(VAL);
      gtk_widget_queue_draw(GTK_WIDGET(self));
    
#line 225 "lm-graph.c"
		}
		break;
	case PROP_MARKUP:
		{
#line 53 "lm-graph.gob"

      g_free(selfp->markup);
      selfp->markup = g_value_dup_string(VAL);
      gtk_widget_queue_draw(GTK_WIDGET(self));
    
#line 236 "lm-graph.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Graph::get_property"
{
	LMGraph *self G_GNUC_UNUSED;

	self = LM_GRAPH (object);

	switch (property_id) {
	case PROP_APPLET:
		{
#line 40 "lm-graph.gob"
g_value_set_pointer (VAL, self->_priv->applet);
#line 267 "lm-graph.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 45 "lm-graph.gob"
void 
lm_graph_set_data (LMGraph * self, GArray * val)
#line 287 "lm-graph.c"
{
#define __GOB_FUNCTION__ "LM:Graph::set_data"
{
#line 43 "lm-graph.gob"
		g_object_set (G_OBJECT (self), "data", val, NULL);
}}
#line 294 "lm-graph.c"
#undef __GOB_FUNCTION__

#line 53 "lm-graph.gob"
void 
lm_graph_set_markup (LMGraph * self, gchar * val)
#line 300 "lm-graph.c"
{
#define __GOB_FUNCTION__ "LM:Graph::set_markup"
{
#line 51 "lm-graph.gob"
		g_object_set (G_OBJECT (self), "markup", val, NULL);
}}
#line 307 "lm-graph.c"
#undef __GOB_FUNCTION__

#line 61 "lm-graph.gob"
static GObject * 
___3_lm_graph_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 313 "lm-graph.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "LM:Graph::constructor"
{
#line 63 "lm-graph.gob"
	
    GObject *object;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    lm_g_object_connect(self, selfp->applet,
			"swapped-signal::notify::scale", gtk_widget_queue_draw, self,
			NULL);

    return object;
  }}
#line 335 "lm-graph.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 77 "lm-graph.gob"
static gboolean 
___4_lm_graph_configure_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventConfigure * event)
#line 342 "lm-graph.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->configure_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->configure_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "LM:Graph::configure_event"
{
#line 79 "lm-graph.gob"
	
    Self *self = SELF(widget);
    cairo_t *cr;

    cr = gdk_cairo_create(widget->window);

    if (selfp->buffer)
      cairo_surface_destroy(selfp->buffer);

    selfp->buffer = cairo_surface_create_similar(cairo_get_target(cr),
						 CAIRO_CONTENT_COLOR,
						 widget->allocation.width,
						 widget->allocation.height);

    cairo_destroy(cr);

    self_redraw(self);

    return FALSE;		/* propagate event */
  }}
#line 371 "lm-graph.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 100 "lm-graph.gob"
static void 
___5_lm_graph_size_request (GtkWidget * widget G_GNUC_UNUSED, GtkRequisition * requisition)
#line 378 "lm-graph.c"
#define PARENT_HANDLER(___widget,___requisition) \
	{ if(GTK_WIDGET_CLASS(parent_class)->size_request) \
		(* GTK_WIDGET_CLASS(parent_class)->size_request)(___widget,___requisition); }
{
#define __GOB_FUNCTION__ "LM:Graph::size_request"
{
#line 102 "lm-graph.gob"
	
    requisition->width = GRAPH_WIDTH;
    requisition->height = GRAPH_HEIGHT;
  }}
#line 390 "lm-graph.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 107 "lm-graph.gob"
static gboolean 
___6_lm_graph_expose_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventExpose * event)
#line 397 "lm-graph.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->expose_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->expose_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "LM:Graph::expose_event"
{
#line 109 "lm-graph.gob"
	
    Self *self = SELF(widget);

    self_redraw(self);

    return FALSE;		/* propagate event */
  }}
#line 413 "lm-graph.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 117 "lm-graph.gob"
static void 
lm_graph_redraw (LMGraph * self)
#line 420 "lm-graph.c"
{
#define __GOB_FUNCTION__ "LM:Graph::redraw"
#line 117 "lm-graph.gob"
	g_return_if_fail (self != NULL);
#line 117 "lm-graph.gob"
	g_return_if_fail (LM_IS_GRAPH (self));
#line 427 "lm-graph.c"
{
#line 119 "lm-graph.gob"
	
    GtkWidget *widget = GTK_WIDGET(self);
    cairo_t *cr;
    static const GdkColor bg_color =	{ 0, 0xffff, 0xffff, 0xffff };
    static const GdkColor fg_color =	{ 0, 0x0000, 0x0000, 0x0000 };

    cr = gdk_cairo_create(widget->window);
    cairo_set_source_surface(cr, selfp->buffer, 0, 0);

    /* background */

    gdk_cairo_set_source_color(cr, (GdkColor *) &bg_color);
    cairo_rectangle(cr, 0, 0, widget->allocation.width, widget->allocation.height);
    cairo_fill(cr);

    /* cairo_stroke() params */

    cairo_set_line_width(cr, 1.0);
    cairo_set_line_cap(cr, CAIRO_LINE_CAP_BUTT);
    cairo_set_line_join(cr, CAIRO_LINE_JOIN_MITER);

    /* border */

    gdk_cairo_set_source_color(cr, (GdkColor *) &fg_color);
    cairo_rectangle(cr, 0, 0, widget->allocation.width, widget->allocation.height);
    cairo_stroke(cr);

    /* graph */

    if (selfp->data)
      {
	int i;
	int width;
	int height;

	/* account for border */
	width = widget->allocation.width - 2;
	height = widget->allocation.height - 2;

	for (i = 0; i < selfp->data->len; i++)
	  {
	    double x;
	    double y;

#define VALUE(index) g_array_index(selfp->data, double, (index))

	    if (VALUE(i) < 0)
	      continue;

	    x = ((double) i / (selfp->data->len - 1) * width) + 1;
	    y = ((double) height - VALUE(i) / selfp->applet->scale * height) + 1;

	    /*
	     * Constrain high pings inside the graph, since no plot
	     * means no reply.
	     */
	    if (y < 1)
	      y = 1;

	    if (i == 0 || VALUE(i - 1) < 0)
	      cairo_move_to(cr, x, y);
	    else
	      {
		cairo_line_to(cr, x, y);
		if (i == selfp->data->len - 1 || VALUE(i + 1) < 0)
		  cairo_stroke(cr);
	      }
	  }
      }

    /* text */

    if (selfp->markup)
      {
	PangoLayout *layout;

	layout = gtk_widget_create_pango_layout(widget, NULL);
	pango_layout_set_markup(layout, selfp->markup, -1);
	gdk_draw_layout(widget->window,
			widget->style->text_gc[GTK_WIDGET_STATE(widget)],
			TEXT_MARGIN,
			TEXT_MARGIN,
			layout);
	g_object_unref(layout);
      }

    cairo_destroy(cr);
  }}
#line 518 "lm-graph.c"
#undef __GOB_FUNCTION__

#line 208 "lm-graph.gob"
GtkWidget * 
lm_graph_new (LMApplet * applet)
#line 524 "lm-graph.c"
{
#define __GOB_FUNCTION__ "LM:Graph::new"
#line 208 "lm-graph.gob"
	g_return_val_if_fail (applet != NULL, (GtkWidget * )0);
#line 208 "lm-graph.gob"
	g_return_val_if_fail (LM_IS_APPLET (applet), (GtkWidget * )0);
#line 531 "lm-graph.c"
{
#line 210 "lm-graph.gob"
	
    return GTK_WIDGET(GET_NEW_VARG(LM_GRAPH_PROP_APPLET(applet), NULL));
  }}
#line 537 "lm-graph.c"
#undef __GOB_FUNCTION__
