/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ncurses.h>
#include <panel.h>
#include <time.h>
#include "curse.h"
#include "error.h"
#include "rc.h"
#include "streamer.h"
#include "linuxtrade.h"

static void
print1(RCFILE *rcp, FILE *fp)
{
	fprintf(fp, "	%s=%s	%s\n",
			rcp->name,
			rcp->type == RC_NUM ? "num" : "str", rcp->comment);
	if (rcp->type == RC_LIST || rcp->type == RC_COMBO)
	{
		char	*p;
	       	p = strchr(rcp->defvalue, '|');
		if (!p)
			p = strchr(rcp->defvalue, 0);
		fprintf(fp, "			(%s) [%.*s]\n",
				rcp->defvalue,
				p - rcp->defvalue, rcp->defvalue);
	}
	else
		fprintf(fp, "			[%s]\n", rcp->defvalue);
}

void
print_rc_file(RCFILE *rcp, FILE *fp)
{
	while (rcp->name)
	{
		print1(rcp, fp);
		++rcp;
	}
}

int
set_rc_value(RCFILE *rcp, char *name, char *value)
{
	while (rcp->name)
	{
		if (strcmp(name, rcp->name) == 0)
		{
			if (rcp->value)
				free(rcp->value);
			rcp->value = strdup(value);
			return 0;
		}
		++rcp;
	}
	return 1;
}

char *
get_rc_value(RCFILE *rcp, char *name)
{
	while (rcp->name)
	{
		if (strcmp(name, rcp->name) == 0)
		{
			if (rcp->value == NULL)
			{
				rcp->value = strdup(rcp->defvalue);
				if (rcp->type == RC_LIST
				    || rcp->type == RC_COMBO)
				{
					char	*p = strchr(rcp->value, '|');
					if (p) *p = 0;
				}
			}
			return (rcp->value);
		}
		++rcp;
	}
	return "";
}

int
save_rc_file(RCFILE *rcp, char *filename)
{
	char	*home = getenv("HOME");
	char	buf[16384];
	FILE	*fp;

	sprintf(buf, "%s/%s", home, filename);

	fp = fopen(buf, "w");
	if (!fp)
		return 1;

	fprintf(fp, "# User modifiable config file '%s'\n#\n", buf);
	fprintf(fp, "# Variables that can be set here are...\n#\n");
	while (rcp->name)
	{
		if (rcp->value)
			fprintf(fp, "%s = %s\n", rcp->name, rcp->value);
		else
			fprintf(fp, "#%s = %s\n", rcp->name, rcp->defvalue);
		++rcp;
	}
	fprintf(fp, "#\n# Uncomment or change these as needed.\n");

	fclose(fp);
	return (0);
}

void
process_rc_file(RCFILE *rcp, char *filename)
{
	char	*home = getenv("HOME");
	char	buf[16384];
	FILE	*fp;
	char	*p;
	char	*name, *value;

	sprintf(buf, "%s/%s", home, filename);

	fp = fopen(buf, "r");
	if (!fp)
	{
		fp = fopen(buf, "w");
		if (!fp)
			return;
		fprintf(fp, "# User modifiable config file '%s'\n#\n", buf);
		fprintf(fp, "# Variables that can be set here are...\n#\n");
		while (rcp->name)
		{
			fprintf(fp, "#\t%s = %s\n", rcp->name, rcp->defvalue);
			++rcp;
		}
		fprintf(fp, "#\n# Uncomment these as needed.\n");
		fclose(fp);
		return;
	}

	while (fgets(buf, sizeof(buf), fp))
	{
		for (;;)
		{
			int	c;

			p = strrchr(buf, '\\');
			if (!p)
				break;
			if (p[1] != '\n')
				break;

			while ((c = getc(fp)) == '\t')
				{}
			if (c != EOF)
				ungetc(c, fp);
			if (!fgets(p, sizeof(buf) - (p-buf), fp))
				break;
		}
		if (buf[0] == '#')
			continue;
		p = strchr(buf, '=');
		if (!p)
			continue;

		*p++ = 0;
		name = buf;
		while (*name == ' ' || *name == '\t')
			++name;
		value = p;

		p = strchr(name, ' '); if (p) *p = 0;
		p = strchr(name, '\t'); if (p) *p = 0;
		while (*value == ' ' || *value == '\t') ++value;
		p = strchr(value, '\r'); if (p) *p = 0;
		p = strchr(value, '\n'); if (p) *p = 0;

		// printf("<%s> <%s>\n", name, value);
		set_rc_value(rcp, name, value);
	}
	fclose(fp);
}
