/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file piece.h 
	\brief Obsługa klocków
*/

#ifndef __LW_PIECE_H
#define __LW_PIECE_H

#include <libxml/tree.h>

class LWPixmap;
class LWRow;
class LWSymbol;

/*! \class LWPiece
	\brief Klasa reprezentująca klocek

	Klasa zarządzająca pojedenynczym klockiem.
*/
class LWPiece {
private:
static GtkTooltips *tooltips;
LWPixmap *backpixmap;
LWPixmap *forepixmap;
LWSymbol *symbol;
GtkWidget *widget;
GtkWidget *image;
gboolean inverted_grounds;
gboolean is_enter;
void init (LWRow *row);
void attach (LWRow *row);
public:
LWRow *row;
LWPiece (LWRow *row);
LWPiece (LWRow *row, LWPixmap *pixbuf);
LWPiece (const LWPiece *piece, LWRow *row);
void restoreFromXML (xmlNode *node);
void storeToXML (xmlNode *parent_node);
~LWPiece ();
LWRow *getRow();
LWSymbol *getSymbol();
void setSymbol (const gchar *symbolname);
void setSymbolWithId (const gchar *symbolname, guint id);
LWPixmap *getBackgroundPixmap();
void setForegroundPixmap (LWPixmap *pixmap);
void setBackgroundPixmap (LWPixmap *pixmap);
void updateImage ();
void enableInvertedGrounds (gboolean inverted);
void clear();
void copy (LWPiece *piece);
gboolean isEnter ();
GtkWidget *getWidget ();
};

#include "pixmap.h"
#include "row.h"
#include "symbol.h"

#endif
