/* =====================================================================

   LiMo - Liblary Header
      Graphic Display System.  - ̴ȥ֥ɽ

                                  Programed by Rero2 (K.Kunikane)

====================================================================== */

#ifndef RR_SCREEN

#define RR_SCREEN

#ifdef __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

/* -------------------------------------------------------------
 --- Structure
-------------------------------------------------------------- */

typedef struct _RRSprite RRSprite;

struct _RRSprite
{
  gboolean  sw;              /* ɽå */
  GdkPixmap  *objmap;        /* ɽObjΥޥå */
  GdkBitmap  *objmask;       /* Objȴ */
  gint  x, y;                /* ꡼ؤɽ */
  gint  w, h;                /* ɽObjΥ */
  gint  ox, oy;              /* objmapǤΥƥ㡼ɸ */
  gint  offset_x, offset_y;  /* ֥濴κɸեå */
};


/* -------------------------------------------------------------
 --- Extern
-------------------------------------------------------------- */
void       RRScreenInit(GtkWidget*, GtkWidget*, gint, gint);
void       RRScreenFree(void);
gint       RRScreenSwitch(void);
gboolean   RRScreenRedraw(GtkWidget*, GdkEventExpose*, gpointer);
gint       RRScreenBufNum(void);
GdkPixmap *RRScreenBuffer(void);
GtkWidget *RRScreenCanvas(void);
GtkWidget *RRScreenWindow(void);
void       RRScreenWinShape(GdkBitmap*);
void       RRScreenSetPalette(GdkColormap*, gint);
void       RRScreenGCColor(gint, gint, gint);
GdkGC     *RRScreenGCGet(void);
void       RRScreenClear(gint, gint, gint);
void       RRScreenFontSetDirect(GdkFont*);
void       RRScreenFontSetInit(gchar*);
void       RRScreenFontInit(gchar*);
void       RRScreenFontLocate(gint, gint);
void       RRScreenFontSize(gchar*, gint*, gint*);
void       RRScreenFontPrint(gchar *);
void       RRScreenFontPrintDirext(GdkPixmap* ,gchar*);
void       RRScreenPutPixmap(GdkPixmap*, gint, gint);
void       RRScreenObjPut(RRSprite *spr);
void       RRScreenPoint(gint, gint);
void       RRScreenLine(gint, gint, gint, gint);
void       RRScreenRectanlge(gint, gint, gint, gint, gint);
GtkWidget *RRGetParts(GtkWidget *, gchar *);


#ifdef __cplusplus
}
#endif                          /* __cplusplus */

#endif



