/*This is free software distributed under the terms of the
  GNU Public License.  See the file COPYING for details. */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
/* FLAC streaminfo access.
    Based on ogg_ext.c */

#ifdef HAVE_FLAC

#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/time.h>
#include <FLAC/metadata.h>
#include <FLAC/format.h>
#include "lopster.h"

void file_parse_flac_header(file_t * file) {
  int fd;
  struct stat st;
  FLAC__StreamMetadata streaminfo;
  
  fd = open(file->longname, O_RDONLY);
  if (fd == -1) {
    printf("could not open file for reading header [%s]\n",
	   file->longname);
    close(fd);
    return;
  } else {
    if (fstat(fd, &st) == 0) {
      file->size = st.st_size;    // fix size below to lob header info?
    } else {
      fprintf(stderr, "Could not stat \"%s\" -> Error: %u \n",
	      file->longname, fd);
    }
    close(fd);
    if (!FLAC__metadata_get_streaminfo(file->longname, &streaminfo) ||
	(file->frequency = streaminfo.data.stream_info.sample_rate) <= 0 ||
	(file->duration = (time_t)(streaminfo.data.stream_info.total_samples / file->frequency)) <= 0 ||
	(file->bitrate = (int)(file->size / file->duration * 8 / 1000)) <= 0) {

      printf("[FLAC] error reading header information from\n"
	     "[FLAC]   [%s]\n"
	     "[FLAC] Are you sure that this is a flac file?\n",
	     file->longname);
      // restore Dummy info
      file->bitrate = 24;
      file->frequency = 16000;
      file->duration = 600;
    }
  }
}

#endif
