#ifndef IRC_HANDLER_H_
#define IRC_HANDLER_H_

#include "handler.h"

// RFC2812
// NUMERIC COMMANDS
#define CIRC_WELCOME		    1
#define CIRC_YOURHOST		    2
#define CIRC_CREATED		    3
#define CIRC_MYINFO		    4
//#define CIRC_BOUNCE		    5
#define CIRC_INFO1                  8 //
#define CIRC_UMODEIS              221
#define CIRC_LUSERCLIENT          251
#define CIRC_LUSEROP              252
#define CIRC_LUSERUNKNOWN         253
#define CIRC_LUSERCHANNELS        254
#define CIRC_LUSERME              255
#define CIRC_ADMINME              256
#define CIRC_ADMINLOC1            257
#define CIRC_ADMINLOC2            258
#define CIRC_ADMINEMAIL           259
#define CIRC_TRYAGAIN             263
#define CIRC_INFO2                265 //
#define CIRC_INFO3                266 //
#define CIRC_ENDOFWHO             315
#define CIRC_LISTSTART            321
#define CIRC_CHLIST               322
#define CIRC_LISTEND              323
#define CIRC_CHANNELMODEIS        324
#define CIRC_INFO4                329 //
#define CIRC_NOTOPIC              331
#define CIRC_TOPIC                332
#define CIRC_TOPIC_SET_BY         333
#define CIRC_VERSION		  351
#define CIRC_WHOREPLY		  352
#define CIRC_NAMREPLY		  353
#define CIRC_ENDOFNAMES           366
#define CIRC_BANLIST              367
#define CIRC_ENDOFBANLIST         368
#define CIRC_MOTD                 372
#define CIRC_MOTD_START           375
#define CIRC_MOTD_END             376
// NUMERIC ERROR REPLIES
#define CIRC_NOSUCHNICK           401
#define CIRC_NOSUCHCHANNEL        403
#define CIRC_TOOMANYCHANNELS      405
#define CIRC_TOOMANYTARGETS       407
#define CIRC_UNKNOWNCOMMAND       421
#define CIRC_NONICKNAMEGIVEN      431
#define CIRC_ERRONEUSNICKNAME     432
#define CIRC_NICKNAMEINUSE        433
#define CIRC_NICKCOLLISION        436
#define CIRC_UNAVAILRESOURCE      437
#define CIRC_USERNOTINCHANNEL     441
#define CIRC_NOTONCHANNEL         442
#define CIRC_NEEDMOREPARAMS       461
#define CIRC_ALREADYREGISTERED    462
#define CIRC_BANNED               465
#define CIRC_KEYSET               467
#define CIRC_CHANNELISFULL        471
#define CIRC_UNKNOWNMODE          472
#define CIRC_INVITEONLYCHAN       473
#define CIRC_BANNEDFROMCHAN       474
#define CIRC_BADCHANNELKEY        475
#define CIRC_BADCHANMASK          476
#define CIRC_NOCHANMODES          477
#define CIRC_NOPRIVILEGES         481
#define CIRC_CHANOPRIVSNEEDED     482
#define CIRC_CANTKILLSERVER       483
#define CIRC_RESTRICTED           484
#define CIRC_UMODEUNKNOWNFLAG     501
#define CIRC_USERSDONTMATCH       502
// STRING COMMANDS CONVERTED TO NUMERIC CODE
#define CIRC_NOTICE              1000
#define CIRC_JOIN                1001
#define CIRC_PING                1002
#define CIRC_ERROR               1003
#define CIRC_NICK                1004
#define CIRC_PRIVMSG             1005
#define CIRC_QUIT                1006
#define CIRC_TOPIC_SET           1007
#define CIRC_PART                1008
#define CIRC_MODE                1009
#define CIRC_PONG                1010
#define CIRC_LIST                1011
#define CIRC_KICK                1012

HANDLER(irc_login_ack);
HANDLER(irc_motd);
HANDLER(irc_create_channel);
HANDLER(irc_notice);
HANDLER(irc_error);
HANDLER(irc_ping);
HANDLER(irc_user_list);
HANDLER(irc_topic);
HANDLER(irc_topic_set_by);
HANDLER(irc_message);
HANDLER(irc_private_message);
HANDLER(irc_nick_changed);
HANDLER(irc_quit);
HANDLER(irc_part);
HANDLER(irc_join);
HANDLER(irc_topic_set);
HANDLER(irc_user_mode);
HANDLER(irc_mode);
HANDLER(irc_chmode_is);
HANDLER(irc_whoreply);
HANDLER(irc_pong);
HANDLER(irc_list);
HANDLER(irc_list_end);
HANDLER(irc_banlist);
HANDLER(irc_kick);

#endif
