#ifndef NAPSTER_HANDLER_H_
#define NAPSTER_HANDLER_H_

#include "handler.h"

/** Napster commands, that are received. */
#define NAP_ERROR		  0
#define NAP_EMAIL	      	  3
#define NAP_REGISTER_OK		  8
#define NAP_REGISTER_FAIL	  9
#define NAP_BAD_NICK		  10
#define NAP_UNSHARE_ALL_ACK       110
#define NAP_SEARCH_RESULT	  201
#define NAP_SEARCH_END		  202
#define NAP_FILE_READY		  204
#define NAP_PRIVMSG		  205
#define NAP_SEND_ERROR		  206
#define NAP_USER_SIGNON		  209
#define NAP_USER_SIGNOFF	  210
#define NAP_BROWSE_RESPONSE	  212
#define NAP_BROWSE_END		  213
#define NAP_STATS		  214
#define NAP_RESUME_MATCH	  216
#define NAP_RESUME_MATCH_END	  217
#define NAP_HOTLIST_ACK		  301
#define NAP_HOTLIST_ERROR         302
#define NAP_DISCONNECTING	  316
#define NAP_IGNORE_LIST		  320
#define NAP_IGNORE_ENTRY	  321
#define NAP_IGNORE_USER		  322
#define NAP_UNIGNORE_USER	  323
#define NAP_NOT_IGNORED		  324
#define NAP_ALREADY_IGNORED	  325
#define NAP_PART		  401
#define NAP_PUBLIC		  403
#define NAP_NOSUCH		  404
#define NAP_JOIN_ACK		  405
#define NAP_JOIN		  406
#define NAP_USER_PART		  407
#define NAP_CHANNEL_USER_LIST	  408
#define NAP_CHANNEL_USER_LIST_END 409
#define NAP_TOPIC		  410
#define NAP_CHANNEL_BAN_LIST_END  420
#define NAP_CHANNEL_BAN_LIST	  421
#define NAP_CHANNEL_ALT_TOPIC     425
#define NAP_UPLOAD_FIREWALL	  501
#define NAP_USER_SPEED		  601
#define NAP_WHOIS_RESPONSE	  604
#define NAP_WHOWAS		  605
#define NAP_UPLOAD_REQUEST	  607
#define NAP_GET_ERROR             609
#define NAP_ALTER_PORT		  613
#define NAP_BANLIST		  615
#define NAP_IP_BANLIST		  616
#define NAP_CHANNEL_LIST_END	  617
#define NAP_CHANNEL_LIST	  618
#define NAP_LIMIT		  620
#define NAP_MOTD		  621
#define NAP_DATA_PORT_ERROR	  626
#define NAP_WALLOP		  627
#define NAP_ANNOUNCE		  628
#define NAP_NICK_BANLIST	  629
#define NAP_BROWSE_DIRECT         640
#define NAP_BROWSE_DIRECT_OK      641
#define NAP_BROWSE_DIRECT_ERR     642
#define NAP_GHOST		  748
#define NAP_PING_SERVER		  750
#define NAP_PING		  751
#define NAP_PONG		  752
#define NAP_REDIRECT		  821
#define NAP_CYCLE		  822
#define NAP_EMOTE		  824
#define NAP_NAMES_LIST		  825
#define NAP_FULL_CHANNEL_LIST	  827
#define NAP_FULL_CHANNEL_INFO	  828
#define NAP_NAMES_LIST_END	  830
#define NAP_GUSER_LIST_END	  831
#define NAP_GUSER_LIST   	  832
#define NAP_BLOCKMD5              931
#define NAP_LINKS		  10112
#define NAP_USAGE_STATS		  10115
#define NAP_VERSION_STATS         10118
#define NAP_WHO_WAS               10121
#define NAP_HISTOGRAM		  10123
#define NAP_HISTOGRAM_END	  10124
#define NAP_SHISTOGRAM		  10125
#define NAP_SHISTOGRAM_END	  10126
#define NAP_USER_MODE		  10203
#define NAP_CLASS_LIST            10252
#define NAP_DLINE_LIST            10255
#define NAP_ILINE_LIST            10258
#define NAP_ELINE_LIST            10261
#define NAP_BROWSE_NEW		  10301
#define NAP_BROWSE_RESULT_NEW	  10302

HANDLER(nap_server_error);
HANDLER(nap_login_ack);
HANDLER(nap_register_fail);
HANDLER(nap_bad_nick);
HANDLER(nap_search_response);
HANDLER(nap_end_of_search);
HANDLER(nap_download_ack);
HANDLER(nap_private_message);
HANDLER(nap_get_error);
HANDLER(nap_user_sign_on);
HANDLER(nap_user_sign_off);
HANDLER(nap_browse_response);
HANDLER(nap_browse_end);
HANDLER(nap_server_stats);
HANDLER(nap_resume_match);
HANDLER(nap_hotlist_ack);
HANDLER(nap_hotlist_error);
HANDLER(nap_disconnecting);
HANDLER(nap_ignore_user);
HANDLER(nap_unignore_user);
HANDLER(nap_part_channel);
HANDLER(nap_public_message);
HANDLER(nap_error_message);
HANDLER(nap_create_channel);
HANDLER(nap_join_message);
HANDLER(nap_part_message);
HANDLER(nap_user_online);
HANDLER(nap_channel_topic);
HANDLER(nap_banlist_entry);
HANDLER(nap_channel_alt_topic);
HANDLER(nap_alternate_ack);
HANDLER(nap_linkspeed_response);
HANDLER(nap_eval_whois);
HANDLER(nap_eval_whowas);
HANDLER(nap_upload_request);
HANDLER(nap_set_port);
HANDLER(nap_channel_list_end);
HANDLER(nap_channel_list);
HANDLER(nap_remote_queued);
HANDLER(nap_motd);
HANDLER(nap_data_port_error);
HANDLER(nap_operator_message);
HANDLER(nap_global_message);
HANDLER(nap_nick_banlist);
HANDLER(nap_browse_direct);
HANDLER(nap_browse_direct_ok);
HANDLER(nap_browse_direct_err);
HANDLER(nap_ghost);
HANDLER(nap_sping);
HANDLER(nap_ping);
HANDLER(nap_pong);
HANDLER(nap_emote);
HANDLER(nap_channel_list_entry);
HANDLER(nap_global_user_end);
HANDLER(nap_global_user);
HANDLER(nap_server_links);
HANDLER(nap_whowas);
HANDLER(nap_usage_stats);
HANDLER(nap_version_stats);
HANDLER(nap_user_mode);
HANDLER(nap_browse_new);
HANDLER(nap_redirect);
HANDLER(nap_cycle);
HANDLER(nap_histogram);
HANDLER(nap_histogram_end);
HANDLER(nap_acl_list);
HANDLER(nap_command_unknown);
HANDLER(nap_shistogram);
HANDLER(nap_shistogram_end);


#endif
