/* Copyright (C) 2000-2003 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifndef SERVER_H_
#define SERVER_H_

#include "lopster.h"

server_t *server_new();
void server_set_status(server_t* server, int status, char* message);
void server_setup_main_menu();
int network_success(net_t* net);
void network_reset(net_t* net);
int server_disconnect(server_t* server, char* reason, int relogin);
int server_check(gpointer data);
int server_connect(server_t* server);
void server_set_nick(server_t * server, char *nick);
void server_set_passwd(server_t * server, char *passwd);
void server_set_address(server_t * server, char *address);
gint server_compare(GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2);
net_t* server_search_link(server_t* server);
void server_show(server_t* server);
void server_hide(server_t* server);
void server_update(server_t* server);
int server_load();
int server_save();
void server_remove_marked();
socket_t* network_socket(net_t* net);
void server_stats_get(net_t* net, char* server);
void server_update_stats();
user_level_t server_get_highest_level();
void network_links_get(net_t* net);
void network_links_free(net_t* net, int keep_root);
void network_links_print(net_t* net);
void network_new_link(net_t* net, char* data);
char* network_print_version(char* text, net_t* net);
void network_wait(net_t* net);
void network_go(net_t* net);

server_t* network_search_server(net_t* net, char* address);
server_t* network_search_link(net_t* net, server_t* server);
void network_show(net_t* net);
void network_hide(net_t* net);
void network_update(net_t* net, int stats);
void network_connect_next();
void network_start_connect(net_t* net);
void network_cancel_connect(net_t* net);
void network_disconnect(net_t* net);

void napigator_enter();
void napigator_leave(int success);
void napigator_get_list();
int napigator_restart_update(gpointer data);

void read_allowed_links();
void write_allowed_links();
void free_allowed_links();

void problems_get();

void latest_version_get(int just_check);
link_t *link_remove(link_t * link, char *name);
link_t *link_search_rec(link_t * link, char *name);

GtkWidget *create_server_popup(GtkWidget* popup, server_t* server,
			       int name);
GtkWidget* create_network_popup(GtkWidget* popup,
				GList* nets, int other);
GtkWidget* create_server1_popup(server_t* server);
GtkWidget* create_network1_popup();
GtkWidget* create_netgroup1_popup(net_group_t* ng);

GtkWidget* create_stats_popup();

void network_set_autojoin(char* network, char* channels);
void network_add_autojoin(net_t* network, char* channel);
void network_autojoin_channels(net_t* net);

server_t* server_create(char* servername, char* ip,
			int port, char* users, char* files,
			char* gigs, char* linespeed, int manual);
net_t* network_new(char* name, int type);
void network_add_server(net_t* net, server_t* server);
net_group_t* net_group_new(char* name);
void net_group_destroy(net_group_t* ng);
void net_group_show(net_group_t* ng);
void net_group_hide(net_group_t* ng);
void net_group_remove_net(net_group_t* ng, net_t* net);
void net_group_add_net(net_group_t* ng, net_t* net);
void network_move(net_t* net, net_group_t* to);
net_t* net_group_search_network(char* name);
int network_stats(net_t* net, int mode);
int net_group_stats(net_group_t* ng, int mode);
net_group_t* net_group_create(char* name, int flags, int hm);
void net_group_startup_connect();
void net_group_start_connect(net_group_t* ng);
void net_group_disconnect(net_group_t* ng);
void net_group_cancel_connect(net_group_t* ng);
void net_group_update(net_group_t* ng);
int server_get_input(gpointer data, gint source,
		     GdkInputCondition condition);
gboolean net_has_outgoing(net_t* net);

#endif
