// $Id: lprofmain.cpp,v 1.89 2006/06/10 18:43:34 hvengel Exp $

//  Lttle cms Profiler
//  Copyright (C) 1998-2001 Marti Maria
// Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//
// Version 1.11

// #include <qdir.h>

// #if defined( _WIN32 )
// #define NOMINMAX
// #define NORESOURCE
// #endif

#include <qtextbrowser.h>
#include <profileid.h>
#include <profileparms.h>
#include <monitorvalues.h>
#include <profilechecker.h>
#include <qtlcmswidgets.h>
#include "lprofmain.h"
#include <string.h>
#include <qlineedit.h>
#include <stdlib.h>
#include <qlist.h>
#include <qsettings.h>
#include "installreffile.h"

#include "vigra/imageiterator.hxx"
#include "vigra/rgbvalue.hxx"
#include "vigra/accessor.hxx"
#include "vigra/impex.hxx"
#include "vigra/stdimage.hxx"
#include "vigra/inspectimage.hxx"
#include <lcmsprf.h>
#include <qcolor.h>

static QAssistantClient* help;

QAssistantClient* getHelp()
{
    return help;
}

static BOOL int16, int32, uint8, fltpix, dblpix;

struct dialogSizes
{
    int
    reffileH, reffileW,
    monvalH, monvalW,
    profchH, profchW,
    profidH, profidW,
    profparmsH, profparmsW,
    lprofH, lprofW;

} dsizes;

static int dialogH, dialogW;

static QPointArray grid_corners;
static QPtrList<target_template> *targetList=0;
QDir dir;
BOOL corners_ready;
static monVal monitorValues;
static PROFILERDATA sys;
uint last_tab;
struct parms_ID_data
{
     char Description[256];
     char Manufacturer[256];
     char Model[256];
     char Copyright[256];
     char Comments[256];
     cmsCIExyYTRIPLE Primaries;
     int CLUTPoints;                 /* Final CLUT resolution */
     int ProfileVerbosityLevel;	   /* 0=minimum, 1=additional, 2=Verbose, 3=Any suitable */
     bool lUseCIECAM97s;              /* Use CIECAM97s for chromatic adaptation? */

     cmsViewingConditions device;     /* Viewing condition of source */
     cmsViewingConditions PCS;        /* Viewing condition of PCS */

    LCMSHANDLE hDevice;              /* CIECAM97s models used for adaptation */
    LCMSHANDLE hPCS;                 /* and viewing conditions */
    double       RsplSmoothness;		/* smoothing factor */
    double       AvgDev;
};

parms_ID_data data[3];


// Console and Gauger

static QTextEdit*    Console;
static QProgressBar*      ProgBar;

QString ConfigFile;
QString measfile;
QString templates;
QString mon_profile;
QString in_profile;
QString ref_dir;
QString WorkTempFileName;
QString outprofile;
QString measurement_dir;
QString image_file_name;

const int measure_view_H=1500;
const int measure_view_V=1000;

vigra::ImageImportInfo *image_data = NULL;
// vigra::destImage *in;

struct mark_pos
{
    int  ur_x, ur_y;
    int ul_x, ul_y;
    int lr_x, lr_y;
    int ll_x, ll_y;
  }  Marks;

QString get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}

#if !defined(__WIN32__) && (defined(_WIN32) || defined(WIN32))
#define __WIN32__
#endif

 # ifdef __WIN32__
using std::min;
 # else
    static int min (int a, int b)
    {
        if (a < b) return a;
        return b;
    }
# endif /* __WIN32__ */

void add_target(target_template &in)
{
    BOOL found;
    target_template* item;
    QString temp;

    // qDebug(temp.sprintf("before add number of items in target list = %i", targetList->count()));

    found = FALSE;
    // look to see if this target is already installed.
    // if it is update the template file
    if (!targetList->isEmpty())  // taragetList has items so check it to see if this is a dupelicate
    {   // qDebug("target list not empty");
        for (uint i = 0;  i < targetList->count();  i++)
          if (targetList->at(i)->targetFile == in.targetFile)
              {
                   targetList->at(i)->templateFile = in.templateFile;
                   found=TRUE;
                   i = targetList->count();
              }
    }
    if (!found) // not a dupicate target file so create new entry
    {
        // qDebug("target not found");
        item = new target_template;
        item->targetFile = in.targetFile;
        item->templateFile = in.templateFile;
        // place new target ref file in list of target ref files
        targetList->insert(targetList->count(), item);
    }
    // qDebug(temp.sprintf("after add number of items in target list = %i", targetList->count()));
}

void setData(uint i)
{
    data[i].CLUTPoints = sys.hdr.CLUTPoints;
    data[i].ProfileVerbosityLevel = sys.hdr.ProfileVerbosityLevel;
    data[i].RsplSmoothness = sys.RsplSmoothness;
    data[i].AvgDev =  sys.AvgDev;
    data[i].lUseCIECAM97s = sys.hdr.lUseCIECAM97s;
    data[i].device.surround = sys.hdr.device.surround;
    data[i].device.La = sys.hdr.device.La;
    data[i].device.Yb = sys.hdr.device.Yb;
    // profile ID information
    strcpy(data[i].Manufacturer, sys.hdr.Manufacturer);
    strcpy(data[i].Model, sys.hdr.Model);
    strcpy(data[i].Copyright, sys.hdr.Copyright);
    strcpy(data[i].Description, sys.hdr.Description);
}

void init_env()
{
    const QString ConfigFileconst="/.lprof/config/lprof.cfg";
    const QString measfileconst="/.lprof/temp/meaurement.cgt";
    const QString WorkTempFileNameconst = "/.lprof/temp/$$q60$$.$$$";
    const QString templateconst = "/.lprof/templates";
    const QString measure_dir_const = "/.lprof/measurements";
    QDir d;
    # ifdef __WIN32__
        QString win = getenv("SystemRoot");
        // lets use only forward slashes, not backslashes
        win.replace( '\\', "/" );
        win +=  "/system32/spool/drivers/color";
        mon_profile = win;
        in_profile= win;
        outprofile = win;
    # else
        mon_profile = "/usr/share/color/icc";
        in_profile = "/usr/share/color/icc";
        outprofile = d.homeDirPath() + "/.color/icc";
    # endif /* __WIN32__ */

    const QString ref_dirconst = "/.lprof/target_refs";

    // qDebug("init_env");

    QString home = d.homeDirPath();
    ConfigFile = home + ConfigFileconst;
    // qDebug(ConfigFile);

    measurement_dir = home + measure_dir_const;

    measfile = home + measfileconst;

    templates = home + templateconst;

    WorkTempFileName = home + WorkTempFileNameconst;

    ref_dir = home + ref_dirconst;

    strcpy(sys.hdr.temp_file, home + WorkTempFileNameconst);

}


static int ConsolePrintf(const char *frm, int parms, char typ, ...)
{

    QString Buffer, temp;
    va_list args;

    /* TRANSLATOR Text displayed in the messages widget */
    QString Warn1 = lprofMain::tr("*** WARNING: Inconsistences found, profile may be wrong. Check the target!"),
    /* TRANSLATOR Text displayed in the messages widget */
    Load1 = lprofMain::tr("Loading sheets..."),
    /* TRANSLATOR Text displayed in the messages widget */
    RefSh1 = lprofMain::tr("Reference sheet: %1"),
    /* TRANSLATOR Text displayed in the messages widget */
    MeasSh = lprofMain::tr("Measurement sheet: %1"),
    /* TRANSLATOR Text displayed in the messages widget */
    PrimSh = lprofMain::tr("Primaries: R:%1, %2  G:%3, %4  B:%5, %6"),
    /* TRANSLATOR Text displayed in the messages widget */
    PrimSh2 = lprofMain::tr("Primaries (x-y): [Red: %1, %2] [Green: %3, %4] [Blue: %5, %6]"),
    /* TRANSLATOR Text displayed in the messages widget */
    ghullSh = lprofMain::tr("Gamut hull: %1 inside, %2 outside, %3 on boundaries"),
    /* TRANSLATOR Text displayed in the messages widget */
    estgamaSh = lprofMain::tr("Estimated gamma: [Red: %1] [Green: %2] [Blue: %3]"),
    /* TRANSLATOR Text displayed in the messages widget */
    LabPCSSh = lprofMain::tr("I have chosen CIE Lab as PCS"),
    /* TRANSLATOR Text displayed in the messages widget */
    XYZPCSSh = lprofMain::tr("I have chosen CIE XYZ as PCS"),
    /* TRANSLATOR Text displayed in the messages widget */
    WPnear = lprofMain::tr("White point near %1"),
    /* TRANSLATOR Text displayed in the messages widget */
    WPunknown = lprofMain::tr("Unknown white point %1"),
    FitError1 = lprofMain::tr("Fitting error (delta E CIELAB): mean=%1, RMS=%2, 95%%=%3, median=%4, MAD=%5"),
    FirError2 = lprofMain::tr("Fitting error (delta E CIE94): mean=%1, RMS=%2, 95%%=%3, median=%4, MAD=%5"),
    selFile = lprofMain::tr("select file name"),
    workhard = lprofMain::tr("Working hard..."),
    cantProfile = lprofMain::tr("** ERROR: Unable to profile."),
    done = lprofMain::tr("Profile '%1' DONE!");

    Buffer = QTranslator::tr(frm);

    va_start(args, typ);

    while ( parms > 0) {
        switch(typ)
        {
            case 's':
                Buffer = Buffer.arg(va_arg(args, char *));
                break;
            case 'd':
                temp.sprintf("<font color=red>%i</font>",va_arg(args, int));
                Buffer = Buffer.arg(temp);
                break;
            case 'c':
                temp.sprintf("<font color=green>%i</font>",va_arg(args, int));
                Buffer = Buffer.arg(temp);
                break;
            case 'f':
                temp.sprintf("<font color=blue>%g</font>", va_arg(args, double));
                Buffer = Buffer.arg(temp);
                break;
            case ' ':
                break;
            default:
                qDebug("type not in cases");
                break;
        }
        parms = parms - 1;
    }

    Console -> append(Buffer);
    Console -> sync();
    va_end(args);
    return 1;
}

static int Gauger(const char * /*Label*/, int nMin, int nMax, int Pos)
{

    // qDebug("Gauger");
    if (nMin < 0 && nMax < 0)
    {
        return 1;
    }

    ProgBar -> setTotalSteps(nMax);
    ProgBar -> setProgress(Pos);
    return 1;
}

void lprofMain::init_mon()
{
    // qDebug("init_mon");
    monitorValues.items.wppos=0;
    monitorValues.items.ppos=0;
    monitorValues.items.temp=6500;
    monitorValues.items.linked=1;
    monitorValues.items.rchecked=TRUE;
    monitorValues.items.gchecked=FALSE;
    monitorValues.items.bchecked=FALSE;
    monitorValues.items.rgamma= 2.4;
    monitorValues.items.ggamma= 2.4;
    monitorValues.items.bgamma= 2.4;
    connect(MonMeasurementSheet, SIGNAL(valueChanged()), this, SLOT(slotChangeStrategy()));

}

static void init_marks()
{
    Marks.ur_x=measure_view_H;
    Marks.ur_y=0;

    Marks.ul_x=0;
    Marks.ul_y=0;

    Marks.lr_x=measure_view_H;
    Marks.lr_y=measure_view_V;

    Marks.ll_x=0;
    Marks.ll_y=measure_view_H;

    corners_ready=FALSE;

}

// Measurement tool stuff
// GridLayout, represents one patch

void lprofMain::Reload()
{
    // qDebug("lprof::Reload");
    TheImage -> Reload(fn, MonitorProfileSelector ->getFilename(),
                                 InputProfileSelector->getFilename(),
                                 Canvas);
}

int GridLayout::Scale(int n, int amax)
{
    // qDebug("Gridlatout::Scale");
    return (int) (((double) (n*amax)/LAYOUT_MAX)+.5);
}


// This is where the template patches are layed out over the IT8 image.

void GridLayout::ScaleTo(int w, int h, QRect& Scaled)
{
    QPoint A, B, C, D;
    int length_w, length_h, offset_x, offset_y, offset_x2, offset_y2, dDA, dBA, dCD, dCB, adj_x, adj_y;

    A=grid_corners.point(0);
    B=grid_corners.point(1);
    C=grid_corners.point(2);
    D=grid_corners.point(3);

    adj_x=min(A.x(),D.x());
    A.setX(A.x()-adj_x);
    B.setX(B.x()-adj_x);
    C.setX(C.x()-adj_x);
    D.setX(D.x()-adj_x);
    adj_y=min(A.y(),B.y());
    A.setY(A.y()-adj_y);
    B.setY(B.y()-adj_y);
    C.setY(C.y()-adj_y);
    D.setY(D.y()-adj_y);

    dDA=A.x()-D.x();
    dBA=A.y()-B.y();
    dCD=C.y()-D.y();
    dCB=B.x()-C.x();

    if (dDA>0)
        offset_x= abs(dDA)- abs((int)((double)dDA  * ((double) rect.y()/ (double)LAYOUT_MAX)+.5));
    else
        offset_x= abs(dDA)- abs((int)((double)dDA  * (1.0 - ((double) rect.y()/ (double)LAYOUT_MAX)+.5)));

    if (dCB>0)
        offset_x2= abs(dCB)- abs((int)((double)dCB * (1.0 -((double) rect.y()/ (double)LAYOUT_MAX)+.5)));
    else
        offset_x2= abs(dCB)- abs((int) ((double)dCB * ((double) rect.y()/ (double)LAYOUT_MAX)+.5));

    if (dBA>0)
        offset_y=abs(dBA)- abs((int) ((double)dBA * ((double) rect.x()/ (double)LAYOUT_MAX)+.5));
    else
        offset_y= abs(dBA)- abs((int) ((double)dBA * (1.0 - ((double) rect.x()/ (double)LAYOUT_MAX)+.5)));

    if (dCD<0)
        offset_y2= abs(dCD)- abs((int)((double)dCD * ( 1.0 - ((double) rect.x()/ (double)LAYOUT_MAX)+.5)));
    else
        offset_y2= abs(dCD) - abs((int) ((double)dCD * ((double) rect.x()/ (double)LAYOUT_MAX)+.5));

    length_w = w - (offset_x + offset_x2);
    length_h = h - (offset_y + offset_y2);

    // qDebug("Gridlayout::ScaleTo");
     Scaled.setRect(Scale(rect.x(), length_w ) + offset_x,
                   Scale(rect.y(), length_h) + offset_y,
                   Scale(rect.width(), length_w),
                   Scale(rect.height(), length_h));
}

// A ICC profile transform on whole image


void ImageItem::TransformImage(const QString OutputProfile,
                               const QString InputProfile,
                               vigra::DRGBImage& p,
                               QImage& pout)
{
    struct dblColor
    {
        double r, g, b;
    };

    struct uint8Color
    {
        char r, g, b;
    };

    dblColor *RGB;
    uint8Color *rgb;
    double divisor;

    RGB = (dblColor*) malloc(sizeof(dblColor));
    rgb = (uint8Color*) malloc(sizeof(uint8Color));
    // qDebug("ImageItem::TransformImage");
    cmsHTRANSFORM xform;
    cmsHPROFILE hIn, hOut;

    hIn  = cmsOpenProfileFromFile(InputProfile.local8Bit(), "r");
    hOut = cmsOpenProfileFromFile(OutputProfile.local8Bit(), "r");

    xform = cmsCreateTransform(hIn, TYPE_RGB_DBL, hOut, TYPE_RGB_8,
                        INTENT_PERCEPTUAL, cmsFLAGS_WHITEBLACKCOMPENSATION);

    vigra::DRGBImage::Iterator point=p.upperLeft();

    if (uint8) divisor = 255.0;
    else if (int16) divisor = 65536.0;
    else if (int32) divisor = 4294967296.0;

    for (int i=0; i < p.height(); i++)
        for (int j=0; j < p.width(); j++)
        {
            if (uint8 | int16 | int32)
            {
                // scale RGB values to max = 1.0
                // since this is what is expected for
                // floating point images
                RGB->r = point(j, i).red()/divisor;
                RGB->g = point(j, i).green()/divisor;
                RGB->b = point(j, i).blue()/divisor;
            }
            else // Floating point image
                // no rescaling of RGB values needed
            {
                RGB->r = point(j, i).red();
                RGB->g = point(j, i).green();
                RGB->b = point(j, i).blue();
            }
            cmsDoTransform(xform, RGB, rgb, 1);
            pout.setPixel(j,i, qRgba ( rgb->r, rgb->g, rgb->b, 0xff));
        }

    cmsDeleteTransform(xform);
    cmsCloseProfile(hIn);
    cmsCloseProfile(hOut);
    free(RGB);
    free(rgb);
}



ImageItem::ImageItem(QString ImageFile, const QString Monitor, const QString Scanner, QCanvas *canvas )
    : QCanvasRectangle( canvas ), image()
{

    // qDebug("ImageItem::ImageItem");
    lProof = FALSE;
    Reload(ImageFile, Monitor, Scanner, canvas);
}


void ImageItem::Reload(QString ImageFile, const QString Monitor, const QString Scanner, QCanvas *canvas )
{

    // qDebug("ImageItem::Reload");

     char file[256];
     uint  rvi = 0;
     uint  gvi = 0;
     uint  bvi = 0;
     double r, g, b;

    if (ImageFile == QString::null) return;  // make sure there is a file name
    if (!QFile::exists(ImageFile)) return;
    strcpy(file,  ImageFile.local8Bit());

    // check to see if the file name point to a valid image file
    if (!vigra::isImage(file))
    {
        QMessageBox mb( QTranslator::tr(QString("Load image failure")),
                        QTranslator::tr(QString("This image format is unsupported by LPROF\n") +
                                "on your system. Sorry. Supported ones \n" +
                                "are BMP, GIF, JPEG, PNG, PBM, PGM,\n" +
                                "PNM, PPM, SUN, TIFF and VIFF."),
                        QMessageBox::Critical,
                        QMessageBox::Ok | QMessageBox::Default,
                        QMessageBox::NoButton,  QMessageBox::NoButton);

    mb.exec();
    return;
    }
    if (image_data) delete image_data;
    image_data = new vigra::ImageImportInfo(file);

     // make sure it is a color image
     if (!(image_data->isColor()))
     {
         QMessageBox mb( QTranslator::tr(QString("Load image failure")),
                         QTranslator::tr(QString("This image is not a color RGB image.\n") +
                        "Only color images are supported at this time."),
                        QMessageBox::Critical,
                        QMessageBox::Ok | QMessageBox::Default,
                        QMessageBox::NoButton,  QMessageBox::NoButton);

    mb.exec();
    return;
    }

    image_file_name = (QString) ImageFile;
    QString pixtype = (QString) image_data->getPixelType();
    int16 = (pixtype.contains( "INT16") > 0);
    int32 = (pixtype.contains( "INT32") > 0);
    uint8 = (pixtype.contains( "UINT8") > 0);
    fltpix = (pixtype.contains( "FLOAT") > 0);
    dblpix = (pixtype.contains( "DOUBLE") > 0);

    // try again
    vigra::DRGBImage in(image_data->width(), image_data->height());
    vigra::importImage(*image_data, destImage(in));
    vigra::DRGBImage::Iterator point=in.upperLeft();

    if (! image.create (image_data->width(),
          image_data->height(), 32, 0,
          QImage::IgnoreEndian))
        qDebug( "image create failed");  // should never happen

    for (int i=0; i < image_data->height(); i++)
        for (int j=0; j < image_data->width(); j++)
           {
                r = point(j, i).red();
                g = point(j, i).green();
                b = point(j, i).blue();

                if (uint8)
                {
                    rvi=(uint)r;
                    gvi=(uint)g;
                    bvi=(uint)b;
                }
                else if (int16)
                {
                    // This code is a work around for a bug in VIGRA
                    if (r < 0.0)
                    {
                        r = r + 65536.0;
                        point(j, i).setRed(r);
                    }
                    if (g < 0.0)
                    {
                        g = g + 65536.0;
                        point(j, i).setGreen(g);
                    }
                    if (b < 0.0)
                    {
                        b = b + 65536.0;
                        point(j, i).setBlue(b);
                    }

                    // Normalize to 8 bits/channel for display
                    rvi=(uint)(r/257.0);
                    gvi=(uint)(g/257.0);
                    bvi=(uint)(b/257.0);
                }
                else if (int32)
                {
                    // This code is a work around for a bug in VIGRA
                    if ( r < 0.0)
                    {
                        r = r + 4294967296.0;
                        point(j, i).setRed(r);
                    }
                    if (g < 0.0)
                    {
                        g = g + 4294967296.0;
                        point(j, i).setGreen(g);
                    }
                    if (b < 0.0)
                    {
                        b = b + 4294967296.0;
                        point(j, i).setBlue(b);
                    }
                    // Normalize to 8 bits/channel for display
                    rvi=(uint)(r/16843009.0);
                    gvi=(uint)(g/16843009.0);
                    bvi=(uint)(b/16843009.0);
                }
                else if (fltpix || dblpix )
                {   // float or double encoding
                    // this may be wrong fix me
                    // normalize the range
                    // max of 255
                    rvi = (uint) (r * 255.0);
                    gvi = (uint) (g * 255.0);
                    bvi = (uint) (b * 255.0);
                }

                image.setPixel(j,i, qRgba ( rvi, gvi, bvi, 0xff));
             }


    QImage scaled = image.smoothScale(canvas->width(), canvas->height());

    setSize( scaled.width(), scaled.height() );

    sx = (double) image.width() / scaled.width();
    sy = (double) image.height() / scaled.height();

    pixmap.convertFromImage(scaled);

    if (lProof)
    {
        if (Monitor != QString::null && Scanner != QString::null)
            TransformImage(Monitor, Scanner, in, image);
    }

    QImage pscaled = image.smoothScale(canvas->width(), canvas->height());
    proof.convertFromImage(pscaled);

    move(0, 0);
    setZ(5);
    show();
}


void ImageItem::drawShape( QPainter &p )
{
    // qDebug("ImageItem::drawShape");
    p.drawPixmap( int(x()), int(y()), lProof? proof : pixmap );
}



// ---------------------------------------------------------------- The grid item

GridItem::GridItem( QCanvas *canvas, QString Template, int SafeFrame )
    : QCanvasRectangle( 10, 10, canvas->width() - 10, canvas->height() - 10, canvas)
{
    // qDebug("GridItem::GridItem");
    // UnShearFactor = 0.0;
    SafeFrameFactor = SafeFrame / 100.;
    setBrush( NoBrush) ;

    Layout.setAutoDelete(TRUE);
    LCMSHANDLE hIT8 = cmsxIT8LoadFromFile(Template.local8Bit());

    if (hIT8) {

        int nRects = (int) cmsxIT8GetPropertyDbl(hIT8, "NUMBER_OF_SETS");
        char PatchName[256];

        for (int i=0; i < nRects; i++) {

            if (cmsxIT8GetDataSetByPos(hIT8, 0, i, PatchName, 256)) {

                GridLayout* Patch = new GridLayout;

                double x, y, xSize, ySize;

                cmsxIT8GetDataSetDbl(hIT8, PatchName, "POS_X", &x);
                cmsxIT8GetDataSetDbl(hIT8, PatchName, "POS_Y", &y);
                cmsxIT8GetDataSetDbl(hIT8, PatchName, "SIZE_X", &xSize);
                cmsxIT8GetDataSetDbl(hIT8, PatchName, "SIZE_Y", &ySize);

                strcpy(Patch -> p.Name, (const char *) PatchName);
                Patch -> rect.setRect(int(x), int(y), int(xSize), int (ySize));

                Layout.append(Patch);

            }
        }

        cmsxIT8Free(hIT8);
    }

    setZ(10);
    show();
}



static
void DoDeflateRect(QRect& rect, int sx, int sy)
{
    // qDebug("DoDeflateRect");
    rect.setRect(rect.x() + sx, rect.y() + sy,
                  rect.width()-sx*2, rect.height()-sx*2);
}


void GridItem::ComputePatchRects(QRect& OurViewport, GridLayout* Patch,
                                 QRect& Frame, QRect& HotZone)
{
        QRect Scaled;

        // qDebug("GridItem::ComputePatchRects");
        Patch ->ScaleTo(OurViewport.width(), OurViewport.height(), Scaled);

        int translateX = OurViewport.x();
        int translateY = OurViewport.y();

        Scaled.moveBy(translateX, translateY);

        Frame = Scaled;

        int SafeFrame = (int) ((double) Scaled.width() * SafeFrameFactor / 2.);

        DoDeflateRect(Scaled, SafeFrame, SafeFrame);

        HotZone = Scaled;
}


// Compute our viewport extension

void GridItem::ComputeViewport(QRect& OurViewport, double sx, double sy)
{

    int x;
    int y;
    int w;
    int h;

    x=(int) (min(Marks.ll_x, Marks.ur_x) * sx);
    y=(int) (min( Marks.ur_y, Marks.ul_y) * sy);
    w=(int) (mmax(Marks.ur_x, Marks.lr_x) * sx - x);
    h=(int) (mmax(Marks.lr_y, Marks.ll_y) * sy - y);
    OurViewport.setRect(x, y, w, h);
}


void GridItem::drawShape( QPainter &p )
{
    GridLayout* Patch;
    QRect OurViewport;

    // qDebug("GridItem::drawShape");

    ComputeViewport(OurViewport, 1.0, 1.0);

    if (corners_ready) {
        for (Patch = Layout.first();
            Patch;
            Patch = Layout.next()) {

                QRect Frame, HotZone;

                // Scale to our viewport
                ComputePatchRects(OurViewport, Patch, Frame, HotZone);

                // Draw
                // p.setPen( Qt::white );
                // p.drawRect(Frame);

                p.setPen( Qt::green );
                p.drawRect(HotZone);

            }  // end for
        } // enf if

    // Do this allways to mark corners but only mark corners after the user
    // clicks to add a mark

    p.setPen( Qt::red );

    // upper right corner only draw the corner mark of the user has clicked
    if (Marks.ur_x<measure_view_H && Marks.ur_y>0) {
        p.drawLine(Marks.ur_x, Marks.ur_y, Marks.ur_x - 50, Marks.ur_y);
        p.drawLine(Marks.ur_x, Marks.ur_y, Marks.ur_x, Marks.ur_y + 50);
    }

    // upper left corner
    if (Marks.ul_x>0 && Marks.ul_y>0) {
        p.drawLine(Marks.ul_x, Marks.ul_y, Marks.ul_x + 50, Marks.ul_y);
        p.drawLine(Marks.ul_x, Marks.ul_y, Marks.ul_x, Marks.ul_y + 50);
    }

    // lower right corner
    if (Marks.lr_x>0 && Marks.lr_y<measure_view_V) {
        p.drawLine(Marks.lr_x, Marks.lr_y, Marks.lr_x - 50, Marks.lr_y);
        p.drawLine(Marks.lr_x, Marks.lr_y, Marks.lr_x, Marks.lr_y - 50);
    }

    // lower left corner
    if (Marks.ll_x<measure_view_H && Marks.ll_y<measure_view_V) {
        p.drawLine(Marks.ll_x, Marks.ll_y, Marks.ll_x + 50, Marks.ll_y);
        p.drawLine(Marks.ll_x, Marks.ll_y, Marks.ll_x, Marks.ll_y - 50);
    }
}


void GridItem::Pick(QString InputProfileName, QImage& Image, double sx, double sy )
{
    GridLayout* Patch;
    QRect OurViewport;
     // qDebug("GridItem::Pick");
    cmsHTRANSFORM hInputXFORM;
    cmsHPROFILE hLab = NULL, hInputProfile = NULL;

    // Will not compile with QT_NO_ASCII_CAST turned on
    // when changed to
    // const char* cInputProfile = InputProfileName.local8Bit();
    // Will get runtime errors for bad file name
    // Needs to be fixed
    const char* cInputProfile = InputProfileName;

    if (cInputProfile) {

        hLab          = cmsCreateLabProfile(NULL);
        hInputProfile = cmsOpenProfileFromFile(cInputProfile, "r");
        hInputXFORM   = cmsCreateTransform(hInputProfile, TYPE_RGB_DBL,
                                        hLab, TYPE_Lab_16, INTENT_ABSOLUTE_COLORIMETRIC,
                                        cmsFLAGS_NOTPRECALC);
    }
    else hInputXFORM = NULL;
    ComputeViewport(OurViewport, sx, sy);

    vigra::DRGBImage in(image_data->width(), image_data->height());
    vigra::importImage(*image_data, destImage(in));
    vigra::DRGBImage::Iterator point=in.upperLeft();

    for (Patch = Layout.first();
            Patch;
            Patch = Layout.next()) {

                // Scale to our viewport

                QRect Frame, HotZone;

                ComputePatchRects(OurViewport, Patch, Frame, HotZone);

                // Ok, take

                Statistic r, g, b;  // These are doubles

                int xstart = HotZone.x();
                int ystart = HotZone.y();
                int xsize  = HotZone.width();
                int ysize  = HotZone.height();

                Patch->p.pos_x = xstart+xsize/2.0;
                Patch->p.pos_y = ystart+ysize/2.0;

                Patch->p.Colorant.RGB[0] = 0;
                Patch->p.Colorant.RGB[1] = 0;
                Patch->p.Colorant.RGB[2] = 0;
                Patch->p.dwFlags         = 0;

                if ((xstart < 0) || (ystart < 0) ||
                    ((xstart + xsize) > Image.width()) ||
                    ((ystart + ysize > Image.height())))
                                continue;

                // debug code to see where hot zone patches
                // are really placed

                // printf("PICK %s [%d %d] [%d %d]\n",

               //      Patch->p.Name, xstart, ystart,

                 //   xstart+xsize-1, ystart+ysize-1);

                // qDebug("interating image");

                double rv;
                double gv;
                double bv;
		int npixels;

                for (int i = npixels = 0; i < ysize; i++) {
                    for (int j=0; j < xsize; j++) {
                        rv = point(xstart+j, ystart+i).red();
                        gv = point(xstart+j, ystart+i).green();
                        bv = point(xstart+j, ystart+i).blue();
                        // Fix for VIGRA bug
                        if (int16)
                        {
                        // This code is a work around for a bug in VIGRA
                            if (rv < 0.0)rv = rv + 65536.0;
                            if (gv < 0.0) gv = gv + 65536.0;
                            if (bv < 0.0) bv = bv + 65536.0;
                        }
                        else if (int32)
                        {
                         // This code is a work around for a bug in VIGRA
                            if (rv < 0.0) rv = rv + 4294967296.0;
                            if (gv < 0.0) gv = gv + 4294967296.0;
                            if (bv < 0.0) bv = bv + 4294967296.0;
                        }
                        r.Add(rv); g.Add(gv); b.Add(bv);
			npixels++;
                    }
		}

                Patch ->p.dwFlags = PATCH_HAS_POS|PATCH_HAS_RGB|
				    PATCH_HAS_STD_RGB|PATCH_HAS_CHISQ;

                Patch ->p.Colorant.RGB[0] = r.Mean();
                Patch ->p.Colorant.RGB[1] = g.Mean();
                Patch ->p.Colorant.RGB[2] = b.Mean();

                Patch ->p.Stdev.RGB[0] = r.Std() / sqrt(double(npixels));
                Patch ->p.Stdev.RGB[1] = g.Std() / sqrt(double(npixels));
                Patch ->p.Stdev.RGB[2] = b.Std() / sqrt(double(npixels));

                Patch->p.ChiSq = (r.Std() + g.Std() + b.Std()) / 3.0;

                if (hInputXFORM) {
                    double divisor;
                    double RGB[3];
                    WORD LabEncoded[3];

                    if (uint8) divisor = 255.0;
                    else if (int16) divisor = 65536.0;
                    else if (int32) divisor = 4294967296.0;

                    if (uint8 | int16 | int32)
                    {
                        // convert to floating point encoding if needed
                        RGB[0] = Patch -> p.Colorant.RGB[0]/divisor;
                        RGB[1] = Patch -> p.Colorant.RGB[1]/divisor;
                        RGB[2] = Patch -> p.Colorant.RGB[2]/divisor;
                    }
                    else
                    {
                        RGB[0] = Patch -> p.Colorant.RGB[0];
                        RGB[1] = Patch -> p.Colorant.RGB[1];
                        RGB[2] = Patch -> p.Colorant.RGB[2];
                    }

                    cmsDoTransform(hInputXFORM, RGB, LabEncoded, 1);
                    cmsLabEncoded2Float(&Patch ->p.Lab, LabEncoded);
                    cmsLab2XYZ(NULL, &Patch ->p.XYZ, &Patch ->p.Lab);
                }
    }

    if (hInputXFORM) {

        cmsDeleteTransform(hInputXFORM);
        cmsCloseProfile(hInputProfile);
        cmsCloseProfile(hLab);
    }

}


// ------------------------------------------------------------ The figure editor

void FigureEditor::resizeEvent( QResizeEvent* e )
{
     // qDebug("FigureEditor::resizeEvent");
  QCanvasView::resizeEvent( e );
  maindialog.FigEditor-> resize(width(), height());

}

void FigureEditor::contentsMousePressEvent(QMouseEvent* e)
{

    // qDebug("FigureEditor::contentsMousePressEvent");
    if (e->x()<measure_view_H/2 && e->y()<measure_view_V/2) {
         // upper left quadrant
         Marks.ul_x=e->x();
         Marks.ul_y=e->y();
          }
    else
        if (e->x()>measure_view_H/2 && e->y()<measure_view_V/2) {
           // upper right quadrant
            Marks.ur_x=e->x();
            Marks.ur_y=e->y();
        }
    else
        if (e->x()>measure_view_H/2 && e->y()>measure_view_V/2) {
            // lower right quadrant
            Marks.lr_x=e->x();
            Marks.lr_y=e->y();
        }
    else
        if (e->x()<measure_view_H/2 && e->y()>measure_view_V/2) {
            // lower left quadrant
            Marks.ll_x=e->x();
            Marks.ll_y=e->y();
        }


    // place corner markers to give user feed back that the corner has been marked

    grid_corners.putPoints(0, 4, Marks.ul_x,  Marks.ul_y,
                                 Marks.ur_x, Marks.ur_y,
                                 Marks.lr_x, Marks.lr_y,
                                 Marks.ll_x, Marks.ll_y);
    maindialog.AddTemplate();

    // check to see if all corners are marked and it is time to place full template and pick

    if (Marks.ul_x>0 && Marks.ur_x<measure_view_H &&
        Marks.ll_x>0 && Marks.lr_x<measure_view_H)
    {

        corners_ready=TRUE;

        maindialog.slotPick();

    }

}


void FigureEditor::clear()
{
    // qDebug("FigureEditor::clear");
    QCanvasItemList list = canvas()->allItems();
    QCanvasItemList::Iterator it = list.begin();
    for (; it != list.end(); ++it) {
        if ( *it )
            delete *it;
    }

    moving = NULL;
    sizing = NULL;
    unshearing = NULL;
}

void lprofMain::AddTemplate()
{
    // qDebug("lprofMain::AddTemplate");
     QString Template     = SelectTemplate -> getFilename();
     double  SafeFrameVal = SafeFrame->value();
    if ((TheImage != NULL) && (Template != QString::null)) {

        if (TheGrid != NULL)
            delete TheGrid;

       TheGrid = new GridItem(Canvas, Template, (int) SafeFrameVal);
       CurrentTemplate  = Template;
       CurrentSafeFrame = SafeFrameVal;
    }
}


void lprofMain::slotLoad()
{
    // qDebug("lprofMain::slotLoad");

    fn = QFileDialog::getOpenFileName( dir.homeDirPath(),
                                       tr(QString("Image files (*.gif *.png *.jpg *.bmp *.pbm *.pgm *.pnm *.sun *.tif *.tiff *.viff *.GIF *.PNG *.JPG *.BMP *.PBM *.PGM *.PNM *.SUN *.TIF *.TIFF *.VIFF)\nAll files (*.*)")),
                                                this,
                                                "",
                                                tr(QString("Select target image")));

    if (fn == QString::null) return;

    FigEditor->clear();
    TheGrid = NULL;
    CurrentTemplate = "";
                // fix me ?? what does ProofTogle do ???
    if (ProofToggle -> isOn()) ProofToggle -> toggle();

    TheImage = new ImageItem(fn, MonitorProfileSelector ->getFilename(),
                                InputProfileSelector->getFilename(),
                                Canvas);
    init_marks();

}

void lprofMain::slotProof()
{
    if (TheImage) {
            TheImage -> lProof = ProofToggle -> isOn();

		TheImage -> Reload(fn, MonitorProfileSelector ->getFilename(),
                                 InputProfileSelector->getFilename(),
                                 Canvas);

            Canvas->setChanged(rect());
            Canvas->update();
            ControlsToValues();
    }

}

/* void lprofMain::SaveIT8(const char *filename)
{
    // fix me raw edit no longer supported

    QString text = IT8Edit->text();
    QFile f( filename );
    if ( !f.open( IO_WriteOnly ) ) {
    return;
    }

    QTextStream t( &f );
    t << text;
    f.close();

    IT8Edit->setEdited( FALSE );
} */


void lprofMain::DumpResultsToIT8(QList<GridLayout>& Layout)
{
    // qDebug("lprofMain::DumpResultsToIT8");
    LCMSHANDLE it8 = cmsxIT8Alloc();

    cmsxIT8SetSheetType(it8, "LCMS/MEASUREMENT");
    cmsxIT8SetProperty(it8, "ORIGINATOR",   (const char *) "LPROF");
    cmsxIT8SetProperty(it8, "DESCRIPTOR",   (const char *) "hidden measurement sheet");
    cmsxIT8SetProperty(it8, "MANUFACTURER", (const char *) "LPROF");
    cmsxIT8SetProperty(it8, "CREATED",      (const char *) "");
    cmsxIT8SetProperty(it8, "SERIAL",       (const char *) "");
    cmsxIT8SetProperty(it8, "MATERIAL",     (const char *) "");

    cmsxIT8SetProperty(it8, "CHISQ_DOF",    "3");

    GridLayout* Patch;
    int nSets = 0;
    int nFields = 7;

    for (Patch = Layout.first(); Patch; Patch = Layout.next()) {

	if (Patch->p.dwFlags != 0)
	    nSets++;
    }

    cmsxIT8SetPropertyDbl(it8, "NUMBER_OF_SETS", nSets);

    if (RadioButtonRGB->isChecked())    nFields += 3;
    if (RadioButtonLabXYZ->isChecked()) nFields += 3;

    cmsxIT8SetPropertyDbl(it8, "NUMBER_OF_FIELDS", nFields);

    nFields = 0;

    cmsxIT8SetDataFormat(it8, nFields++, "SAMPLE_ID");

    cmsxIT8SetDataFormat(it8, nFields++, "POS_X");
    cmsxIT8SetDataFormat(it8, nFields++, "POS_Y");

    if (RadioButtonRGB -> isChecked()) {

	cmsxIT8SetDataFormat(it8, nFields++, "RGB_R");
	cmsxIT8SetDataFormat(it8, nFields++, "RGB_G");
	cmsxIT8SetDataFormat(it8, nFields++, "RGB_B");

	cmsxIT8SetDataFormat(it8, nFields++, "STDEV_R");
	cmsxIT8SetDataFormat(it8, nFields++, "STDEV_G");
	cmsxIT8SetDataFormat(it8, nFields++, "STDEV_B");
    }

    if (RadioButtonLab -> isChecked() ||
        RadioButtonLabXYZ -> isChecked()) {

	cmsxIT8SetDataFormat(it8, nFields++, "LAB_L");
	cmsxIT8SetDataFormat(it8, nFields++, "LAB_A");
	cmsxIT8SetDataFormat(it8, nFields++, "LAB_B");
    }

    if (RadioButtonXYZ -> isChecked() ||
        RadioButtonLabXYZ -> isChecked()) {

	cmsxIT8SetDataFormat(it8, nFields++, "XYZ_X");
	cmsxIT8SetDataFormat(it8, nFields++, "XYZ_Y");
	cmsxIT8SetDataFormat(it8, nFields++, "XYZ_Z");
    }

    cmsxIT8SetDataFormat(it8, nFields++, "CHI_SQD_PAR");

    for (Patch = Layout.first(); Patch; Patch = Layout.next())
    {
	if (Patch -> p.dwFlags != 0) {

	    cmsxIT8SetDataSet(it8, Patch->p.Name, "SAMPLE_ID", Patch->p.Name);

	    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "POS_X", Patch->p.pos_x);
	    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "POS_Y", Patch->p.pos_y);

	    if (RadioButtonRGB -> isChecked()) {

		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "RGB_R", Patch ->p.Colorant.RGB[0]);
		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "RGB_G", Patch ->p.Colorant.RGB[1]);
		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "RGB_B", Patch ->p.Colorant.RGB[2]);

		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "STDEV_R", Patch ->p.Stdev.RGB[0]);
		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "STDEV_G", Patch ->p.Stdev.RGB[1]);
		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "STDEV_B", Patch ->p.Stdev.RGB[2]);
	    }

	    if (RadioButtonLab -> isChecked() || RadioButtonLabXYZ -> isChecked()) {

		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "LAB_L", Patch ->p.Lab.L);
		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "LAB_A", Patch ->p.Lab.a);
		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "LAB_B", Patch ->p.Lab.b);
	    }

	    if (RadioButtonXYZ -> isChecked() || RadioButtonLabXYZ -> isChecked()) {

		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "XYZ_X", Patch ->p.XYZ.X * 100.);
		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "XYZ_Y", Patch ->p.XYZ.Y * 100.);
		cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "XYZ_Z", Patch ->p.XYZ.Z * 100.);
	    }

	    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "CHI_SQD_PAR", Patch ->p.ChiSq);
	}
    }

    cmsxIT8SaveToFile(it8, measfile);
    cmsxIT8Free(it8);
}


// ------------------------------------------------------------------------------ Slots

void lprofMain::slotPick()
{

    // qDebug("lprofMain::SlotPick");
    if (TheImage && TheGrid)
    {
        //convert corner marks to unscaled image size
        grid_corners.putPoints (0, 4,
                                (int) (Marks.ul_x * TheImage -> sx), (int) (Marks.ul_y * TheImage -> sy),
                                (int) (Marks.ur_x * TheImage -> sx), (int) (Marks.ur_y * TheImage -> sy),
                                (int) (Marks.lr_x * TheImage -> sx), (int) (Marks.lr_y * TheImage -> sy),
                                (int) (Marks.ll_x * TheImage -> sx), (int) (Marks.ll_y * TheImage -> sy));

        TheGrid -> Pick(InputProfileSelector->getFilename(),
                        TheImage -> image,
                        TheImage -> sx, TheImage -> sy);
        DumpResultsToIT8(TheGrid -> Layout);

        // convert back
        grid_corners.putPoints(0, 4, Marks.ul_x,  Marks.ul_y,
                               Marks.ur_x, Marks.ur_y,
                               Marks.lr_x, Marks.lr_y,
                               Marks.ll_x, Marks.ll_y);
        slotIsAllReady();
    }
}


// end measurement tool stuff


void lprofMain::SetGoButton(QString Caption, BOOL lEnable)
{
    // qDebug("lprofMain::SetGoButton");
    QToolTip::remove( TheGoButton );
    QToolTip::add( TheGoButton, Caption );

    TheGoButton -> setEnabled(TRUE);
    TheGoButton -> setEnabled(lEnable);
    TheGoButton -> repaint();
}

void lprofMain::SetGoButton_2(QString Caption, BOOL lEnable)
{
    // qDebug("lprofMain::SetGoButton");
    QToolTip::remove( TheGoButton_2 );
    QToolTip::add( TheGoButton_2, Caption );

    TheGoButton_2 -> setEnabled(TRUE);
    TheGoButton_2 -> setEnabled(lEnable);
    TheGoButton_2 -> repaint();
}

 void lprofMain::SetOutputFile( const QString OutputFile )
{
     // qDebug("lprofMain::SetOutputFile");
     switch (TabProfiler -> currentPageIndex()) {

        case 0: OutputFileEdit -> setText(OutputFile); break;
        case 1: OutputFileEdit_Mon -> setText(OutputFile); break;

    default:;  // if not on a profiling tab do nothing
    }
}

 void ref_file::get( ref_file &out)
 {
     QDir d;
     QString temp;
     out.items.temp_dir=sys.hdr.template_dir;
     out.items.ref_dir=sys.hdr.ref_dir;
     out.items.home_dir=d.homeDirPath();
 }

 void checkerP::get(checkerP &out)
 {
     // qDebug("checkP::get");

     out.items.ref_dir=(QString) sys.hdr.ref_dir;
     out.items.cur_ref=sys.hdr.cur_ref;
     out.items.profile=(QString) sys.hdr.OutputProfileFile;
     out.items.msheet=(QString) sys.hdr.MeasurementSheet;
     out.items.mon_profile_dir=(QString) sys.hdr.mon_profile_dir;
     out.items.mon_profile_file_name=(QString) sys.hdr.mon_profile_file_name;
 }

 void lprofMain::init_measurement_tool()
{
    // qDebug("lprofMain::init_measurement_tool");
    TheImage        = NULL;
    TheGrid         = NULL;
    CurrentTemplate = "*";
    CurrentSafeFrame = -1;

    int w = CanvasFrame -> width();
    int h = CanvasFrame -> height();
    if (CanvasFrameLayout) delete CanvasFrameLayout;
    CanvasFrameLayout =new QVBoxLayout( CanvasFrame );
    CanvasFrameLayout->setSpacing( 1 );
    CanvasFrameLayout->setMargin( 1 );
    if (Canvas) delete Canvas;
    Canvas = new QCanvas(measure_view_H, measure_view_V);
    Canvas -> setAdvancePeriod(30);
    if (FigEditor) delete FigEditor;
    FigEditor = new FigureEditor(*this, *Canvas, CanvasFrame);
    FigEditor -> clear();
    FigEditor-> resize(w, h);
    FigEditor->setHScrollBarMode(QScrollView::Auto);
    FigEditor->setVScrollBarMode(QScrollView::Auto);

    CanvasFrameLayout->addWidget(FigEditor);

}

#include <qfileinfo.h>

void setupHelp()
{
    bool found = false;
    bool done = false;

    # ifdef __WIN32__
       char pathSep = ';';
       const QString assist = "assistant.exe";
    # else
       char pathSep = ':';
       const QString assist = "assistant";
    # endif /* __WIN32__ */

    QString Path = getenv("PATH");
    QString execpath = (QString) get_QTDIR() + QString("/bin");
    QFileInfo fileinfo;

    while (!done)
    {
        fileinfo.setFile(execpath + "/" + assist);
        if (fileinfo.exists())
        {
            done = true;
            found=true;
        }
        else
        {
           if (Path.length() <=0 || (Path.length() == execpath.length())) done=true;
           else
           {
               execpath = Path.left(Path.find(pathSep));
               Path = Path.right(Path.length() - Path.find(pathSep) - 1);
           }
        }
    }
    QStringList cmdLst;

    if (!found)  // not is QTDIR/bin and not in system PATH
                 // must be Windows.  Look in same location
                 // as lprof.exe
    {
        execpath = QDir::currentDirPath().replace(QDir::currentDirPath().length() - 16, 16, "bin");
        fileinfo.setFile(execpath + "/" + assist);
        if (fileinfo.exists()) found=true;
    }
    if (help) delete help;
    help = new QAssistantClient(execpath);  // so that help calls in other locations don't blow up
    if (found)
    {
       cmdLst << "-showSidebar";
       QString path = QDir::currentDirPath() + "/help";
       // qDebug("path used in the command list = " + path);
       cmdLst << "-profile" << path + QDir::separator() + QString("lprof-help.adp");
       help->setArguments( cmdLst );
    }
    else  // let the user know that help will not work
    {
        QMessageBox mb( QTranslator::tr((QString)"Help system executable not found"),
                        QTranslator::tr((QString)"The QAssistantClient executable was not\n"
                                                 "found.  Make sure that assistant(.exe)is\n"
                                                 "located either in your PATH or in the\n"
                                                 "$QTDIR/bin directory.   Help will not\n"
                                                 "be availble until this is corrected.\n" ),
                        QMessageBox::Critical,
                        QMessageBox::Ok | QMessageBox::Default,
                        QMessageBox::NoButton,  QMessageBox::NoButton);

        mb.exec();
    }
 }

// Main app constructor.

lprofMain::lprofMain( QWidget* parent)
    : lprofMainBase( parent, "", 0, Qt::WStyle_SysMenu | Qt::WStyle_MinMax ),
    FigEditor( 0 ), Canvas( 0 ), CanvasFrameLayout( 0 ), TheGrid( 0 ), TheImage( 0 ),
    CurrentTemplate( "" ), CurrentSafeFrame( 0 ), fn( "" ), settings( 0 )
{
    // qDebug("lprofMain::lprofMain");
    if (targetList) delete targetList;
    targetList = new QPtrList<target_template>;

    Console    =  ProgressConsole;
    Console -> setTextFormat( Qt::LogText);
     // Init the lcmsx engine, this always does success
    cmsxScannerProfilerInit(&sys);
    init_env();
    monitorValues.items.valid_mon=FALSE;

    sys.hdr.cmsprintf = ConsolePrintf;
    sys.hdr.Gauger = Gauger;

    init_mon();

    // Hide Printer_Tab until printer profiling is available
    TabProfiler->removePage(Printer_Tab);
    // Hidden tab is used for items that are no longer visible to users
    TabProfiler->removePage(Hidden);

    init_measurement_tool();
    LoadConfig();

    if (dsizes.lprofH > 0 && dsizes.lprofW > 0)
        this -> resize(dsizes.lprofW, dsizes.lprofH);

    // init_targetlist();
    last_tab=0;
    setupHelp();
}

lprofMain::~lprofMain(void)
{
    // qDebug("lprofMain::~lprofMain");
    SaveConfig();
    delete help;
    help = 0;
    delete CanvasFrameLayout;
    CanvasFrameLayout = 0;
    delete Canvas;
    Canvas = 0;
//     help-> ~QAssistantClient();
//     CanvasFrameLayout -> ~QVBoxLayout();
//     Canvas -> ~QCanvas();
}


void lprofMain::ControlsToValues()
{
    // qDebug("lprofMain::ControlsToValues");
    QString cTarget = TargetSelector -> getFilename();

    if (cTarget != QString::null)
            strcpy(sys.hdr.ReferenceSheet, cTarget.local8Bit());

    strcpy(sys.hdr.MeasurementSheet,  measfile);
    strcpy(sys.hdr.MonMeasurementSheet, (const char*)MonMeasurementSheet->getFilename().local8Bit());

    strcpy(sys.hdr.OutputProfileFile, (const char*) OutputFileEdit -> text().local8Bit());
    strcpy(sys.hdr.MonOutputProfileFile, (const char*) OutputFileEdit_Mon -> text().local8Bit());
    strcpy(sys.hdr.ref_dir, (const char*)TargetSelector->Dir.local8Bit());
    sys.hdr.cur_ref=TargetSelector->getCurrItem();
    strcpy(sys.hdr.template_dir,SelectTemplate->Dir.local8Bit());
    strcpy(sys.hdr.mon_profile_dir, (const char*) MonitorProfileSelector->Dir.local8Bit());
    strcpy(sys.hdr.mon_profile_file_name, (const char*)MonitorProfileSelector->getFilename().local8Bit());
}

// ------------------------------------------------------------------- Results

void lprofMain::DoScannerProfile()
{
    // qDebug("lprofMain::DoScannerProfile");
    SetGoButton(tr(QString("Profiling... please wait")), FALSE);
    /* TRANSLATOR Text displayed in the messages widget */
    ConsolePrintf("Working hard...", 0, 'c');
    sys.hdr.DeviceClass = icSigInputClass;
    sys.hdr.ColorSpace  = icSigRgbData;
    sys.hdr.PCSType     = PT_Lab;
    sys.hdr.Medium      = MEDIUM_REFLECTIVE_D50;

    QString cTarget = TargetSelector -> getFilename();

    if (cTarget != QString::null)
            strcpy(sys.hdr.ReferenceSheet, cTarget.local8Bit());
    strcpy(sys.hdr.MeasurementSheet, measfile);
     // qDebug("about to call cmsxScannerProfilerDo");

     if (!cmsxScannerProfilerDo(&sys))
    {
        /* TRANSLATOR Text displayed in the messages widget */
         ConsolePrintf("** ERROR: Unable to profile.", 0, 'c');
	 // qDebug("done failed");
        return;
    }
    else  // it worked finish up
     {
        Gauger("Init...", 0, 100, 100);
        /* TRANSLATOR Text displayed in the messages widget */
        ConsolePrintf("Profile '%1' DONE!", 1, 's', sys.hdr.OutputProfileFile);
    }

    SetGoButton(tr(QString("Ready to GO!")), TRUE);
}

void lprofMain::DoMonitorProfile()
{

    // qDebug("lprofMain::DoMonitorProfile");
    OutputFileNameChangedMon();

    SetGoButton(tr(QString("Profiling... please wait")), FALSE);
    /* TRANSLATOR Text displayed in the messages widget */
    ConsolePrintf("Working hard...", 0, 'c');
    sys.hdr.DeviceClass = icSigDisplayClass;
    sys.hdr.ColorSpace  = icSigRgbData;
    sys.hdr.PCSType     = PT_Lab;
    sys.hdr.Medium      = MEDIUM_TRANSMISSIVE;
   //  extrap = sys.lLocalConvergenceExtrapolation;
    // sys.lLocalConvergenceExtrapolation = FALSE;
    strcpy(sys.hdr.ReferenceSheet, "");
    if (RadioCoarse->isChecked())
        strcpy(sys.hdr.MonMeasurementSheet, "");
    else
        strcpy(sys.hdr.MonMeasurementSheet, MonMeasurementSheet->getFilename().local8Bit());
    if (!cmsxMonitorProfilerDo(&sys))
    {
        /* TRANSLATOR Text displayed in the messages widget */
        ConsolePrintf("** ERROR: Unable to profile.", 0, 'c');
        return;  // it failed
    }
    else
    {  // it worked finish up
        Gauger("Init...", 0, 100, 100);
        /* TRANSLATOR Text displayed in the messages widget */
        ConsolePrintf("Profile '%1' DONE!", 1, 's', sys.hdr.MonOutputProfileFile);
    }

    SetGoButton(tr(QString("Ready to GO!")), TRUE);
 //   sys.lLocalConvergenceExtrapolation = extrap;
}

// --------------------------------------------------------------------- Slots


void lprofMain::tabChanged()
{
    // qDebug("tabChanged");
    setData(last_tab);

     last_tab = TabProfiler -> currentPageIndex();
     // profile parms
    sys.hdr.CLUTPoints = data[last_tab].CLUTPoints;
    sys.hdr.ProfileVerbosityLevel = data[last_tab].ProfileVerbosityLevel;
    sys.RsplSmoothness = data[last_tab].RsplSmoothness;
    sys.AvgDev = data[last_tab].AvgDev;
    sys.hdr.lUseCIECAM97s = data[last_tab].lUseCIECAM97s;
    sys.hdr.device.surround = data[last_tab].device.surround;
    sys.hdr.device.La = data[last_tab].device.La;
    sys.hdr.device.Yb = data[last_tab].device.Yb;

    // profile ID information
    strcpy(sys.hdr.Manufacturer, data[last_tab].Manufacturer);
    strcpy(sys.hdr.Model, data[last_tab].Model);
    strcpy(sys.hdr.Copyright, data[last_tab].Copyright);
    strcpy(sys.hdr.Description, data[last_tab].Description);

    ControlsToValues();
    setProfileIDText();
    setProfileParmsText();
    slotIsAllReady();
}

void lprofMain::getConfigParmsandID(QString profile)
{
    // qDebug("lprofMain::getConfigParmsandID");
         sys.hdr.CLUTPoints = settings->readNumEntry("/LPROF/profile-"  + profile + "/numbers/CLUT_POINTS", 10);
         sys.hdr.ProfileVerbosityLevel = settings->readNumEntry("/LPROF/profile-"  + profile + "/numbers/PROFILE_VERBOSITY_LEVEL", 0);
         sys.RsplSmoothness = settings->readDoubleEntry("/LPROF/profile-"  + profile + "/numbers/RsplSmoothness", 1.0);
         sys.AvgDev = settings->readDoubleEntry("/LPROF/profile-"  + profile + "/numbers/AvgDev", 0.007);
         sys.hdr.lUseCIECAM97s = settings->readBoolEntry("/LPROF/profile-"  + profile + "/boolians/lUseCIECAM97s", false);
         sys.hdr.device.surround = settings->readNumEntry("/LPROF/profile-"  + profile + "/numbers/surround", 0);
         sys.hdr.device.La = settings->readDoubleEntry("/LPROF/profile-"  + profile + "/numbers/La", 20);
         sys.hdr.device.Yb = settings->readDoubleEntry("/LPROF/profile-"  + profile + "/numbers/Yb", 20);

         // profile ID information
         strcpy(sys.hdr.Manufacturer, settings->readEntry("LPROF/profile-"  + profile + "/text/manufacturer", sys.hdr.Manufacturer));
         strcpy(sys.hdr.Model, settings->readEntry("LPROF/profile-"  + profile + "/text/model", sys.hdr.Model));
         strcpy(sys.hdr.Copyright, settings->readEntry("LPROF/profile-"  + profile + "/text/copyright", sys.hdr.Copyright));
         strcpy(sys.hdr.Description, settings->readEntry("LPROF/profile-"  + profile + "/text/description", sys.hdr.Description));

}



void lprofMain::OutputFileNameChangedMon()
{
    QString temp, profile;
    bool ok;

    // qDebug("OutputFileNameChangedMon");
    profile =  OutputFileEdit_Mon -> text().mid(OutputFileEdit_Mon -> text().findRev('/') + 1,
                                                                            OutputFileEdit_Mon -> text().length() - OutputFileEdit_Mon -> text().findRev('/') - 1);
    temp = settings->readEntry("/LPROF/profile-"  + profile + "/Files/MON_OUTPUT_PROFILE", QString::null, &ok);
    if (ok)  // found entry in lprof settings
    {

        getConfigParmsandID(profile);

         ok = settings->readBoolEntry("/LPROF/profile-" +  profile + "/boolians/Course");
         RadioCoarse->setChecked(ok);
         RadioAccurate->setChecked(!ok);

         if (!ok)
         {
               MonMeasurementSheet -> setFilename( settings->readEntry("/LPROF/profile-" + profile + "/Files/MEASUREMENT_SHEET"));
         }
        else
        {
             monitorValues.items.wppos = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/whitePpos");
             monitorValues.items.ppos = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/primePos");

             monitorValues.items.rgamma = settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/rgamma");
             monitorValues.items.ggamma = settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/ggamma" );
             monitorValues.items.bgamma = settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/bgamma");

             sys.hdr.Primaries.Red.x = settings->readDoubleEntry("/LPROF/profile-"  + profile + "/numbers/red_x");
             sys.hdr.Primaries.Red.y = settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/red_y");
             sys.hdr.Primaries.Green.x = settings->readDoubleEntry("/LPROF/profile-" +profile + "/numbers/green_x");
             sys.hdr.Primaries.Green.y = settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/green_y");
             sys.hdr.Primaries.Blue.x = settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/blue_x");
             sys.hdr.Primaries.Blue.y = settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/blue_y");

             monitorValues.items.temp = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/whitePoint");
             monitorValues.items.valid_mon = true;
             monitorValues.items.linked = settings->readBoolEntry("/LPROF/profile-" +  profile + "/boolians/linked");

             if (sys.Prelinearization[0]) cmsFreeGamma(sys.Prelinearization[0]);
             if (sys.Prelinearization[1]) cmsFreeGamma(sys.Prelinearization[1]);
             if (sys.Prelinearization[2]) cmsFreeGamma(sys.Prelinearization[2]);

             sys.Prelinearization[0] = cmsBuildGamma(256, settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/rgamma"));
             sys.Prelinearization[1] = cmsBuildGamma(256, settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/ggamma" ));
             sys.Prelinearization[2] = cmsBuildGamma(256, settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/bgamma"));
          }
         setData(1);

         ControlsToValues();
         setProfileIDText();
         setProfileParmsText();
         }

    slotIsAllReady();
}

void lprofMain::OutputFileNameChanged()
{
    QString temp, profile, template_file, target;
    bool ok;

    // qDebug("lprofMain::OutputFileNameChanged");
    profile =  OutputFileEdit -> text().mid(OutputFileEdit -> text().findRev('/') + 1,
                                                                  OutputFileEdit -> text().length() - OutputFileEdit -> text().findRev('/') - 1);
    temp = settings->readEntry("/LPROF/profile-"  + profile + "/Files/OUTPUT_PROFILE", QString::null, &ok);
    if (ok)  // found entry in lprof settings
    {
        fn = settings->readEntry("/LPROF/profile-" + profile + "/Files/IT8Image");
        target = settings->readEntry( "/LPROF/profile-" + profile + "/numbers/TARGET_Filename");

        if (!targetList->isEmpty())
        for (uint i=0; i<=targetList->count()-1; i++)
        {
             if (targetList->at(i)->targetFile == target)
             {
                 SelectTemplate->setCurrItem(targetList->at(i)->tempPos);
                 TargetSelector->setCurrItem(targetList->at(i)->targPos);
             }
        }
        getConfigParmsandID(profile);

        ControlsToValues();
        setProfileIDText();
        setProfileParmsText();

        setData(0);

        FigEditor->clear();
        if (QFile::exists(fn))  // only if image exists
        {
            Marks.ur_x = settings->readNumEntry("/LPROF/profile-"  +  profile + "/numbers/ur_x");
            Marks.ur_y = settings->readNumEntry("/LPROF/profile-"  + profile + "/numbers/ur_y");
            Marks.lr_x = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/lr_x");
            Marks.lr_y = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/lr_y");
            Marks.ul_x = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/ul_x");
            Marks.ul_y = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/ul_y");
            Marks.ll_x = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/ll_x");
            Marks.ll_y = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/ll_y");

            TheGrid = NULL;
            CurrentTemplate = "";
            // fix me ?? what does ProofTogle do ???
            if (ProofToggle -> isOn()) ProofToggle -> toggle();
            TheImage = new ImageItem(fn, MonitorProfileSelector ->getFilename(),
                                                InputProfileSelector->getFilename(),
                                               Canvas);
            // open the image file
            Reload();
            // place corner markers and pick

           grid_corners.putPoints(0, 4, Marks.ul_x,  Marks.ul_y,
                                                       Marks.ur_x, Marks.ur_y,
                                                       Marks.lr_x, Marks.lr_y,
                                                       Marks.ll_x, Marks.ll_y);
           AddTemplate();
           // check to see if all corners are marked and it is time to place full template and pick

           corners_ready=TRUE;
           slotPick();
           }
       }
    slotIsAllReady();
}

void lprofMain::slotSelectOutputFile()
{
    // qDebug("lprofMain::slotSelectOutputFile");

    QString fn = QFileDialog::getSaveFileName( outprofile,
                                               tr(QString("icc profiles (*.icc *.icm)\nAll files (*.*)")),
                                                this,
                                                "",
                                                tr(QString("Select output profile filename")));
    if (fn != QString::null)
        SetOutputFile(fn);
    /* TRANSLATOR Text displayed in the messages widget */
    ConsolePrintf("select file name", 0, 'c');
    slotIsAllReady();
}

void lprofMain::slotIsAllReady()
{
    // qDebug("lprofMain::slotIsAllReady");
    // check what type of profile is currently being worked on
    // and decide if the GoButton should be enabled
    switch (TabProfiler -> currentPageIndex()) {

        case 0:
                if (TargetSelector -> getFilename() == QString::null)
                    SetGoButton(tr(QString("You still have to select the target reference file")), FALSE);
                else if (OutputFileEdit -> text() == "")
                    SetGoButton(tr(QString("You need to specify output profile!")), FALSE);
                else
                {
                    // OutputFileNameChanged();
                    if (!(Marks.ul_x>0 && Marks.ur_x>0 && Marks.ll_x>0 && Marks.lr_x>0))
                        SetGoButton(tr(QString("You need to load a target image and select it's corners!")), FALSE);
                    else
                        SetGoButton(tr(QString("Ready to GO!")), TRUE);
                }
                break;
        case 1:
                if (OutputFileEdit_Mon -> text().length() == 0)
                    SetGoButton_2(tr(QString("You need to specify output profile!")), FALSE);
                else
                {
                    // OutputFileNameChanged();
                    if (RadioCoarse->isChecked())
                    {
                       if (monitorValues.items.valid_mon)
                           SetGoButton_2(tr(QString("Ready to GO!")), TRUE);
                       else
                           SetGoButton_2(tr(QString("You need to enter monitor values.")), FALSE);
                    }
                    else if (MonMeasurementSheet->getFilename()=="")
                        SetGoButton_2(tr(QString("You need to specify a measurement sheet!")), FALSE);
                    else
                        SetGoButton_2(tr(QString("Ready to GO!")), TRUE);
                }
                break;

    default:; // if not on a profileing tab then do nothing

    }
}


void lprofMain::Go_button_clicked()
{
   // qDebug("lprofMain::Go_button_clicked");

   switch (TabProfiler -> currentPageIndex()) {

        case 0:
            ProgBar = ProgressBar;
            Gauger("Init...", 0, 100, 0);
            ControlsToValues();
            saveProfileDetails();
            DoScannerProfile(); break;
        case 1:
            ProgBar = ProgressBar_2;
            Gauger("Init...", 0, 100, 0);
            ControlsToValues();
            saveProfileDetails();
            DoMonitorProfile(); break;

    default:;  // if not on a profiling tab do nothing
    }
}


void lprofMain::slotTargetChanged()
{
    // qDebug("lprofMain::slotTargetChanged");
    // DescriptorText -> setText("");

    QString TargetFile = TargetSelector -> getFilename();

    if (TargetFile == QString::null) return;

    LCMSHANDLE hIT8 = cmsxIT8LoadFromFile(TargetFile.local8Bit());
    if (hIT8 == NULL) return;

     cmsxIT8Free(hIT8);
     slotIsAllReady();

}

BOOL lprofMain::LoadConfig()
{
    QString temp;
    target_template hold;

    // qDebug("lprofMain::LoadConfig");
    if (settings) delete settings;
    settings = new QSettings();
    settings->setPath( "lprof.sourceforge.net", "lprof", QSettings::User);
    settings->insertSearchPath( QSettings::Unix, QDir::homeDirPath() + "/.lprof/config" );

    SelectTemplate->Dir = settings->readEntry("/LPROF/Files/TEMPLATE_DIR", "");

    // QString temp1 = SelectTemplate->Dir;
    if (SelectTemplate->Dir.length() > 0)
    {
        SelectTemplate->setCurrItem(0);

        MonitorProfileSelector ->Dir = settings->readEntry( "/LPROF/Files/MONITOR_PROFILES_DIR", "");
        MonitorProfileSelector ->RestrictColorspace = icSigRgbData;
        MonitorProfileSelector ->RestrictClass = icSigDisplayClass;
        MonitorProfileSelector -> FillValues();
        MonitorProfileSelector ->setFilename(settings->readEntry( "/LPROF/Files/MONITOR_PROFILE", ""));

        InputProfileSelector->Dir = (settings->readEntry( "/LPROF/Files/INPUT_PROFILES_DIR", ""));
        InputProfileSelector-> RestrictColorspace = icSigRgbData;
        InputProfileSelector->FillValues();
        InputProfileSelector->setFilename(settings->readEntry( "/LPROF/Files/INPUT_PROFILE", ""));

        SafeFrame -> setValue(settings->readNumEntry( "/LPROF/numbers/SAFE_FRAME", 0));

        TargetSelector->Dir = settings->readEntry("/LPROF/Files/TARGET_DIR", "");
        TargetSelector->setCurrItem(0);

        targetList->clear();
        const int n=settings->readNumEntry( "/LPROF/numbers/NUMBER_TARGETS", 0);
        for (int i=0; i < n; i++)
        {
            // file target to template list with information
            temp.sprintf("/LPROF/Files/TARGET%i", i);
            hold.targetFile=settings->readEntry(temp, "");
            temp.sprintf("/LPROF/Files/TEMPLATE%i", i);
            hold.templateFile=settings->readEntry(temp, "" );
            // qDebug(temp.sprintf("add target in loadconfig. i = %i", i));
            add_target(hold);
        }

        if ((uint)TargetSelector->count() > targetList->count())
        {
            // we know that at least one target has been added since the last time the
            // the config file was saved.  So we must up date the targetList->
           // This should never happen since it is an indication that the program crashed
           // the last time it was run or the user manually copied a reference file to the
           // hidden configuration directory
            qDebug("Target not in targetList");
        }

        init_targetlist();
        slotTargetRefChanged();
        OutputFileEdit_Mon -> setText(settings->readEntry("/LPROF/Files/MON_OUTPUT_PROFILE", ""));
        OutputFileEdit -> setText(settings->readEntry("/LPROF/Files/OUTPUT_PROFILE", ""));

        dsizes.reffileH = settings -> readNumEntry("/LPROF/numbers/refFile_h",0);
        if (dsizes.reffileH == 0)
        {
            QWidget *d = QApplication::desktop();
            if (d -> height() <= 768)
            {
                dsizes.reffileH = 145;
                dsizes.reffileW = 395;
                dsizes.profparmsH = 335;
                dsizes.profparmsW = 475;
                dsizes.profidH = 307;
                dsizes.profidW = 372;
                dsizes.profchH = 440;
                dsizes.profchW = 622;
                dsizes.monvalH = 251;
                dsizes.monvalW = 520;
                dsizes.lprofH = 512;
                dsizes.lprofW = 792;
            }
            else if (d -> height() <= 1024 && d -> height() > 768)
            {
                dsizes.reffileH = 155;
                dsizes.reffileW = 456;
                dsizes.profparmsH = 385;
                dsizes.profparmsW = 585;
                dsizes.profidH = 424;
                dsizes.profidW = 462;
                dsizes.profchH = 500;
                dsizes.profchW = 750;
                dsizes.monvalH = 280;
                dsizes.monvalW = 607;
                dsizes.lprofH = 595;
                dsizes.lprofW = 924;
            }
        }
        else
        {
            dsizes.reffileW = settings -> readNumEntry("/LPROF/numbers/refFile_w",0);
            dsizes.profparmsH = settings -> readNumEntry("/LPROF/numbers/profparms_h",0);
            dsizes.profparmsW = settings -> readNumEntry("/LPROF/numbers/profparms_w",0);
            dsizes.profidH = settings -> readNumEntry("/LPROF/numbers/profid_h",0);
            dsizes.profidW = settings -> readNumEntry("/LPROF/numbers/profid_w",0);
            dsizes.profchH = settings -> readNumEntry("/LPROF/numbers/profch_h",0);
            dsizes.profchW = settings -> readNumEntry("/LPROF/numbers/profch_w",0);
            dsizes.monvalH = settings -> readNumEntry("/LPROF/numbers/monval_h",0);
            dsizes.monvalW = settings -> readNumEntry("/LPROF/numbers/monval_w",0);
            dsizes.lprofH = settings -> readNumEntry("/LPROF/numbers/lprof_h",0);
            dsizes.lprofW = settings -> readNumEntry("/LPROF/numbers/lprof_w",0);
        }


        return TRUE;
    }
          //  means no config file found this is first time app has been run
          // config file will be created when program is closed
         // Set everything to default values

    SafeFrame -> setValue(60);
    SelectTemplate -> Dir = templates;
    SelectTemplate->FillValues();
    SelectTemplate->setCurrItem(0);
    TargetSelector->Dir = ref_dir;
    TargetSelector->FillValues();
    TargetSelector->setCurrItem(0);
    MonitorProfileSelector ->Dir = mon_profile;
    MonitorProfileSelector ->FillValues();
    InputProfileSelector ->Dir = in_profile;
    InputProfileSelector->FillValues();

    QWidget *d = QApplication::desktop();
    if (d -> height() <= 768)
    {
        dsizes.reffileH = 145;
        dsizes.reffileW = 395;
        dsizes.profparmsH = 335;
        dsizes.profparmsW = 475;
        dsizes.profidH = 307;
        dsizes.profidW = 372;
        dsizes.profchH = 440;
        dsizes.profchW = 622;
        dsizes.monvalH = 251;
        dsizes.monvalW = 520;
        dsizes.lprofH = 512;
        dsizes.lprofW = 792;
    }
    else if (d -> height() <= 1024 && d -> height() > 768)
    {
        dsizes.reffileH = 155;
        dsizes.reffileW = 456;
        dsizes.profparmsH = 385;
        dsizes.profparmsW = 585;
        dsizes.profidH = 424;
        dsizes.profidW = 462;
        dsizes.profchH = 500;
        dsizes.profchW = 750;
        dsizes.monvalH = 280;
        dsizes.monvalW = 607;
        dsizes.lprofH = 595;
        dsizes.lprofW = 924;
    }
    return FALSE;

}


void lprofMain::setProfileParmsText()
{
    QString Buff;
    const QString
       res = lprofMain::tr("Resolution (CLUT points)"),
       verb1 = lprofMain::tr("Profile verbosity: Only required tags"),
       verb2 = lprofMain::tr("Profile verbosity: Store additional tags"),
       verb3 = lprofMain::tr("Profile verbosity: Store anything"),
       reg = lprofMain::tr("Regression:"),
       sm = lprofMain::tr("Smoothness:"),
       dev = lprofMain::tr("Deviation:"),
       av4 = lprofMain::tr("     Average surround (>4)"),
       av = lprofMain::tr("     Average surround"),
       dim = lprofMain::tr("     Dim surround"),
       dark = lprofMain::tr("     Dark surround"),
       cut = lprofMain::tr("     Cutsheet surround"),
       lb = lprofMain::tr("Linear Bradford ");


    // qDebug("lprofMain::setProfileParmsText");
       Buff.sprintf(":  %i", sys.hdr.CLUTPoints );
    // Buff.sprintf(Buff, sys.hdr.CLUTPoints );
       textEditProfileParms->setText(tr(QString("Resolution (CLUT points)")) + Buff);

    switch (sys.hdr.ProfileVerbosityLevel)
    {
    case 0:
        textEditProfileParms->insertParagraph(tr(QString("Profile verbosity: Only required tags")), 3);
        break;
    case 1:
        textEditProfileParms->insertParagraph(tr(QString("Profile verbosity: Store additional tags")), 3);
        break;
    case 2:
        textEditProfileParms->insertParagraph(tr(QString("Profile verbosity: Store anything")), 3);
        break;
    }

    textEditProfileParms->insertParagraph(tr(QString("Regression:")), 5);

    Buff = QString("    ") + tr(QString("Smoothness:")) + Buff.sprintf(QString(" %#3.3g") ,sys.RsplSmoothness);
    textEditProfileParms->insertParagraph(Buff, 6);
    Buff = QString("    ") + tr(QString("Deviation:")) + Buff.sprintf(QString(" %#4.3g"),sys.AvgDev);
    textEditProfileParms->insertParagraph(Buff, 7);

    if (sys.hdr.lUseCIECAM97s)
    {
        textEditProfileParms->insertParagraph(tr("CIECAM97s: "), 8);

	 switch (sys.hdr.device.surround)
	 {
	 case 0:
             textEditProfileParms->insertParagraph(tr(QString("     Average surround (>4)")),9);
	     break;
	 case 1:
             textEditProfileParms->insertParagraph(tr(QString("     Average surround")), 9);
	     break;
	 case 2:
             textEditProfileParms->insertParagraph(tr(QString("     Dim surround")), 9);
	     break;
	 case 3:
             textEditProfileParms->insertParagraph(tr(QString("     Dark surround")), 9);
	     break;
	 case 4:
             textEditProfileParms->insertParagraph(tr(QString("     Cutsheet surround")), 9);
	     break;
	 default:
             textEditProfileParms->insertParagraph(tr(QString("     Average surround (>4)")), 9);
         }
         Buff = tr("     La:") +  Buff.sprintf(" %g", sys.hdr.device.La);
	 textEditProfileParms->insertParagraph(Buff, 10);
         Buff = tr("     Yb:") +  Buff.sprintf(" %g", sys.hdr.device.Yb);
	 textEditProfileParms->insertParagraph(Buff, 10);

     }
     else textEditProfileParms->insertParagraph(tr(QString("Linear Bradford ")), 8);

}


QUrlOperator urlOp;

void lprofMain::saveProfileDetails()
{
    QString slash;
    bool cs_profile = true;
    QDir d;
    QString copy, profile;

    // qDebug("lprofMain::saveProfileDetails");

    if (TabProfiler -> currentPageIndex()== 0)
    {
         profile = OutputFileEdit -> text().mid(OutputFileEdit -> text().findRev('/') + 1,
                                                OutputFileEdit -> text().length() - OutputFileEdit -> text().findRev('/') - 1);
         settings->writeEntry("/LPROF/profile-" + profile + "/Files/OUTPUT_PROFILE", OutputFileEdit -> text());

         urlOp.copy(measfile, dir.homeDirPath() +
                 QString("/.lprof/measurements/") + profile + QString(".cgt"), false, false);

         settings->writeEntry("/LPROF/profile-" + profile + "/Files/MEASUREMENT_SHEET",  profile + ".cgt");
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ur_x", Marks.ur_x);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ur_y", Marks.ur_y);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/lr_x", Marks.lr_x);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/lr_y", Marks.lr_y);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ul_x", Marks.ul_x);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ul_y", Marks.ul_y);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ll_x", Marks.ll_x);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ll_y", Marks.ll_y);
         settings->writeEntry("/LPROF/profile-" + profile + "/Files/IT8Image", image_file_name);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/RsplSmoothness", sys.RsplSmoothness);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/AvgDev", sys.AvgDev);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/CLUT_POINTS", (int) sys.hdr.CLUTPoints);
         settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/PROFILE_VERBOSITY_LEVEL", (int) sys.hdr.ProfileVerbosityLevel);

        settings->writeEntry( "/LPROF/profile-" + profile + "/numbers/TEMPLATE_NUM", SelectTemplate->getCurrItem() );
        settings->writeEntry( "/LPROF/profile-" + profile + "/numbers/TARGET_NUM", TargetSelector->getCurrItem());
        settings->writeEntry( "/LPROF/profile-" + profile + "/numbers/TEMPLATE_Filename", SelectTemplate->getFilename() );
        settings->writeEntry( "/LPROF/profile-" + profile + "/numbers/TARGET_Filename", TargetSelector->getFilename());

        settings->writeEntry("/LPROF/profile-"  + profile + "/boolians/lUseCIECAM97s", sys.hdr.lUseCIECAM97s);
        settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/surround", sys.hdr.device.surround);
        settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/La", sys.hdr.device.La);
        settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/Yb", sys.hdr.device.Yb);

        // profile ID
        settings->writeEntry("/LPROF/profile-" +  profile + "/text/manufacturer", sys.hdr.Manufacturer);
        settings->writeEntry("/LPROF/profile-" +  profile + "/text/model", sys.hdr.Model);
        settings->writeEntry("/LPROF/profile-" + profile + "/text/copyright", sys.hdr.Copyright);
        settings->writeEntry("/LPROF/profile-" + profile + "/text/description", sys.hdr.Description);

    }
    else if (TabProfiler -> currentPageIndex()== 1)
    {
        profile = OutputFileEdit_Mon -> text().mid(OutputFileEdit_Mon -> text().findRev('/') + 1,
                                                                               OutputFileEdit_Mon -> text().length() - OutputFileEdit_Mon -> text().findRev('/') - 1);
        cs_profile = false;
        settings->writeEntry("/LPROF/profile-"    +
                             (QString) profile +
                             "/Files/MON_OUTPUT_PROFILE",
                             OutputFileEdit_Mon -> text());
       if (!RadioCoarse->isChecked())
       {
           QString meas_file =  dir.homeDirPath() + QString("/.lprof/measurements/") + (QString) profile + QString(".cgt");

           urlOp.copy(MonMeasurementSheet->getFilename(), meas_file, false, false);

          settings->writeEntry("/LPROF/profile-"  + profile + "/Files/MEASUREMENT_SHEET",  meas_file);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/SAFE_FRAME", (int) SafeFrame->value());
          settings->writeEntry("/LPROF/profile-"  + profile + "/boolians/Course", false);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/CLUT_POINTS", (int) sys.hdr.CLUTPoints);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/PROFILE_VERBOSITY_LEVEL", (int) sys.hdr.ProfileVerbosityLevel);

          settings->writeEntry("/LPROF/profile-"  + profile + "/boolians/lUseCIECAM97s", sys.hdr.lUseCIECAM97s);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/surround", sys.hdr.device.surround);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/La", sys.hdr.device.La);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/Yb", sys.hdr.device.Yb);

          // profile ID
         settings->writeEntry("/LPROF/profile-" + profile + "/text/manufacturer", sys.hdr.Manufacturer);
         settings->writeEntry("/LPROF/profile-" + profile + "/text/model", sys.hdr.Model);
         settings->writeEntry("/LPROF/profile-" + profile + "/text/copyright", sys.hdr.Copyright);
         settings->writeEntry("/LPROF/profile-" + profile + "/text/description", sys.hdr.Description);


       }
       else
       {
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/whitePpos", monitorValues.items.wppos);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/primePos", monitorValues.items.ppos);

          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/rgamma", monitorValues.items.rgamma);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/ggamma", monitorValues.items.ggamma);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/bgamma", monitorValues.items.bgamma);

          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/red_x", sys.hdr.Primaries.Red.x);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/red_y", sys.hdr.Primaries.Red.y);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/green_x", sys.hdr.Primaries.Green.x);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/green_y", sys.hdr.Primaries.Green.y);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/blue_x", sys.hdr.Primaries.Blue.x);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/blue_y", sys.hdr.Primaries.Blue.y);

          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/whitePoint", monitorValues.items.temp);
          settings->writeEntry("/LPROF/profile-"  + profile + "/boolians/Course", true);
          settings->writeEntry("/LPROF/profile-" +  profile + "/boolians/linked", monitorValues.items.linked);

          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/CLUT_POINTS", (int) sys.hdr.CLUTPoints);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/PROFILE_VERBOSITY_LEVEL", (int) sys.hdr.ProfileVerbosityLevel);

          settings->writeEntry("/LPROF/profile-"  + profile + "/boolians/lUseCIECAM97s", sys.hdr.lUseCIECAM97s);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/surround", sys.hdr.device.surround);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/La", sys.hdr.device.La);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/Yb", sys.hdr.device.Yb);

          // profile ID
          settings->writeEntry("/LPROF/profile-" + profile + "/text/manufacturer", sys.hdr.Manufacturer);
          settings->writeEntry("/LPROF/profile-" + profile + "/text/model", sys.hdr.Model);
          settings->writeEntry("/LPROF/profile-" + profile + "/text/copyright", sys.hdr.Copyright);
          settings->writeEntry("/LPROF/profile-" + profile + "/text/description", sys.hdr.Description);
       }
    }
    else qDebug("Something wrong");  // will be needed later for printer profiler tab
}


void lprofMain::setProfileIDText()
{
    // qDebug("lprofMain::setProfileIDText");
    textEditProfileID->setText( tr("Model: "));
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert( sys.hdr.Model);
    textEditProfileID->insertParagraph(tr("Manufacturer: "), 3);
    textEditProfileID->moveCursor(QTextEdit::MoveDown, 0);
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert(sys.hdr.Manufacturer);
    textEditProfileID->insertParagraph(tr("Description: "), 5);
    textEditProfileID->moveCursor(QTextEdit::MoveDown, 0);
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert(sys.hdr.Description);
    textEditProfileID->insertParagraph(tr("Copyright: "), 7);
    textEditProfileID->moveCursor(QTextEdit::MoveDown, 0);
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert(sys.hdr.Copyright);
}

void lprofMain::SaveConfig()
{
    QString temp;
    // qDebug("lprofMain::SaveConfig");

    settings->writeEntry("/LPROF/Files/TARGET_DIR", TargetSelector->Dir);
   // settings->writeEntry("/LPROF/numbers/TARGET_NUM", (int)TargetSelector->getCurrItem());
    settings->writeEntry("/LPROF/numbers/NUMBER_TARGETS", (int) targetList->count());
    if (!targetList->isEmpty())
        for (uint i=0; i<=targetList->count()-1; i++)
        {
            // add target to template information
            temp.sprintf("/LPROF/Files/TARGET%i", i);
            settings->writeEntry(temp, targetList->at(i)->targetFile);
            temp.sprintf("/LPROF/Files/TEMPLATE%i", i);
            settings->writeEntry(temp, targetList->at(i)->templateFile);
        }

    settings->writeEntry("/LPROF/Files/OUTPUT_PROFILE", OutputFileEdit -> text());
    settings->writeEntry("/LPROF/Files/MON_OUTPUT_PROFILE",  OutputFileEdit_Mon ->text());
    settings->writeEntry("/LPROF/Files/TEMPLATE_DIR", SelectTemplate->Dir);
    // settings->writeEntry("/LPROF/numbers/TEMPLATE_NUM", (int) SelectTemplate->getCurrItem());
    settings->writeEntry("/LPROF/Files/MONITOR_PROFILES_DIR", MonitorProfileSelector->Dir);
    settings->writeEntry("/LPROF/Files/MONITOR_PROFILE", MonitorProfileSelector->getFilename());
    settings->writeEntry("/LPROF/Files/INPUT_PROFILES_DIR", InputProfileSelector->Dir);
    settings->writeEntry("/LPROF/Files/INPUT_PROFILE", InputProfileSelector->getFilename());
    settings->writeEntry("/LPROF/numbers/SAFE_FRAME", (int) SafeFrame->value());
    settings -> writeEntry("/LPROF/numbers/lprof_h", this -> height());
    settings -> writeEntry("/LPROF/numbers/lprof_w", this -> width());
    settings -> writeEntry("/LPROF/numbers/refFile_h",dsizes.reffileH);
    settings -> writeEntry("/LPROF/numbers/refFile_w",dsizes.reffileW);
    settings -> writeEntry("/LPROF/numbers/monval_h",dsizes.monvalH);
    settings -> writeEntry("/LPROF/numbers/monval_w",dsizes.monvalW);
    settings -> writeEntry("/LPROF/numbers/profparms_h",dsizes.profparmsH);
    settings -> writeEntry("/LPROF/numbers/profparms_w",dsizes.profparmsW);
    settings -> writeEntry("/LPROF/numbers/profid_h",dsizes.profidH);
    settings -> writeEntry("/LPROF/numbers/profid_w",dsizes.profidW);
    settings -> writeEntry("/LPROF/numbers/profch_h",dsizes.profchH);
    settings -> writeEntry("/LPROF/numbers/profch_w",dsizes.profchW);

//     settings->~QSettings();
    delete settings;
    settings = 0;
//     targetList -> ~QPtrList();
    delete targetList;
    targetList = 0;
}

void lprofMain::slotChangeStrategy()
{
    // qDebug("lprofMain::setProfileIDText");
    NoHardwareLabel->setEnabled(RadioCoarse->isChecked());
    MeasureMonitorButton->setEnabled(RadioCoarse->isChecked());
    MonMeasurementSheet->setEnabled(RadioAccurate->isChecked());
    ControlsToValues();
    slotIsAllReady();
}

void lprofMain::slotTargetRefChanged()
{
   // qDebug("lprofMain::slotTargetRefChanged");
   if (!targetList->isEmpty())  // taragetList has items and we are now at the begining
      for (uint i=0; i<targetList->count(); i++)
         if (targetList->at(i)->targPos == TargetSelector->getCurrItem())
            {
                SelectTemplate->setCurrItem(targetList->at(i)->tempPos);
                break;
            }
}

// interfaces to other dialogs

void lprofMain::ProfChecker_clicked()
{
    // qDebug("lprofMain::profChecker_clicked");
    QString temp_measurement, temp_Output, Mon_temp_measure;

    ControlsToValues();
     temp_measurement= (QString)  sys.hdr.MeasurementSheet;
     temp_Output = (QString)  sys.hdr.OutputProfileFile;
     Mon_temp_measure = (QString) sys.hdr.MonMeasurementSheet;

     switch (lprofMain::TabProfiler -> currentPageIndex())
     {
        case 0:  break;
        case 1:  if (RadioCoarse->isChecked())
                          strcpy( sys.hdr.MonMeasurementSheet, "");
                      strcpy(sys.hdr.OutputProfileFile, sys.hdr.MonOutputProfileFile);
                      strcpy(sys.hdr.MeasurementSheet, sys.hdr.MonMeasurementSheet);
                      break;

    default:;  // if not on a profiling tab do nothing
    }

    ProfileChecker check(this);
    if (dsizes.profchH > 0 && dsizes.profchW > 0)
        check.resize(dsizes.profchW, dsizes.profchH);
    check.show();
    check.exec();
    strcpy(sys.hdr.MonMeasurementSheet, Mon_temp_measure);
    strcpy( sys.hdr.MeasurementSheet, temp_measurement);
    strcpy(sys.hdr.OutputProfileFile, temp_Output);
}

void lprofMain::ProfIDpushButton_clicked()
{
    // qDebug("lprofMain::ProfIDButton_clicked");
    ProfileID profID(this);
    profID.setModal(true);
    if (dsizes.profidH > 0 && dsizes.profidW > 0)
        profID.resize(dsizes.profidW, dsizes.profidH);
    profID.show();
    profID.exec();

    setProfileIDText();
    slotIsAllReady();
}


void lprofMain::ProfileParmsbutton()
{
    // qDebug("lprofMain::ProfileParmsbutton");
    ProfileParms profParms(this);
    if (dsizes.profparmsH > 0 && dsizes.profparmsW > 0)
        profParms.resize(dsizes.profparmsW, dsizes.profparmsH);
    profParms.show();
    profParms.exec();

    setProfileParmsText();
    slotIsAllReady();
}


void lprofMain::monitorvalues_clicked()
{
    // qDebug("lprofMain::monitorvalues_clicked");

    MonitorValues monVal(this);
    if (dsizes.monvalH > 0 && dsizes.monvalW > 0)
        monVal.resize(dsizes.monvalW, dsizes.monvalH);
    monVal.show();
    monVal.exec();
    slotIsAllReady();
}

void monVal::get(monVal* out)
{
    // qDebug("in get mon");
    out->items=monitorValues.items;
}

void monVal::put(monVal &in)
{
     // qDebug("in put mon");
     monitorValues.items=in.items;

     if (sys.Prelinearization[0]) cmsFreeGamma(sys.Prelinearization[0]);
     if (sys.Prelinearization[1]) cmsFreeGamma(sys.Prelinearization[1]);
     if (sys.Prelinearization[2]) cmsFreeGamma(sys.Prelinearization[2]);

     if (monitorValues.items.linked)
     {
         double val = monitorValues.items.rgamma;

        sys.Prelinearization[0] = cmsBuildGamma(256, val);
        sys.Prelinearization[1] = cmsBuildGamma(256, val);
        sys.Prelinearization[2] = cmsBuildGamma(256, val);
     }
     else
     {
         sys.Prelinearization[0] = cmsBuildGamma(256, monitorValues.items.rgamma);
         sys.Prelinearization[1] = cmsBuildGamma(256, monitorValues.items.ggamma);
         sys.Prelinearization[2] = cmsBuildGamma(256, monitorValues.items.bgamma);
     }
}

void passSys::get( PROFILERDATA* out)
{
    // qDebug("passSys::get");
    out->hdr=sys.hdr;
    out->Prelinearization[0]=sys.Prelinearization[0];
    out->Prelinearization[1]=sys.Prelinearization[1];
    out->Prelinearization[2]=sys.Prelinearization[2];
    out->ReverseTables[0]=sys.ReverseTables[0];
    out->ReverseTables[1]=sys.ReverseTables[1];
    out->ReverseTables[2]=sys.ReverseTables[2];
    out->PreLab[0]=sys.PreLab[0];
    out->PreLab[1]=sys.PreLab[1];
    out->PreLab[2]=sys.PreLab[2];
    out->PreLabRev[0]=sys.PreLabRev[0];
    out->PreLabRev[1]=sys.PreLabRev[1];
    out->PreLabRev[2]=sys.PreLabRev[2];
    out->PrimariesMatrix=sys.PrimariesMatrix;
    out->PrimariesMatrixRev=sys.PrimariesMatrixRev;
    out->HiTerms=sys.HiTerms;
    out->LoTerms=sys.LoTerms;
    out->RsplSmoothness=sys.RsplSmoothness;
    out->AvgDev=sys.AvgDev;
    out->Rspl=sys.Rspl;

}

void passSys::put(PROFILERDATA &in)
{
     sys.hdr=in.hdr;
     sys.RsplSmoothness=in.RsplSmoothness;
     sys.AvgDev=in.AvgDev;
}

void lprofMain::init_targetlist()
{
    SelectTemplate->FillValues();
    QString TargetFile = TargetSelector -> getFilename();
    QString TemplateFile = SelectTemplate -> getFilename();
    int i = TargetSelector->getCurrItem();
    int n = SelectTemplate->getCurrItem();
    // reinitialize TargetSelector so that it has the new target ref file/template file pair if one was added
    // This could cause the possition of the currently selected target to change in the drop down
    // So we must get the filename from the curent item to make sure that this item is selected
    // when this is finished and before TargetSelector is reintitalized with FillValues
    TargetSelector->FillValues();  // why dons't this work?

    // find new possition of currently selected target
    int j;
    for (j=0; j<TargetSelector->count(); j++)
    {
        TargetSelector->setCurrItem(j);
        if (TargetSelector->getFilename()==TargetFile)
        {
            i=j;
           j=TargetSelector->count();
        }
    }

    for (j=0; j<SelectTemplate->count(); j++)
    {
        SelectTemplate->setCurrItem(j);
        if (SelectTemplate->getFilename()==TargetFile)
        {
            n=j;
           j=SelectTemplate->count();
        }
    }
    // Now add new target and it's template to the target list
    for (j=0; j<TargetSelector->count(); j++)
    {
        TargetSelector->setCurrItem(j);
        for (int k=0; k<SelectTemplate->count(); k++)
        {
            SelectTemplate->setCurrItem(k);

            if (!targetList->isEmpty())  // targetList has items and we start at the begining
                for (uint m=0; m<targetList->count(); m++)
                     if (targetList->at(m)->targetFile==TargetSelector->getFilename() &&
                        targetList->at(m)->templateFile==SelectTemplate->getFilename())
                       {
                           targetList->at(m)->targPos=j;
                           targetList->at(m)->tempPos=k;
                       }
         }
     }

   TargetSelector->setCurrItem(i);
   SelectTemplate->setCurrItem(n);
}

static bool refinstOK;
static targetTemplate tempTT;

void targetTemplate::put(targetTemplate &in)
{
    if (in.items.targetFile!=""&&in.items.templateFile!="")
    {
        add_target(in.items);
        tempTT.items = in.items;
        refinstOK = true;
    }
}

void lprofMain::slotInstallReference()
{
    // qDebug("lprofMain::ProfIDButton_clicked");

    refinstOK = false;
    InstallRefFile reffile(this);
    reffile.setModal(true);
    if (dsizes.reffileH > 0 && dsizes.reffileW > 0)
        reffile.resize(dsizes.reffileW, dsizes.reffileH);
    reffile.show();
    reffile.exec();

    if (refinstOK)
    {

        init_targetlist();
        slotTargetRefChanged();
        slotIsAllReady();
    }
    // else
    //    TargetSelector->FillValues();
}

void::dialogSize::put(int d, int h, int w)
{
    switch (d)
    {
        case 1: // reference file installer dialog
            dsizes.reffileH = h;
            dsizes.reffileW = w;
            break;
        case 2: // monitorvalue dialog
            dsizes.monvalH = h;
            dsizes.monvalW = w;
            break;
        case 3: // ProfileChecker dialog
            dsizes.profchH = h;
            dsizes.profchW = w;
            break;
        case 4: //ProfileID dialog
            dsizes.profidH = h;
            dsizes.profidW = w;
            break;
        case 5: //ProfileParms dialog
            dsizes.profparmsH = h;
            dsizes.profparmsW = w;
            break;
        default:  break;
    }
}


void lprofMain::slotHelpButton()
{
     QString path = QDir::currentDirPath() + "/help/lprof-help.html";
     // qDebug(path);
     help->openAssistant ();
     help->showPage(path);
}
