C nettle, low-level cryptographics library
C 
C Copyright (C) 2005, Niels Mller
C  
C The nettle library is free software; you can redistribute it and/or modify
C it under the terms of the GNU Lesser General Public License as published by
C the Free Software Foundation; either version 2.1 of the License, or (at your
C option) any later version.
C 
C The nettle library is distributed in the hope that it will be useful, but
C WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
C or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
C License for more details.
C 
C You should have received a copy of the GNU Lesser General Public License
C along with the nettle library; see the file COPYING.LIB.  If not, write to
C the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
C MA 02111-1307, USA.

define(<STATE>, <%i0>)
define(<INPUT>, <%i1>)

C	State vector
define(<SA>,	<%l0>)
define(<SB>,	<%l1>)
define(<SC>,	<%l2>)
define(<SD>,	<%l3>)
define(<SE>,	<%l4>)

define(<W>,	<%l5>)
define(<N>,	<%l6>)
define(<K>,	<%l7>)

C	Temporaries
define(<T0>,	<%i2>)
define(<T1>,	<%i3>)
define(<T2>,	<%i4>)
define(<T3>,	<%i5>)

C Constants
define(<K1VALUE>, <0x5A827999>)		C  Rounds  0-19
define(<K2VALUE>, <0x6ED9EBA1>)		C  Rounds 20-39
define(<K3VALUE>, <0x8F1BBCDC>)		C  Rounds 40-59
define(<K4VALUE>, <0xCA62C1D6>)		C  Rounds 60-79

C The sparc32 stack frame looks like
C
C %fp -   4: OS-dependent link field
C %fp -   8: OS-dependent link field
C %fp -  72: uint32_t w[16]
C %fp - 168: OS register save area 
define(<FRAME_SIZE>, 168)

	.file "sha1-compress.asm"

	C _nettle_sha1_compress(uint32_t *state, uint8_t *data)

	.section	".text"
	.align 16
	.proc	020
	
PROLOGUE(_nettle_sha1_compress)

	save	%sp, -FRAME_SIZE, %sp
	sub	%fp, 72, W

	C	Read big endian input data and store on the stack.

	andcc	INPUT, 3, %g0
	ld	[STATE], SA
	ld	[STATE + 4], SB
	ld	[STATE + 8], SC
	ld	[STATE + 12], SD
	beq	.Laligned
	ld	[STATE + 16], SE

	C	Unaligned data. Read a byte at a time.
	mov	16, N
.Lunaligned_loop:

	C	FIXME: Pipeline, maybe unroll twice
	ldub	[INPUT], T0
	sll	T0, 8, T0
	ldub	[INPUT + 1], T2
	or	T2, T0, T2
	sll	T0, 8, T0
	ldub	[INPUT + 2], T2
	or	T2, T0, T2
	sll	T0, 8, T0
	ldub	[INPUT + 3], T2
	or	T2, T0, T2
	st	T2, [W]
	subcc	N, 1, N
	add	W, 4, W
	bne	.Lunaligned_loop
	add	INPUT, 4, INPUT


	ba	.Lmangling
	sub	W, 64, W

.Laligned:

	ld	[INPUT], T0
	ld	[INPUT + 4], T1
	st	T0, [W]
	ld	[INPUT + 8], T0
	st	T1, [W + 4]
	ld	[INPUT + 12], T1

	st	T0, [W + 8]
	ld	[INPUT + 16], T0
	st	T1, [W + 12]
	ld	[INPUT + 20], T1

	st	T0, [W + 16]
	ld	[INPUT + 24], T0
	st	T1, [W + 20]
	ld	[INPUT + 28], T1

	st	T0, [W + 24]
	ld	[INPUT + 32], T0
	st	T1, [W + 28]
	ld	[INPUT + 36], T1

	st	T0, [W + 32]
	ld	[INPUT + 40], T0
	st	T1, [W + 36]
	ld	[INPUT + 44], T1

	st	T0, [W + 40]
	ld	[INPUT + 48], T0
	st	T1, [W + 44]
	ld	[INPUT + 52], T1

	st	T0, [W + 48]
	ld	[INPUT + 56], T0
	st	T1, [W + 52]
	ld	[INPUT + 60], T1

	st	T0, [W + 56]
	st	T1, [W + 60]

.Lmangling:
	setuw	K1VALUE, K
	
	
	
	ret
	restore

EPILOGUE(_nettle_sha1_compress)
