/*
 * dslk.h -- Linux header file for /dev/kmem-based lslk
 *
 * V. Abell
 * Purdue University Computing Center
 *
 * Chris Eleveld <chris@sector7.com>
 */


/* $Id: dlslk.h,v 1.6 99/11/10 15:02:05 abe Exp $ */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
 

#if	!defined(DLSLK_H_LINUX)
#define	DLSLK_H_LINUX	1

#include <fcntl.h>
#include <setjmp.h>
#include <string.h>
#include <unistd.h>
#include <mntent.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/sysmacros.h>
#include <sys/types.h>

#undef INT_MAX
#undef UINT_MAX
#undef LONG_MAX
#undef ULONG_MAX

#define	__KERNEL__
#include <linux/fs.h>
#include <linux/sched.h>
#undef	__KERNEL__

#if	!defined(ENOSYS)
#include <errno.h>
#endif	/* !defined(ENOSYS) */

/*
 * Controls for accessing kernel symbols
 */

#include <linux/module.h>
#include <linux/unistd.h>
#define	get_kernel_syms(addr)	syscall(__NR_get_kernel_syms, (addr))


/*
 * Local definitions
 */

#define	COMP_P		const void	/* qsort() compare pointer type */
#define	KA_T		off_t		/* kernel address type for kread() */
#define	LMEMCPY_P	void		/* local memcpy() type */
#define	lmemcpy(d,s,n)	bcopy(s,d,n)	/* local memcpy() function */
#define	MALLOC_P	char		/* malloc() pointer cast */
#define	MALLOC_S	size_t		/* malloc() size cast */
#define	QSORT_P		void		/* qsort() table pointer type */


/*
 * Name list indexes
 */

#if	LINUXV>=1300
#define	X_LCKTBL	0		/* lock table pointer */
#else	/* LINUXV<1300 */
#define X_FIRSTFILE	0		/* first file pointer */
#endif	/* LINUXV>=1300 */


/*
 * Local structure definitions
 */

struct nlist {
	char *n_name;			/* kernel symbol name */
	int n_type;			/* type: 0 = defined, 1 = undefined */
	unsigned long n_value;		/* address value */
};


/*
 * Local global variables
 */

extern int Kd;				/* kernel memory file descriptor */
extern struct nlist Nl[];		/* kernel symbol table */

# endif	/* defined(DLSLK_H_LINUX) */
