/*
 * dslk.h -- Linux header file for /proc-based lslk
 *
 * V. Abell
 * Purdue University Computing Center
 */


/* $Id: dlslk.h,v 1.3 99/11/10 15:02:42 abe Exp $ */


/*
 * Copyright 1998 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
 

#if	!defined(DLSLK_H_LINUX)
#define	DLSLK_H_LINUX	1

#include <dirent.h>
#include <fcntl.h>
#include <setjmp.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/sysmacros.h>


/*
 * Local definitions
 */

#define	COMP_P		const void	/* qsort() compare pointer type */
#define	KA_T		off_t		/* kernel address type for kread() */
#define	LMEMCPY_P	void		/* local memcpy() type */
#define	lmemcpy(d,s,n)	bcopy(s,d,n)	/* local memcpy() function */
#define	MALLOC_P	char		/* malloc() pointer cast */
#define	MALLOC_S	size_t		/* malloc() size cast */
#define	PROCFS		"/proc"		/* /proc file system directory */
#define	QSORT_P		void		/* qsort() table pointer type */
#define	STATORLSTAT	stat		/* for dolstat() in safe.c */


/*
 * Externals
 */

extern int HasNFS;			/* see dmnt.c */
# endif	/* defined(DLSLK_H_LINUX) */
