/*
 * ftplib.h
 * Copyright (C) 2002 Florin Malita <mali@go.ro>
 *
 * This file is part of LUFS, a free userspace filesystem implementation.
 * See http://lufs.sourceforge.net/ for updates.
 *
 * LUFS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LUFS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _FTPLIB_H_
#define _FTPLIB_H_

using namespace std;

#define FTP_MAXLINE	4096
#define FTP_MAXFILE	1024
#define FTP_MAXTRIES	7

class FTPConnection {
  private:
    char buf[FTP_MAXLINE];
    string host, user, pass;
    unsigned short port;
    int active;
    string last_cmd;

    int execute_open_active(string, string, long long);
    int execute_open_passive(string, string, long long);
        
  public:
    long long last_off;
    int csock, dsock;
    FILE *cfd, *dfd;
    char system[32];

    FTPConnection(int, char*, unsigned short, char*, char*);
    ~FTPConnection();
    int connect();
    void disconnect();
    int get_response();
    int close_data();
    int execute(string, int, int);
    int execute_retry(string, int, int);
    int execute_open(string, string, long long);
};


#endif

