//
//  Lynkeos
//  $Id: MySizeLock.m,v 1.2 2004/09/02 22:43:31 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Mon Aug 16 2004.
//  Copyright (c) 2004. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#import "MySizeLock.h"

@interface MySizeCount : NSObject
{
@public
   MyIntegerSize  _size;
   int            _count;
}

- (id) initSizeCountWithSize :(MyIntegerSize)size ;

+ (MySizeCount*) sizeCountWithSize :(MyIntegerSize)size ;
@end

@implementation MySizeCount
- (id) initSizeCountWithSize :(MyIntegerSize)size
{
   [self init];

   _size = size;
   _count = 1;

   return( self );
}

+ (MySizeCount*) sizeCountWithSize :(MyIntegerSize)size
{
   return( [[[self alloc] initSizeCountWithSize :size] autorelease] );
}
@end

@implementation MySizeLock

// Accessors
- (BOOL) locked { return _locked; }

- (MyIntegerSize) size
{
   if ( [_sizeList count] == 1 )
      return( ((MySizeCount*)[_sizeList lastObject])->_size );
   else
      return( MyMakeIntegerSize(0,0) );
}

   // Actions
- (BOOL) lockSize
{
   BOOL ret = YES;
   int cnt = [_sizeList count];

   if ( cnt == 0 || cnt == 1 )
      _locked = YES;
   else
      ret = NO;

   return ret;
}

- (void) unlockSize
{
   _locked = NO;
}

- (BOOL) addSize :(MyIntegerSize)size
{
   BOOL ret = YES;
   NSEnumerator *iter = [_sizeList objectEnumerator];
   MySizeCount* obj;

   // Find the size in the list
   while ( (obj = [iter nextObject]) != nil && 
           obj->_size.width != size.width && obj->_size.height != size.height )
      ;

   // If found, count one more
   if ( obj != nil )
      obj->_count++;

   else
   {
      // Otherwise, adding a new size is allowed only if not locked
      if ( _locked && [_sizeList count] != 0 )
         ret = NO;
      else
         [_sizeList addObject:[MySizeCount sizeCountWithSize:size]];
   }

   return( ret );
}

- (void) removeSize :(MyIntegerSize)size
{
   NSEnumerator *iter = [_sizeList objectEnumerator];
   MySizeCount* obj;
   
   // Find the size in the list
   while ( (obj = [iter nextObject]) != nil && 
           obj->_size.width != size.width && obj->_size.height != size.height )
      ;

   NSAssert( obj != nil, @"Cannot remove inexistent size" );

   obj->_count--;
   NSAssert( obj->_count >= 0, @"Size count becomes negative" );

   if ( obj->_count == 0 )
      [_sizeList removeObject :obj];
}

// Constructors
- (id) init
{
   [super init];

   _locked = NO;
   _sizeList = [[NSMutableArray array] retain];

   return( self );
}

+ (id) sizeLock
{
   return( [[[self alloc] init] autorelease] );
}

@end
