/*
 * $Id: output.c,v 1.7 2000/06/27 13:07:23 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 *  output.c  --  initiate call to client.
 *
 *  Created by ceder 1990-07-17
 */

#include <config.h>
#include <stdio.h>

#include <kom-types.h>
#include <services.h>

#include "client.h"
#include "output.h"
#include "komserv.h"
#include <com.h>

#include "send.h"

static void
output_packet_header(Call_header fnc)
{
    fprintf(KS->out, "0 %lu", (unsigned long)fnc);
}


extern  void
output_login (Pers_no		person,
	      const String	passwd,
	      Bool		visible)
{
    output_packet_header(call_fnc_login);
    fprintf(KS->out, " %lu", (unsigned long)person);
    output_string(KS->out, passwd);
    fprintf(KS->out, " %lu", (unsigned long)visible);
    putc('\n', KS->out);
    fflush(KS->out);
}



extern  void
output_logout (void)	/* can never fail */
{
    output_packet_header(call_fnc_logout);
    putc('\n', KS->out);
    fflush(KS->out);
}



extern  void
output_change_conference (Conf_no	conference )
{
    output_packet_header(call_fnc_change_conference);
    fprintf(KS->out, " %lu\n", (unsigned long)conference);
    fflush(KS->out);
}




extern  void
output_change_name (Conf_no       conf_no,
		    const String  new_name)
{
    output_packet_header(call_fnc_change_name);
    fprintf(KS->out, " %lu", (unsigned long)conf_no);
    output_string(KS->out, new_name );
    putc('\n', KS->out);
    fflush(KS->out);
}


extern  void
output_change_what_i_am_doing (const String  what_am_i_doing )
{
    output_packet_header(call_fnc_change_what_i_am_doing);
    output_string(KS->out, what_am_i_doing );
    putc('\n', KS->out);
    fflush(KS->out);
}




/******************************
*     Person-related calls    *
******************************/

/*
 *  Create a new person.  Returns 0 if any error occured.
 */
extern void
output_create_person (const String  name,
		      const String  passwd )
{
    output_packet_header(call_fnc_create_person);
    output_string(KS->out, name );
    output_string( KS->out, passwd );
    putc('\n', KS->out);
    fflush(KS->out);
}


extern  void
output_get_person_stat (Pers_no	        person)
{
    output_packet_header(call_fnc_get_person_stat);
    fprintf(KS->out, " %lu\n", (unsigned long) person);
    fflush(KS->out);
}

extern  void
output_get_created_texts(Pers_no       pers_no,
			 Local_text_no first,
			 unsigned long len )
{
    output_packet_header(call_fnc_get_created_texts);
    fprintf(KS->out, " %lu %lu %lu\n",
	    (unsigned long) pers_no,
	    (unsigned long) first,
	    (unsigned long) len);
    fflush(KS->out);
}


extern  void
output_get_membership (Pers_no		  person,
		       unsigned short	  first,
		       unsigned short	  no_of_confs,
		       Bool		  want_read_texts )
{
    output_packet_header(call_fnc_get_membership);
    fprintf(KS->out, " %lu %lu %lu %lu\n",
	    (unsigned long)person,
	    (unsigned long)first,
	    (unsigned long)no_of_confs,
	    (unsigned long)want_read_texts);
    fflush(KS->out);
}


extern  void
output_set_priv_bits (Pers_no	 person,
		      Priv_bits  privileges )
{
    output_packet_header(call_fnc_set_priv_bits);
    fprintf(KS->out, " %lu", (unsigned long) person);
    output_priv_bits( KS->out, privileges );
    putc('\n', KS->out);
    fflush(KS->out);
}



extern  void
output_set_passwd (Pers_no	  person,
		   const String   old_pwd,
		   const String   new_pwd )
{
    output_packet_header(call_fnc_set_passwd);
    fprintf(KS->out, " %lu", (unsigned long) person);
    output_string( KS->out, old_pwd );
    output_string( KS->out, new_pwd );
    putc('\n', KS->out);
    fflush(KS->out);
}


extern  void
output_query_read_texts (Pers_no	   pers_no,
			 Conf_no	   conf_no)
{
    output_packet_header(call_fnc_query_read_texts);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) pers_no,
	    (unsigned long) conf_no);
    fflush(KS->out);
}




/****************************************
*	Conference-related calls	*
****************************************/


extern  void
output_create_conf (const String  name,
		    Conf_type	  type )
{
    output_packet_header(call_fnc_create_conf);
    output_string( KS->out, name );
    output_conf_type( KS->out, type );
    putc('\n', KS->out);
    fflush(KS->out);
}



extern  void
output_delete_conf (Conf_no	conf )
{
    output_packet_header(call_fnc_delete_conf);
    fprintf(KS->out, " %lu\n", (unsigned long) conf);
    fflush(KS->out);
}



extern  void
output_get_conf_stat (Conf_no  conf_no)
{
    output_packet_header(call_fnc_get_conf_stat);
    fprintf(KS->out, " %lu\n", (unsigned long) conf_no);
    fflush(KS->out);
}

extern  void
output_get_members (Conf_no		  conf,
		    unsigned short	  first,
		    unsigned short	  no_of_members)
{
    output_packet_header(call_fnc_get_members);
    fprintf(KS->out, " %lu %lu %lu\n", 
	    (unsigned long) conf, 
	    (unsigned long) first,
	    (unsigned long) no_of_members);
    fflush(KS->out);
}


extern  void
output_add_member (Conf_no		conf_no,
		   Pers_no		pers_no,
		   unsigned char	priority,
		   unsigned short	where	)
{
    output_packet_header(call_fnc_add_member);
    fprintf(KS->out, " %lu %lu %lu %lu\n", 
	    (unsigned long) conf_no,
	    (unsigned long) pers_no,
	    (unsigned long) priority,
	    (unsigned long) where);
    fflush(KS->out);
}



extern  void
output_sub_member (Conf_no	conf_no,
		   Pers_no	pers_no )
{
    output_packet_header(call_fnc_sub_member);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) conf_no,
	    (unsigned long) pers_no);
    fflush(KS->out);
}


extern  void
output_set_unread (Conf_no   conf_no,
		   Text_no   no_of_unread)
{
    output_packet_header(call_fnc_set_unread);
    fprintf(KS->out, " %lu %lu\n",
	    (unsigned long) conf_no, 
	    (unsigned long) no_of_unread);
    fflush(KS->out);
}



extern  void
output_set_presentation (Conf_no   conf_no,
			 Text_no   text_no )
{
    output_packet_header(call_fnc_set_presentation);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) conf_no, 
	    (unsigned long) text_no);
    fflush(KS->out);
}


extern  void
output_set_etc_motd (Conf_no	  conf_no,
		     Text_no	  text_no )
{
    output_packet_header(call_fnc_set_etc_motd);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) conf_no, 
	    (unsigned long) text_no);
    fflush(KS->out);
}



extern  void
output_set_supervisor (Conf_no	  conf_no,
		       Conf_no	  admin	)
{
    output_packet_header(call_fnc_set_supervisor);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) conf_no,
	    (unsigned long) admin);
    fflush(KS->out);
}


extern  void
output_set_permitted_submitters (Conf_no  conf_no,
				 Conf_no  perm_sub )
{
    output_packet_header(call_fnc_set_permitted_submitters);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) conf_no, 
	    (unsigned long) perm_sub);
    fflush(KS->out);
}


extern  void
output_set_super_conf (Conf_no	  conf_no,
		       Conf_no	  super_conf )
{
    output_packet_header(call_fnc_set_super_conf);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) conf_no, 
	    (unsigned long) super_conf);
    fflush(KS->out);
}


extern  void
output_set_conf_type (Conf_no	 conf_no,
		      Conf_type  type	)
{
    output_packet_header(call_fnc_set_conf_type);
    fprintf(KS->out, " %lu", (unsigned long) conf_no);
    output_conf_type(KS->out, type);
    putc('\n', KS->out);
    fflush(KS->out);
}


extern  void
output_set_garb_nice (Conf_no	 conf_no,
		      Garb_nice  nice	)
{
    output_packet_header(call_fnc_set_garb_nice);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) conf_no,
	    (unsigned long) nice);
    fflush(KS->out);
}




/********************************
*     Calls to handle marks     *
********************************/


extern  void
output_get_marks (void)
{
    output_packet_header(call_fnc_get_marks);
    putc('\n', KS->out);
    fflush(KS->out);
}




extern  void
output_mark_text (Text_no  	  text,
		  unsigned char   mark_type )
{
    output_packet_header(call_fnc_mark_text);
    fprintf(KS->out, " %lu %lu\n",
	    (unsigned long) text, 
	    (unsigned long) mark_type);
    fflush(KS->out);
}





/*******************************
*     Calls to handle texts    *
*******************************/


extern  void
output_get_text (Text_no      text,
		 String_size  start_char,
		 String_size  end_char)
{
    output_packet_header(call_fnc_get_text);
    fprintf(KS->out, " %lu %lu %lu\n", 
	    (unsigned long) text,
	    (unsigned long) start_char,
	    (unsigned long) end_char);
    fflush(KS->out);
}


static void
intern_output_put_exactly_one_textno(enum call_header call,
				     Text_no    text)
{
    output_packet_header(call);
    fprintf(KS->out, " %lu\n", (unsigned long)text);
    fflush(KS->out);
}

extern  void
output_get_text_stat (Text_no    text)
{
    intern_output_put_exactly_one_textno(call_fnc_get_text_stat, text);
}


extern  void
output_mark_as_read (Conf_no		    conference,
		     int		    no_of_texts,
		     const Local_text_no  * text_arr   )
{
    int i;
    
    output_packet_header(call_fnc_mark_as_read);
    fprintf(KS->out, " %lu %lu", 
	    (unsigned long) conference,
	    (unsigned long) no_of_texts);
    fprintf(KS->out, " {");
    for ( i = 0; i < no_of_texts; i++ )
	fprintf(KS->out, " %lu", (unsigned long)text_arr[ i ]);
    fprintf(KS->out, " }\n");
    fflush(KS->out);
}



extern  void
output_create_text (const String       message,
		    unsigned short     no_of_misc,
		    const Misc_info  * misc	     )
{
    unsigned short i;
    
    output_packet_header(call_fnc_create_text);
    output_string( KS->out, message );
    fprintf(KS->out, " %lu {", (unsigned long) no_of_misc);
    for ( i = 0; i < no_of_misc; i++ )
	output_misc_info(KS->out, misc[ i ]);
    fprintf(KS->out, " }\n");
    fflush(KS->out);
}

extern  void
output_create_anonymous_text (const String       message,
			      unsigned short     no_of_misc,
			      const Misc_info  * misc	     )
{
    unsigned short i;
    
    output_packet_header(call_fnc_create_text);
    output_string( KS->out, message );
    fprintf(KS->out, " %lu {", (unsigned long) no_of_misc);
    for ( i = 0; i < no_of_misc; i++ )
	output_misc_info(KS->out, misc[ i ]);
    fprintf(KS->out, " }\n");
    fflush(KS->out);
}


extern void
output_delete_text( Text_no text_no )
{
    output_packet_header(call_fnc_delete_text);
    fprintf(KS->out, " %lu\n", (unsigned long) text_no);
    fflush(KS->out);
}




extern  void
output_add_recipient (Text_no	  text_no,
		      Conf_no	  conf_no,
		      Info_type  type	)
{
    output_packet_header(call_fnc_add_recipient);
    fprintf(KS->out, " %lu %lu %lu\n", (unsigned long) text_no,
	    (unsigned long) conf_no, (unsigned long) type);
    fflush(KS->out);
}


extern  void
output_sub_recipient (Text_no	  text_no,
		      Conf_no	  conf_no )
{
    output_packet_header(call_fnc_sub_recipient);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) text_no,
	    (unsigned long) conf_no);
    fflush(KS->out);
}



extern  void
output_add_comment (Text_no	  comment,
		    Text_no 	  comment_to )
{
    output_packet_header(call_fnc_add_comment);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) comment,
	    (unsigned long) comment_to);
    fflush(KS->out);
}



extern  void
output_sub_comment (Text_no	  comment,
		    Text_no	  comment_to )
{
    output_packet_header(call_fnc_sub_comment);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) comment,
	    (unsigned long) comment_to);
    fflush(KS->out);
}

extern  void
output_add_footnote (Text_no	  footnote,
		     Text_no 	  footnote_to )
{
    output_packet_header(call_fnc_add_footnote);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) footnote, 
	    (unsigned long) footnote_to);
    fflush(KS->out);
}



extern  void
output_sub_footnote (Text_no	  footnote,
		     Text_no	  footnote_to )
{
    output_packet_header(call_fnc_sub_footnote);
    fprintf(KS->out, " %lu %lu\n", 
	    (unsigned long) footnote, 
	    (unsigned long) footnote_to);
    fflush(KS->out);
}



extern  void
output_get_map (Conf_no	       conf_no,
		Local_text_no  first_local_no,
		Local_text_no  no_of_texts)
{
    output_packet_header(call_fnc_get_map);
    fprintf(KS->out, " %lu %lu %lu\n", 
	    (unsigned long) conf_no,
	    (unsigned long) first_local_no, 
	    (unsigned long) no_of_texts);
    fflush(KS->out);
}



extern  void
output_get_time ( void )
{
    output_packet_header(call_fnc_get_time);
    putc('\n', KS->out);
    fflush(KS->out);
}

extern  void
output_get_info ( void )
{
    output_packet_header(call_fnc_get_info);
    putc('\n', KS->out);
    fflush(KS->out);
}


extern void
output_set_motd_of_lyskom (Text_no motd)
{
    output_packet_header(call_fnc_set_motd_of_lyskom);
    fprintf(KS->out, " %lu\n", (unsigned long) motd);
    fflush(KS->out);
}


extern void
output_enable (unsigned char ena_level)
{
    output_packet_header(call_fnc_enable);
    fprintf(KS->out, " %lu\n", (unsigned long) ena_level);
    fflush(KS->out);
}


extern void
output_sync (void) 
{
    output_packet_header(call_fnc_sync);
    putc('\n', KS->out);
    fflush(KS->out);
}


extern void
output_shutdown (int exit_val) 
{
    output_packet_header(call_fnc_shutdown);
    fprintf(KS->out, " %lu\n", (unsigned long) exit_val);
    fflush(KS->out);
}


extern void
output_send_message (Pers_no recipient,
		     const String message) 
{
    output_packet_header(call_fnc_send_message);
    fprintf(KS->out, " %lu\n", (unsigned long) recipient);
    output_string(KS->out, message);
    putc('\n', KS->out);
    fflush(KS->out);
}

void
output_get_unread_confs (Pers_no pers_no)
{
    output_packet_header(call_fnc_get_unread_confs);
    fprintf(KS->out, " %lu\n", (unsigned long) pers_no);
    fflush(KS->out);
}

void
output_get_last_text(struct tm	*clock_arg)
{
    output_packet_header(call_fnc_get_last_text);
    fprintf(KS->out, " %d %d %d %d %d %d %d %d %d\n",
	    clock_arg->tm_sec,
	    clock_arg->tm_min,
	    clock_arg->tm_hour,
	    clock_arg->tm_mday,
	    clock_arg->tm_mon,
	    clock_arg->tm_year,
	    clock_arg->tm_wday,
	    clock_arg->tm_yday,
	    clock_arg->tm_isdst);
    fflush(KS->out);
}

extern  void
output_get_next_text_no (Text_no    text)
{
    intern_output_put_exactly_one_textno(call_fnc_find_next_text_no, text);
}

extern  void
output_get_previous_text_no (Text_no    text)
{
    intern_output_put_exactly_one_textno(call_fnc_find_previous_text_no, text);
}


void
output_lookup_z_name(const String	name,
		     unsigned int	want_persons,
		     unsigned int	want_confs)
{
    output_packet_header(call_fnc_lookup_z_name);
    output_string(KS->out, name);
    fprintf(KS->out, " %u %u\n", want_persons, want_confs);
    fflush(KS->out);
}


void
output_re_z_lookup(const String	name,
		   unsigned int	want_persons,
		   unsigned int	want_confs)
{
    output_packet_header(call_fnc_re_z_lookup);
    output_string(KS->out, name);
    fprintf(KS->out, " %u %u\n", want_persons, want_confs);
    fflush(KS->out);
}


void
output_who_is_on_dynamic(unsigned int	want_visible,
			 unsigned int	want_invisible,
			 unsigned long	active_last)
{
    output_packet_header(call_fnc_who_is_on_dynamic);
    fprintf(KS->out, 
	    " %u %u %lu\n", want_visible, want_invisible, active_last);
    fflush(KS->out);
}

