/* This file keeps track of all handling of the mail format. */
/*
 * Copyright 1995 Linus Tolke, Lysator
 */

/*
 * Idea:
 * The interface to this file is very simple.
 * malloc:ed string are returned everywhere.
 * The are never free:d since the program is supposed to do exit immediatly.
 *
 * Datatypes:
 * The only special handling is of the header.
 * Then the relevant fields are copied, in the given explicit order, into
 * the "letter" area that is grown dynamically as we copy more and more
 * things into it.
 */

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif
#include <stdio.h>
#include <sysexits.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif
#if STDC_HEADERS || HAVE_STRING_H
#  include <string.h>
#  if !STDC_HEADERS && HAVE_MEMORY_H
#    include <memory.h>
#  endif
#else /* not STDC_HEADERS and not HAVE_STRING_H */
#  include <strings.h>
   /* memory.h and strings.h conflict on some systems.  */
#  define strchr index
#  define strrchr rindex
#endif /* not STDC_HEADERS and not HAVE_STRING_H */

#include "params.h"

#ifdef DO_RECODE
#  ifdef RECODE
#    include <unistd.h>
#    include <errno.h>
#    ifdef HAVE_WAIT_H
#    include <wait.h>
#    endif
#  else
#    undef DO_RECODE
#  endif
#endif

/*
 * Simple string copying.
 */
char * copy_string(char * p) 
{
    char * new = malloc(strlen(p) + 1);

    strcpy(new, p);
    return new;
}

#define INITIAL 10240

static char * messageid = NULL;
char * vilket_messageid() { return messageid; }

static char * commentto = NULL;
char * vilket_commentto() { return commentto; }

static char * errorsto = NULL;
char * vilket_errorsto() { return errorsto; }

static char * area = NULL;
static char * get_area() { return area; }

static char * body_charset = NULL;

void append(char * text)
{
    /* Nu kommer jag strax att g|ra massor av realloc.
       Det jag hoppas med att allokera ganska mycket i b|rjan {r att
       den f|rsta realloc inte kopierar in allt i en mindre area.
       Det beror givetvis p} realloc implementationen men skulle
       den f} f|r sig att g|ra s}dant s} fungerar det i alla fall om {n 
       icke-optimalt.

       Ajd}, malloc verkar f|r smart f|r att jag skall kunna g|ra det h{r
       p} en sun3, sunos 4.1.1_u1. Lika bra att f|renkla.

       Optimeringen man kan g|ra h{r {r uppenbar. Man kan sj{lv ta hand
       om minneshanteringen och h}lla reda p} hur mycket som man har 
       allokerat och allokera i stora klumpar...
     */
    if (area == NULL)
    {	
	area = copy_string("");
    }

    area = realloc(area, strlen(area) + 1 + strlen(text) + 1);

    strcat(area, text);
}


void prepend(char * text)	/* This inserts a text in the beginning */
{
    char * newarea;

    if (area == NULL)
    {
	append(text);
    }
    else
    {				/* B|kigt b|kigt! */
	newarea = malloc(strlen(area) + 1 + strlen(text) + 1);
	strcpy(newarea, text);
	strcat(newarea, area);
	free(area);
	area = newarea;
    }
}

/*
 * crop_area()
 * Plockar bort whitespace i slutet p} area.
 */
void
crop_area()
{
    int end;

    while ((end = strlen(area) - 1) > -1 /* Cannot crop us to death */
	   && (area[end] == ' '
	       || area[end] == '\t'
	       || area[end] == '\n'
	       || area[end] == '\r'))
	area[end] = '\0';
}
	

    
    

/*
 * All l{sning sker i denna read_line och den returnerar en mallokerad
 * str{ng. Det {r anroparens ansvar att g|ra free.
 *
 * Denna blockar om den inte f}r l{sa och returnerar NULL om det {r EOF.
 * Raderna som returneras avslutas med en '\n'.
 */
static char * read_line()
{
    int size = 100; /* Det {r ytterst f} rader som {r l{ngre {n 80 tecken.
		       Jag hade size till 1000 f|rst men det {r ju ett
		       j{ttesl|seri, dvs om man inte g|r saker med raden
		       direkt och det g|r vi ju n{stan alltid.
		     */
    char * line = malloc(size + 4);
    int c;
    int idx = 0;

    while ((c = getchar()) != EOF
	   && (c != '\n'))
    {
	if (idx >= size)	/* Nu b|rjar det bli det tr}ngt. */
	{
	    size *= 2;
	    line = realloc(line, size + 4);
	}
	line[idx] = c;
	idx++;
    }

    if (c == EOF && idx == 0)	/* Du {r det slut. */
    {
	free(line);
	return NULL;
    }

    line[idx++] = '\n';
    line[idx++] = '\0';

    return line;
}


/*
 * snarfamid() returnerar en mallokerad str{ng som inneh}ller den sista
 * message-id p} den raden som vi tittar p}. message-id {r i detta bem{rkelse
 * n}got mellan < och >. Om det inte finns n}got s}dant returneras NULL.
 */
char *
snarfamid(char * txt)
{
    char * buff;
    char * p;

    if (txt == NULL)
	return NULL;

    p = strrchr(txt, '<');
    if (p) {
        buff = copy_string(p + 1);
	p = strchr(buff, '>');
	if (p) {
	    *p = '\0';
	    return buff;
	}
	free(buff);
    }
    return NULL;
}



/*
 * Avkoda QP.
 * Jag f|ruts{tter att den nya raden inte kan bli l{ngre {n den rad som jag 
 * skall koda av. Det skall den inte bli.
 * Returnerar en nyallokerad str{ng. R|r inte den inskickade str{ngen.
 */
char *
avkoda_qp(const char * p)
{
    char * new = malloc(strlen(p) + 1);
    int i;

    for (i = 0; *p != '\0'; p++)
    {
	if (*p != '=')
	{
	    new[i++] = *p;
	    continue;
	}

	p++;
	if (*p == '\n')
	{
	    continue;
	}
	
	if (isxdigit(p[0])
	    && isxdigit(p[1]))
	{
	    int j;
	    int res = 0;

	    for (j = 0; j < 2; j++)
	    {
		int val;

		if (isdigit(p[j]))
		    val = p[j] - '0';
		else if (isupper(p[j]))
		    val = 10 + p[j] - 'A';
		else 
		    val = 10 + p[j] - 'a';

		res += val << (j == 0 ? 4 : 0);
	    }
	    p ++;

	    new[i++] = res;
	    continue;
	}

	/* I don't know how to decode this. Just insert whatever. */
	new[i++] = *p;
    }

    new[i] = '\0';
    return new;
}

/*
 * Avkoda BASE64.
 * Den nya radens lngd kan verskattas med formeln
 * nylngd < ciel( gammallngd/4 ) * 3 + 1
 * Returnerar en nyallokerad strng. Rr inte den inskickade strngen.
 */
char *
avkoda_base64(const char * p)
{
    char * new = malloc(((strlen(p) + 3) / 4) * 3 + 1);
    char * newp = new;
    /* Eftersom base64-kodning inte r radbaserad mste vi hlla lite
       state...  Inte jttesnyggt men men... */
    static long d = 1;
    static int strips = 0;

    while (*p)
    {
        if (*p == '=')
        {
	    d <<= 6;
	    strips ++;
	}
	else if (*p >= 'A' && *p <= 'Z')
	{
	    d <<= 6;
	    d |= *p - 'A';
	}
	else if (*p >= 'a' && *p <= 'z')
	{
	    d <<= 6;
	    d |= *p - ('a' - 26);
	}
	else if (*p >= '0' && *p <= '9')
	{
	    d <<= 6;
	    d |= *p - ('0' - 52);
	}
	else if (*p == '+')
	{
	    d <<= 6;
	    d |= 62;
	}
	else if (*p == '/')
	{
	    d <<= 6;
	    d |= 63;
	}
	if (d >= (1<<24))
	{
	    *newp++ = (d >> 16) & 0xff;
	    *newp++ = (d >> 8) & 0xff;
	    *newp++ = d & 0xff;
	    d = 1;
	}
	p ++;
    }
    if (d == 1) {
        newp[ -strips ] = '\0';
        strips = 0;
    }
    else
        *newp = '\0';

    return new;
}

/*
 * Avkodning av QP och 6bit mm.
 * Denna avkodning sker en rad i taget efterhand som raderna l{ses in.
 * Det finns kanske egentligen ingen anledning till att g|ra det en
 * rad taget men min "l{sa rad"-funktion blev ju s} v{ldigt bra. :-)
 */
enum koder {
    /* H{r {r det bara att fylla p} med din favoritkodning. */
    qp,
    base64,
    nocode
};
static char *
avkoda(enum koder kod, char * inrad)
{
    char * new;

    switch (kod)
    {
    case nocode:
	return inrad;
	/*NOTREACHED*/
    case qp:
	new = avkoda_qp(inrad);
	free(inrad);
	return new;
    case base64:
	new = avkoda_base64(inrad);
	free(inrad);
	return new;
    }
    return NULL;
}

/*
 * Omkodning mellan teckenuppsttningar
 */
char *
omkoda(char * line, char * charset)
{
#ifdef DO_RECODE
    FILE *tmp;
    int pid, pipe_fds[2];

    if (!strcmp( line, "us-ascii" ) || !strcmp( line, "iso-8859-1" ))
        return line;

    if (access( RECODE, X_OK )<0)
        /* recode fanns visst inte.  S synd. */
        return line;

    if ((tmp = tmpfile()) == NULL)
    {
        perror( "tmpfile" );
	return line;
    }

    fwrite( line, 1, strlen( line ), tmp );
    fflush( tmp );
    rewind( tmp );

    if (pipe( pipe_fds ) >= 0)
    {
        if ((pid = fork( )) == 0)
	{
	    /* Barn */
	    char * conversion = malloc( strlen(charset) + 12 );
	    strcpy( conversion, charset );
	    strcat( conversion, ":iso-8859-1" );

	    if (dup2( fileno( tmp ), 0 ) < 0)
	    {
	      perror( "dup2" );
	      _exit( 1 );
	    }
	    close( fileno( tmp ) );

	    if (dup2( pipe_fds[0], 1 ) < 0)
	    {
	      perror( "dup2" );
	      _exit( 1 );
	    }
	    close( pipe_fds[0] );
	    close( pipe_fds[1] );

	    execl( RECODE, "recode", "-fqs", conversion, NULL );
	    perror( "exec" );
	    _exit( 1 );
	}
	else
	{
	    /* Frlder */
	    close( pipe_fds[0] );
	    if (pid > 0)
	    {
	        int pos = 0, len = strlen( line )+4;
		char *new = malloc( len );
		int err = 0, st;

		for (;;)
		{
		  int r;

		  if ((r = read( pipe_fds[1], new + pos, len - pos )) == 0)
		      break;
		  if (r < 0)
		      if (errno == EINTR)
			  continue;
		      else
		      {
			  perror( "read" );
			  err = 1;
			  break;
		      }
		  pos += r;
		  if (pos >= len - 2) {
		      len *= 2;
		      new = realloc( new, len );
		  }
		}
	        while( wait( &st ) != pid );
		if (!err && st == 0)
		{
		    close( pipe_fds[1] );
		    fclose( tmp );
		    free( line );
		    new[ pos ] = '\0';
		    return new;
		}
		free( new );
	    }
	    else perror( "fork" );
	    close( pipe_fds[1] );
	}
    }
    fclose( tmp );
#endif
    return line;
}

/*
 * Avkodning av headerrader enligt Q-kodning
 * hr skulle man kunna lgga till B-kodning ocks men d behvs base64.
 */
void
avkoda_rfc1522(char * line)
{
    /* Ny algoritm:
       - skapa en ny, lika lng strng.
       iterera:
       - sk framt i den gamla strngen efter =?
       - kopiera allt fram till =?
       - sk framt efter ?
       - sk framt efter ?
       - sk framt efter ?=

       - om detta lyckats, splitta up strngen i 3 delar och avkoda den
         tredje delen i enlighet med teckenset och kodning i del 1 och 2.
       - om inte kopiera in allt och gr om.
       */

    char * lower_case(char * line);

    int len = strlen(line) + 1;
    char * oldl = (char *) malloc(len);
    char * rest = (char *) malloc(len);

    char * p;
    char * charset;
    char * encoding;
    char * token;

    char * end;
    char * avkodat;
    
    strcpy(oldl, line);
    p = oldl;
    strcpy(line, "");

    while ((charset=strstr(p, "=?")))
    {
        strncat(line, p, charset-p);
	charset += 2;

	if ((encoding = strchr(charset, '?')) &&
	    (token = strchr(encoding+1, '?')) &&
	    (end = strstr(token+1, "?=")) &&
	    token == encoding+2 &&
	    (encoding[1] == 'q' || encoding[1] == 'Q' ||
	     encoding[1] == 'b' || encoding[1] == 'B'))
	{
	    /* We can do it! */

	    *encoding++ = '\0';
	    *token++ = '\0';
	    *end = '\0';

	    avkodat = (*encoding == 'q' || *encoding == 'Q'?
		       avkoda_qp(token) : avkoda_base64(token));
	    lower_case( charset );
	    avkodat = omkoda( avkodat, charset );
	    strcat(line, avkodat);
	    free(avkodat);

	    p = end + 2;
	}
	else
	{
	    /* There was a =? in the text */
	    strcat(line, "=?");
	    p = charset;
	}
    }
    strcat(line, p);
    free(oldl);
    free(rest);
}



/*
 * Kolla om en header-rad matchar
 */
int
header_match(char * line, char* header)
{
    int i;

    for (i = 0; line[i] != '\0' && header[i] != '\0'; i++)
    {
        if (line[i] == header[i])
	    continue;
        if (isupper(line[i])
	    && tolower(line[i]) == header[i])
	    continue;
	if (isupper(header[i])
	    && line[i] == tolower(header[i]))
	    continue;
	return 0;
    }
    if (header[i] != '\0')
        return 0;
    if (line[i] != ':')
        return 0;

    /* Thats it, we are satisfied. */
    return 1;
}


char * myskipwhite(char * p) { while (*p == ' ' || *p == '\t') p++; return p; }

/* Konverterar en rad till lower_case */
char * lower_case(char * line)
{
    char * p; 

    for (p = line; *p; p++)
	if (isupper(*p))
	    *p = tolower(*p);

    return line;
}

/*
 * header_contents
 * returnerar en nymallokerad area inneh}llande headerns inneh}ll (dvs huvudet
 * {r bortplockat.
 */
char *
header_contents(char * header)
{
    char * p;

    if (header == NULL)
	return NULL;

    if ((p = strchr(header, ':')) != NULL)
    {
        char * new = copy_string(myskipwhite(p + 1));
	if (new[strlen(new) - 1] == '\n')
	    new[strlen(new) - 1] = '\0';
	return new;
    }
    return NULL;
}


/*
 * Hantering av speciella {renderader.
 * Raderna j{mf|rs enligt den angivna tabellen och om de matchar och
 * prioriteten st{mmer s} stoppar man in en pekar till den nya header-raden
 * och sl{pper den gamla.
 */
struct save_header_handler {
    int	priority;
    char * header;
};
void init_save_header_handler(struct save_header_handler *p) 
{
    p->priority = 0;
    p->header = NULL;
}

void
handle_header(struct save_header_handler * wheretosave,
	      struct save_header_handler   tocompare[],
	      char * headerline)
{
    int i;
    for (i = 0; 
	 tocompare[i].priority > 0 
	 && (wheretosave == NULL
	     || tocompare[i].priority > wheretosave->priority);
	 i++)
    {
        if (header_match(headerline, tocompare[i].header))
	{
	    free(wheretosave->header);
	    wheretosave->header = copy_string(headerline);
	    wheretosave->priority = tocompare[i].priority;
	    return;
	}
    }
}


/*
 * get_header()
 * vi l{ser in header och lagrar den.
 * i processen s}
 * - gallrar vi ut header-rader vi inte vill ha
 * - sparar undan message-id
 * - sparar undan comment-to
 * - sparar undan errors-to
 *
 * Hanteringen av dessa {r:
 * N{r vi f}r Message-ID s} sparar vi det.
 */
static struct save_header_handler messageid_handler[] = {
    { 10, "message-id" },
    { 0, "" }
};

/*
 * Errors-to {r:
 * i f|rsta hand det som st}r i errors-to-f{ltet.	100
 * i andra hand det som st}r i reply-to-f{ltet.		 80
 * i tredje hand det som st}r i From:-f{ltet		 50
 * i fj{rde hand det som st}r i Sender:-f{ltet		 40
 */
static struct save_header_handler errorsto_handler[] = {
    { 100, "errors-to" },
    { 80, "reply-to" },
    { 50, "from" },
    { 40, "sender" },
    { 0, "" }
};

/* comment-to {r 
 * i f|rsta hand det som st}r i inreplyto-f{ltet.	10
 * i andra hand det sista som st}r i references-f{ltet.  5
 */
static struct save_header_handler comment_to_handler[] = {
    { 10, "in-reply-to" },
    { 5, "references" },
    { 0, "" }
};				/* Detta skall g|ras snarfamid p} */


/* [rende (f|rsta raden) {r
 * i f|rsta hand subject:-f{ltet		100
 * i andra hand summary:-f{ltet			 80
 * i tredje hand Brev fr}n from:-f{ltet		 40
 * i fj{rde hand Brev skrivet date:-f{ltet	 15
 * i femte hand texten "Inget {rende".		  0
 */
static struct save_header_handler subject_handler[] = {
    { 100, "subject" },
    { 80, "summary" },		/* Longshot */
    { 40, "from" },
    { 30, "date" },
    { 0, "" }
};
    
/* errors-to, comment-to, {rende hanteras s} att n{r man tr{ffar p} n}got
 * av de f{lten sparas de undan med en prioritet och om man sedan tr{ffar p}
 * n}got med h|gre prioritet s} substituerar man helt enkelt.
 *
 * Tack vare det h{r prioritetsf|rfarandet slipper man h}lla en massa saker
 * i minnet till senare. Det enda som {r lite b|kigt {r att stoppa in
 * subject (som man inte k{nner till) f|rst.
 * F|r det anv{nder vi en speciell prepend-funktion s} att det inte beh|ver
 * g|ras f|rr{n senare.
 *
 * Vissa f{lt skall ignoreras. H{r {r de:
 */
static char * to_be_ignored[] = {
    "also-control",
    "approved",
    "content-length",
    "control",
    "date-received",
    "distribution",
    "errors-to",
    "expires",
    "lines",
    "path",
    "posted",
    "postng-verson",
    "received",
    "references",
    "relay-version",
    "subject",
    "supercedes",
    "supersedes",
    "x-char-esc",
    "x-charset",
    "x-envelope-to",
    "x-mailer",
    "x-vms-to",
    "x-vmsmail-to",
    "x400-received",
    "xref",
    NULL
};

/*
 * Returnerar sant om vi inte skall visa raden, dvs om den matchar n}gon
 * i to_be_ignored-arrayen.
 *
 * M}nga strcmp blir'e.
 *
 * Enda chansen att komma undan de m}nga "strcmp"-erna {r att g|ra n}gon
 * slags bin{rs|kning bland header-raderna. Det {r v{ldigt mycket b|kigare
 * att programmera och d{rf|r undviker jag det i det h{r l{get.
 *
 * Detta f}r kanske ompr|vas n{r det visar sig att f|r mycket tid spenderas
 * i den h{r delen av programmet.
 */
int
dont_show_line(char * line)
{ 
    int i;

    for (i = 0; to_be_ignored[i] != NULL; i ++)
    {
        if (header_match(line, to_be_ignored[i]))
	    return 1;
    }
    return 0;
}

/*
 * Parsa en quotad atom i en header
 */
char *
quoted_token( char *res, int ressize, char *p, char stop )
{
    while( *p && *p != stop )
    {
        if( *p == '\\' && p[1] )
	    p++;
	if (res != NULL && ressize > 0)
	{
	  *res++ = *p;
	  *res = '\0';
	  --ressize;
	}
	p++;
    }
    if (*p == stop)
        p++;
    return p;
}

/*
 * Parsa en strukturerad header
 */
int
header_token( char **context, char *res, int ressize )
{
    char *p;
    int t;

    if (res != NULL)
        *res = '\0';

    if (!context || !*context || !**context)
        return 0;

    p = *context;

    while (*p > 0 && ( *p <= ' ' || *p == '(' ))
    {
      if (*p == '(')
      {
	int cn = 0;
	do
	{
	    switch (*p++)
	    {
	    case '(': cn++; break;
	    case ')': --cn; break;
	    case '\\': if (*p) p++; break;
	    case '\0': cn=0; --p; break;
	    }
	} while( cn>0 );
      }
      else
	  p++;
    }
    
    if (!*p)
    {
      *context = p;
      return 0;
    }
    switch (t = *p++)
    {
    case '<': case '>': case '@': case ',': case ';': case ':':
    case '\\': case '/': case '?': case '=': case ']': case ')':
        if (res != NULL && ressize > 0)
	{
	    *res++ = t;
	    *res = '\0';
	}
	break;
    case '"':
      p = quoted_token( res, ressize, p, '"' );
      t = -1;
      break;
    case '[':
      p = quoted_token( res, ressize, p, ']' );
      t = -2;
      break;
    default:
      if (res != NULL && ressize > 0)
      {
	  *res++ = t;
	  *res = '\0';
	  --ressize;
      }
      while (*p < 0 || (*p > ' ' && !strchr("<>@,;:\\/?=])\"[(", *p)))
      {
	  if (res != NULL && ressize > 0)
	  {
	      *res++ = *p;
	      *res = '\0';
	      --ressize;
	  }
	  p++;
      }
      t = -1;
    }
    *context = p;
    return t;
}

/* 
 * L{s in headern och s{tt upp allt.
 */
enum koder
get_header()
{
    /* F|r att kunna hantera "continuation lines" s} m}ste vi l{sa en rad
       i f|rv{g. Men det g}r nog bra.
     */
    enum koder kod = nocode;
    char * line;
    char * next_line;
    char * subject;

    struct save_header_handler hmessageid; 
    struct save_header_handler herrorsto; 
    struct save_header_handler hcommentto;
    struct save_header_handler hsubject;

    init_save_header_handler(& hmessageid);
    init_save_header_handler(& herrorsto);
    init_save_header_handler(& hcommentto);
    init_save_header_handler(& hsubject);


    for (line = read_line(); line && line[0] != '\n'; line = next_line)
    { 
        /* Hantera continuation lines */
	while ((next_line = read_line())
	       && (next_line[0] == ' '
		   || next_line[0] == '\t'))
	{			/* Detta {r en continuation line */
	    /* Sl} ihop raderna */
	    line = realloc(line, strlen(line) + 1 + strlen(next_line) + 1);
	    line[strlen(line) - 2] = ' '; /* Pilla bort newline */
	    strcat(line, next_line + 1);
	}

	/* Avkodning enligt rfc 1522.
	   Dvs tag =?blabla?q?text?= och substituera mot avkoda_qp(text)
	   Detta modifierar nog line, men det gr inget, line blir bara 
	   kortare.
	 */
	avkoda_rfc1522(line);

	/* Detta {r en v{ldigt generell hantering som resulterar i ganska
	   m}nga strcmp men i geng{ld beh|ver jag inte t{nka s} mycket n{r
	   jag skriver programmet. (Se kommentaren ovan vid dont_show_line())
	 */
	handle_header(& hmessageid, messageid_handler, line);
	handle_header(& herrorsto, errorsto_handler, line);
	handle_header(& hcommentto, comment_to_handler, line);
	handle_header(& hsubject, subject_handler, line);

	/* L{s mime-attribut och annat */
	if (header_match(line, "content-transfer-encoding"))
	{
	    char encoding[32], *context = line;

	    if (-1 == header_token( &context, NULL, 0 ) &&
		':' == header_token( &context, NULL, 0 ) &&
		-1 == header_token( &context, encoding, sizeof(encoding)-1 ))
	    {
	        lower_case( encoding );
		if (!strcmp(encoding, "quoted-printable"))
		{
		    kod = qp;
		}
		else
		if (!strcmp(encoding, "base64"))
		{
		    kod = base64;
		}
	    }
	}
	else if (header_match(line, "content-type"))
	{
	    char *context = line;
	    for(;;) {
	      int t;
	      char hdr[16];	/* Stort nog fr strngen "charset" */
	      do t = header_token( &context, NULL, 0 ); while( t && t != ';' );
	      if (!t) break;
	      if( -1 == header_token( &context, hdr, sizeof(hdr)-1 ) &&
		  !strcmp( lower_case( hdr ), "charset" ) &&
		  '=' == header_token( &context, NULL, 0 ) )
	      {
		  int l = strlen( context );
		  char *charset = malloc( l+1 );
		  if( -1 == header_token( &context, charset, l ) )
		  {
		      if (body_charset != NULL)
			  free(body_charset);
		      body_charset = charset;
		  }
		  else
		  {
		      free( charset );
		  }
	      }
	    }
	}
	if (dont_show_line(line))
	{
	    free(line);
	    continue;
	}

	/* Den h{r header-raden skall trots allt vara med i brevet. */
	append(line);
    }

    /* Nu har vi l{st igenom hela headern.
     * Dags att fixa till de speciella f{lten.
     */

    messageid = snarfamid(hmessageid.header); 
    if (hmessageid.header) 
        free(hmessageid.header);

    commentto = snarfamid(hcommentto.header);
    if (hcommentto.header) 
        free(hcommentto.header);

    errorsto = header_contents(herrorsto.header);
    if (herrorsto.header) 
        free(herrorsto.header);

#define CREATE_SUBJECT(HEADTEXT) \
    {								\
        char * tmpsub = header_contents(hsubject.header);	\
	  							\
        subject = malloc(40 + strlen(tmpsub));			\
	strcpy(subject, HEADTEXT);				\
	strcat(subject, tmpsub);				\
	free(tmpsub);						\
    }

    if (hsubject.priority > 50)
    {
        subject = header_contents(hsubject.header);
    }
    else if (hsubject.priority > 20)
        CREATE_SUBJECT("Brev fr\345n ")
    else if (hsubject.priority > 10)
        CREATE_SUBJECT("Brev skrivet ")
    else
    {
        subject = malloc(40);
	strcpy(subject,"Inget Subject: i brevet.");
    }

    strcat(subject, "\n");
    prepend(subject);
    free(subject);

    append("\n");

    return kod;
}



/*
 * Detta {r huvuddelen av den h{r filen.
 */
char * read_mail()
{
    enum koder kodning;
    char * rad;
    char * avkodadrad;
    int bodystart = 0;

    body_charset = NULL;

    kodning = get_header();

    /* Verifiera att vi har vad vi beh|ver f|r att kunna k|ra */
    if (vilket_messageid() == NULL)
    {
	exit (EX_DATAERR);
    }

    /* Plocka in resten av brevet */

    if(get_area() != NULL) bodystart = strlen(get_area());

    while ((rad = read_line()))
    {
	/* rad inneh}ller en kodad rad. */
	/* avkodadrad inneh}ller en avkodad rad. */
	/* Detta koncept r{cker antagligen f|r QP och 6bit men inte f|r
	   att hantera multipart. */
	avkodadrad = avkoda(kodning, rad);
	append(avkodadrad);
    }

    if(body_charset != NULL && get_area() != NULL) {
	char *recoded = copy_string(get_area()+bodystart);
	get_area()[bodystart] = '\0';
	lower_case( body_charset );
	recoded = omkoda( recoded, body_charset );
	append( recoded );
	free( recoded );
    }
    
    crop_area();

    return get_area();
}
