/*
 *  cmd-pers.c
 *		The functions to actually execute the commands
 *		for the client.  Commands for handling
 *		persons.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */

#include <config.h>

#include <stdio.h>
/* #include <time.h> is included from kom-types.h */
#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#include <kom-errno.h>
#include <kom-types.h>
#include <services.h>
#ifdef __vax__
#define __SIZE_T included from string.h
#endif
#include <zmalloc.h>
#include <s-string.h>
#include <s-collat.h>

#include "copy.h"
#include "read-line.h"
#include "commands.h"
#include "parser.h"
#include "edit.h"
#include "error.h"
#include "cache.h"
#include "quit.h"

#include "internal.h"
#include "cmds.h"

/* This is to emphasize that a function is exported. */
#define Export

/*
 *  Find all conferences matching the name NAME.  Also supports the
 *  notation "person nnn", where nnn is a number.
 */
Export  Conf_z_info_list
find_person_number (String	name)

{
#define FUNCTION "find_person_number()"

    Conf_z_info_list		list_of_matches	= EMPTY_CONF_Z_INFO_LIST;
    unsigned short		i;		/* Looping over conf_nos */
    unsigned short		pno;		/* Counting pers_nos */
    Conf_z_info_list volatile	result		= EMPTY_CONF_Z_INFO_LIST;

#define CLEAN_UP() 					\
    {							\
	release_conf_z_info_list (&list_of_matches);	\
    }

    TOPLOOP_SETJMP();

    list_of_matches = find_conf_or_pers_no (name);

    /*  Transform the list of conferences into a list of persons,
     *  and remove all the matches that aren't persons.		*/

    /*  Allocate memory for the list of persons (might be a bit to
     *  large, though).						*/
    if ((result.confs = zmalloc (list_of_matches.no_of_confs
				 * sizeof (Conf_z_info))) == NULL)
    {
	/* We need to increase the swap area, but we cant. */
	fatal1 (CLIENT_OUT_OF_MEMORY,
		"Transforming conf list to persons");
    }

    /*  Then copy the numbers of those that are persons  */
    for ( pno = i = 0 ;  i < list_of_matches.no_of_confs ;  i++ )
    {
	if (list_of_matches.confs[i].type.letter_box == 1)
	{
	    copy_conf_z_info(&result.confs[pno++], &list_of_matches.confs[i]);
	}
    }
    if (pno != 0)
	result.no_of_confs = pno;
    else
    {
	zfree (result.confs);
	result = EMPTY_CONF_Z_INFO_LIST;
    }

    /* Phew! Finished at last. */
    RETURN (result);

#undef CLEAN_UP
#undef FUNCTION
}
