/*
 *  misc-parser.h
 *		Parse a list of "misc-item":s for a text in LysKOM
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 */



#include <kom-types.h>



typedef  enum  {
	m_recpt,
	m_cc_recpt,
	m_comm_to,
	m_comm_in,
	m_footn_to,
	m_footn_in,
	m_end_of_list,	/* End of list reached	*/
	m_error		/* Bad misc-items found */
}  Misc_struct_type;


typedef  struct  {
	Misc_struct_type	type;
	Conf_no			recipient;
	Local_text_no		local_no;
	struct tm		received_at;
	Text_no			text_ref;
	Pers_no			sender;
	struct tm		sent_at;
	Bool			is_received;
	Bool			is_sent;
}  Misc_info_group;



#define is_received(mstruct)	((mstruct).is_received != FALSE)
#define is_sent_by(mstruct)	((mstruct).sender != 0)
#define is_sent(mstruct)	((mstruct).is_sent != FALSE)


/*
 *  Parse out a "group" of misc-items from a list of them pointed
 *  to by *INFO.  *STOP_POINTER must point to the item directly
 *  after the last in the list.  **INFO will be incremented to
 *  point to the item after the recently parsed out group.  The
 *  return value will have the TYPE field set to 'm_end_of_list'
 *  when the end of the list has been reached.
 *
 *  If the has a bad format, the TYPE field will be 'm_error',
 *  and **INFO_POINTER will point to the item before the bad (or
 *  missing) item.
 */
extern  Misc_info_group
parse_next_misc (const Misc_info	** info_pointer,
		 const Misc_info	 * stop_pointer);
