/*
 *  quit.h
 *	Macros for quitting a command prematurely.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 */


#ifndef  QUIT_H_ALREADY_INCLUDED__
#define  QUIT_H_ALREADY_INCLUDED__


#include <setjmp.h>

extern jmp_buf		  toploop_jmpbuf;


#define COPY_JMPBUF(source, dest)  	\
	memcpy (&(dest), &(source), sizeof (jmp_buf))


#define TOPLOOP_SETJMP()				\
jmp_buf 		  saved_toploop;		\
{							\
    COPY_JMPBUF (toploop_jmpbuf, saved_toploop);	\
    if (setjmp (toploop_jmpbuf))			\
    {							\
	CLEAN_UP();					\
	COPY_JMPBUF (saved_toploop, toploop_jmpbuf);	\
	longjmp (toploop_jmpbuf, 17);			\
    }							\
}


/* The do-while (0) construct is there to make it possible to enter the
   macro looking like a function call in if statements.

   Don't change that.
   */

#define RETURN(retval) 					\
{							\
    CLEAN_UP();						\
    COPY_JMPBUF (saved_toploop, toploop_jmpbuf);	\
    return retval;					\
}

#define RETURNVOID 					\
{							\
    CLEAN_UP();						\
    COPY_JMPBUF (saved_toploop, toploop_jmpbuf);	\
    return;						\
}


#endif  /* QUIT_H_ALREADY_INCLUDED__ */
