-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2002 Hans-Frieder Vogt                                --
--                                                                           --
--  Adabindx is free software; you can redistribute it and/or modify it      --
--  under the terms of the GNU General Public License as published by the    --
--  Free Software Foundation; either version 2 of the License, or (at your   --
--  option) any later version.                                               --
--                                                                           --
--  This program is distributed in the hope that it will be useful, but      --
--  WITHOUT ANY WARRANTY; without even the implied warranty of               --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--  As a special exception, if other files instantiate generics from this    --
--  unit, or you link this unit with other files to produce an executable,   --
--  this unit does not by itself cause the resulting executable to be        --
--  covered by the GNU General Public License. This exception does not       --
--  however invalidate any other reasons why the executable file might be    --
--  covered by the GNU General Public License.                               --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                  and by The Open Group                                    --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--
-------------------------------------------------------------------------------

with Ada.Text_Io;
package body Search is

   function Init_Search (Pattern : in String) return Search_Data is
      Tab : Shift_Table;
   begin
      --  first fill the table with default values
      --
      for I in Tab'Range loop
         Tab (I) := Pattern'Length + 1;
      end loop;
      --  now look for actual shift values
      --
      for I in Pattern'Range loop
         Tab (Pattern (I)) := Pattern'Last - I + 1;
      end loop;
      return Search_Data'(Pattern_Length => Pattern'Length, Pattern => Pattern,
                          Table => Tab);
   end Init_Search;


   function Quick_Search
     (Table      : in Search_Data;
      Text       : in String;
      From_Index : in Natural)
      return Natural is
      Current_Index : Natural := From_Index;
      Pattern_First : Natural := Table.Pattern'First;
   begin
      while Current_Index + Table.Pattern_Length - 1 <= Text'Last loop
         for I in Table.Pattern'Range loop
            exit when Text (Current_Index+I-Pattern_First) /= Table.Pattern (I);
            if I = Table.Pattern'Last then
               return Current_Index;
            end if;
         end loop;
--         Ada.Text_Io.Put (Integer'Image (Current_Index) & "  ");
         exit when Current_Index + Table.Pattern_Length > Text'Last;
         Current_Index := Current_Index +
                          Table.Table (Text (Current_Index + Table.Pattern_Length));
      end loop;
      raise Not_Found_Error;
   end Quick_Search;

end Search;
