-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--
-------------------------------------------------------------------------------

package body Rotate_Arrow_Global is

   procedure Arrow_Button_CB (W         : in Widget;
                              Closure   : Xt_Pointer;
                              Call_Data : Xt_Pointer) is
   begin
      if Dir /= Arrow_Direction_Type'Last then
         Dir := Arrow_Direction_Type'Succ (Dir);
      else
         Dir := Arrow_Direction_Type'First;
      end if;
      Argl := Null_Arg_List;
      Append_Set (Argl, Xm_N_Arrow_Direction, Dir);
      Xt_Set_Values (The_Button, Argl);

      The_Title := Xm_String_Create (Arrow_Direction_Type'Image (Dir));
      Argl := Null_Arg_List;
      Append_Set (Argl, Xm_N_Label_String, The_Title);
      Xt_Set_Values (The_Label, Argl);
      Xm_String_Free (The_Title);

   end Arrow_Button_CB;

end Rotate_Arrow_Global;
