-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--
-------------------------------------------------------------------------------

with X_Lib,
     X_Lib.Screen_Saver,
     X_Lib.Tasking,
     X_Toolkit,
     X_Toolkit.Shell;
with Interfaces.C;
with Text_Io;
procedure Show_Screen_Saver is

   use  X_Lib, X_Lib.Screen_Saver, X_Toolkit, Interfaces.C;

   Appshell : Widget;
   Display  : Display_Pointer;
   Screen   : Screen_Pointer;
   Visual   : Visual_Pointer;
   Window   : Window_ID;

   Argl : Arg_List;
   App_Con : Xt_App_Context;

   Timeout, Interval : Integer;
   Blank             : Blanking_Mode;
   Exposures         : Exposures_Mode;

   package Int_Io       is new Text_Io.Integer_Io (Integer);
   package Blank_Io     is new Text_Io.Enumeration_Io (Blanking_Mode);
   package Exposures_Io is new Text_Io.Enumeration_Io (Exposures_Mode);

begin
   X_Lib.Tasking.Resource.Seize;
-- UseX11R6
--!    Xt_Open_Application (Appshell,
--!                         App_Con,
--!                         "ShowScreenSaver",
--!                         W_Class => X_Toolkit.Shell.Top_Level_Shell_Widget_Class);
-- NotX11R6
   Xt_App_Initialize (Appshell,
                      App_Con,
                      "ShowScreenSaver");
-- EndX11R6
   
   Display := Xt_Display (Appshell);
   Screen  := Xt_Screen (Appshell);
   Window  := X_Root_Window_Of_Screen (Screen);

   Visual  := X_Default_Visual_Of_Screen (Screen);


   X_Get_Screen_Saver (Display, Timeout, Interval, Blank, Exposures);
   X_Lib.Tasking.Resource.Release;

   Text_Io.Put_Line ("Screen-saver values:");
   Text_Io.Put ("  Timeout:         "); Int_Io.Put (Timeout); Text_Io.New_Line;
   Text_Io.Put ("  Interval:        "); Int_Io.Put (Interval); Text_Io.New_Line;
   Text_Io.Put ("  Prefer_Blanking: "); Blank_Io.Put (Blank); Text_Io.New_Line;
   Text_Io.Put ("  Allow_Exposures: "); Exposures_Io.Put (Exposures); Text_Io.New_Line;
   Text_Io.New_Line;

   Text_Io.Put_Line ("Test of the screen-saver:");
   Text_Io.New_Line;
   Text_Io.Put_Line ("The screen will be blanked for 2 s");
   Text_Io.Put_Line ("The test of the screen-saver begins in 5 s");
   Text_Io.Flush;
   for I in 1 .. 5 loop
      delay 1.0;
      Text_Io.Put (".");
      Text_Io.Flush;
   end loop;
   Text_Io.New_Line;

   X_Lib.Tasking.Resource.Seize;
   X_Activate_Screen_Saver (Display);
   X_Flush (Display);
   X_Lib.Tasking.Resource.Release;

   delay 2.0;

   X_Lib.Tasking.Resource.Seize;
   X_Reset_Screen_Saver (Display);
   X_Flush (Display);
   X_Lib.Tasking.Resource.Release;

end Show_Screen_Saver;
