--***********************************************************************
--									*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that the above copyright notice and this paragraph are	*
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************

-- modified for use with Adabindx 10.8.1997
-- Hans-Frieder Vogt (vogt@ilaws6.luftfahrt.uni-stuttgart.de)

with Ada.Numerics.Elementary_Functions;
package body UNITS is

    function SIN(R : RADIANS) return FLOAT is
    begin
	return Ada.Numerics.Elementary_Functions.SIN(FLOAT(R));
    end;

    function COS(R : RADIANS) return FLOAT is
    begin
	return Ada.Numerics.Elementary_Functions.COS(FLOAT(R));
    end;

    function "*"(LEFT : RADIANS_PER_SECOND; RIGHT : SECONDS) return RADIANS
    is
    begin
	return RADIANS(FLOAT(LEFT)*FLOAT(RIGHT));
    end;

    function "*"(LEFT : COORDINATE; RIGHT : FLOAT) return COORDINATE
    is
    begin
	return COORDINATE(FLOAT(LEFT)*RIGHT);
    end;

end;


