-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2002 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--          20 Jan 2002 H.-F. Vogt: Speed up of reading in text
--                                  improved user interface
--
-------------------------------------------------------------------------------

with X_Lib,
     X_Toolkit,
     Xm_Widgets;
use  X_Toolkit,
     Xm_Widgets;
package XmMore_Global is

   Appshell,
   The_Main, The_Menu_Bar, The_Text, The_Status : Widget;
   About_Dialog          : Widget := Null_Widget;
   App_Con               : Xt_App_Context;

   Display               : X_Lib.Display_Pointer;

   Argl                  : Arg_List := Null_Arg_List;

   File_Name             : String (1 .. 1024);
   File_Name_L           : Natural := 0;

   Characters            : Long_Integer := 0;
   Lines                 : Natural := 0;

   type Long_Array is array (Natural range <>) of Long_Integer;
   type Long_Array_Access is access all Long_Array;

   Line_Array    : Long_Array_Access;
   Array_Completed : Boolean := False;


   Leave_XmMore          : exception;


   procedure Actualize_Status (Cur_Pos : in Long_Integer);

   procedure About_CB (W         : in Widget;
                       Closure   : Xt_Pointer;
                       Call_Data : Xt_Pointer);
   pragma Convention (C, About_CB);


   procedure Quit_CB (W         : in Widget;
                      Closure   : Xt_Pointer;
                      Call_Data : Xt_Pointer);
   pragma Convention (C, Quit_CB);


   procedure Text_CB (W         : in Widget;
                      Closure   : Xt_Pointer;
                      Call_Data : Xt_Pointer);
   pragma Convention (C, Text_CB);


end XmMore_Global;
