/* ======================================================================
 * Copyright (c) 1998-1999 The Johns Hopkins University.
 * All rights reserved.
 * The following code was written by Theo Schlossnagle for use in the
 * Backhand project at The Center for Networking and Distributed Systems
 * at The Johns Hopkins University.
 * Please refer to the LICENSE file before using this software.
 * ======================================================================
*/

#ifndef _BACK_UTIL_H
#define _BACK_UTIL_H

#include "httpd.h"
#include "buff.h"
#include "mod_backhand.h"

typedef struct {
  pool *backhand_pool;
  StatsSI *sins;
  int nsins;
  server_rec *server;
  ACL *UDPacl;
  char *UD_DN;
} daemon_params;

void html_print_serverstats_table(request_rec *);
int broadcast_my_stats(void *, child_info *);
int find_server(struct in_addr *sin, unsigned short);
ACL *matchACL(ACL *acl, struct in_addr *in);
void backhand_initstat(void);

#define isbroadcast(a) (!(ismulticast(a)))
#define ismulticast(a) ((((ntohl((a).sin_addr.s_addr))>>24)>=224) &&\
			(((ntohl((a).sin_addr.s_addr))>>24)<=239))

#define QUANTUM 1000000

/* client/server protocol:
   1) client->server GET/PUT/CLOSE (1-byte)
   2) client->server WHAT (sizeof(struct in_addr))
   2) client->server WHAT (sizeof(unsigned short))
   3(?GET) server->client (transfer fd)
   3(?PUT) client->server (transfer fd)
*/
#define MBCSP_GET 0
#define MBCSP_PUT 1
#define MBCSP_CLOSE 2
#define MBCSP_REQ_SIZE (1+sizeof(struct in_addr)+sizeof(unsigned short))
#endif
