/*-------------------------------------------------------------------------------

Copyright (c) 2001 CerebraSoft

Module Name:

	bhbFilter.cpp

Abstract:

	Broadcast performance information to mod backhand server.  Startup as an IIS filter.

License:

   All rights reserved.

   This product includes software developed at The Center for
   Networking and Distributed Systems at The Johns Hopkins University
   for use in the Backhand project (http://www.cnds.jhu.edu/backhand).
     Creator: Theo Schlossnagle 
     Guidance: Yair Amir

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer. 
 
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
 
  3. All advertising materials mentioning features or use of this
     software must display the following acknowledgment:
     "This product includes software developed by Cerebrasoft
     (http://www.cerebrasoft.com).
        Creator: Rob Butler"

  4. The names "Backhand Broadcaster" and "NT Backhand Broadcaster" must
     not be used to endorse or promote products derived from this
     software without prior written permission. For written permission,
     please contact www.cerebrasoft.com.
 
  5. Products derived from this software may not be called "Backhand Broadcaster"
     or "NT Backhand Broadcaster" nor may "Backhand Broadcaster" or
     "NT Backhand Broadcaster" appear in their names without prior written
     permission. For written permission, please contact www.cerebrasoft.com.
 
  6. Redistributions of any form whatsoever must retain the following
     acknowledgment:
     "This product includes software developed by Cerebrasoft
     (http://www.cerebrasoft.com).
        Creator: Rob Butler"

  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
  ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
  OF THE POSSIBILITY OF SUCH DAMAGE.
---------------------------------------------------------------------------------*/

#include <windows.h>
#include <httpfilt.h>
#include "broadcast.h"

/*-------------------------------------------------------------------------------

BOOL APIENTRY DllMain(HANDLE module, DWORD reasonForCall, LPVOID reserved )	

	Entry and exit point for the filter. Called when the filter is loaded and
	unloaded by IIS.

	When starting the broadcast thread in IIS it is necessary to delay the startup
	for several reasons.  The first and most important is if we attempt to initialize
	the statistics counter handle while IIS is starting, IIS will lock up.  This is
	probably because IIS is attempting to register itself for stats while we are too.
	This causes a deadlock.  Also, we should wait till IIS is fully up and running before
	we calculate our arriba (if necessary) because we don't want it affected by the
	processing power used to start up IIS.

	The delay time of (30 seconds) should be sufficient.  Your mileage may vary
	and this time may need to be increased on less powerful systems.
	(This value can be increased or decreased by setting the Delay registry entry.

---------------------------------------------------------------------------------*/

BOOL APIENTRY DllMain(HANDLE module, DWORD reasonForCall, LPVOID reserved ){
	switch(reasonForCall ) {
		case DLL_PROCESS_ATTACH:
			return startBroadcasting(30);	// delay 30 seconds before starting
			break;
		case DLL_PROCESS_DETACH:
			stopBroadcasting();
			break;
	}
	return TRUE;
}

/*-------------------------------------------------------------------------------

BOOL WINAPI GetFilterVersion(HTTP_FILTER_VERSION *version)

	An ISAPI/Win32 API method. This method is required by IIS.
	It is called following the process load to ensure that the filter is compatable
	with the server.

---------------------------------------------------------------------------------*/

BOOL WINAPI GetFilterVersion(HTTP_FILTER_VERSION *version){

    version->dwFilterVersion = HTTP_FILTER_REVISION; 

		// which events we filter.  We should "filter" at least one to be valid
	version->dwFlags = (SF_NOTIFY_LOG | SF_NOTIFY_ORDER_LOW);

		// A brief one line description of the filter
    strcpy( version->lpszFilterDesc, "Backhand Broadcaster, v1.0" );

    return TRUE;
}

/*-------------------------------------------------------------------------------

DWORD WINAPI HttpFilterProc(HTTP_FILTER_CONTEXT *pfc, DWORD notificationType, VOID *data)

	ISAPI / Win32 API method. This method is a required by IIS.
	It is called for each notification event requested.  Normally this is where
	an IIS filter would do it's work, but we aren't doing any filtering.  We only
	want a process which is started when IIS starts.  We are taking advantage of IIS
	custom filters to do this.

---------------------------------------------------------------------------------*/

DWORD WINAPI HttpFilterProc(HTTP_FILTER_CONTEXT *pfc, DWORD notificationType, VOID *data){
    return SF_STATUS_REQ_NEXT_NOTIFICATION;
}





