/* ======================================================================
 * Copyright (c) 1998-1999 The Johns Hopkins University.
 * All rights reserved.
 * The following code was written by Theo Schlossnagle for use in the
 * Backhand project at The Center for Networking and Distributed Systems
 * at The Johns Hopkins University.
 * Please refer to the LICENSE file before using this software.
 * ======================================================================
*/

/* The following routines were adapted shamelessly from the apache source */

static int b_getline(char *s, int n, BUFF *in, int fold) {
  char *pos=s, next;
  int retval, total=0;
  do {
    retval=ap_bgets(pos, n, in);
    if (retval <= 0)
      return ((retval < 0) && (total == 0)) ? -1 : total;
    pos += (retval - 1);
    total += retval;
    n -= retval;
    if (pos[0] == '\n') {
      while (pos > (s + 1) && (pos[-1] == ' ' || pos[-1] == '\t'))
        --pos, --total, ++n;
      pos[0] = '\0';
      --total;
      ++n;
    } else
      return total;
    } while (fold && (retval != 1) && (n > 1)
                  && (ap_blookc(&next, in) == 1)
                  && ((next == ' ') || (next == '\t')));
    return total;
}
static int b_get_mime_headers_out(BUFF *myconn, request_rec *r, table **t_h,
				  table **t_c) {
  char field[DEFAULT_LIMIT_REQUEST_FIELDSIZE + 2];
  char *value, *copy;
  int len, numheaders=-1;
  unsigned int fields_read=0;
  table *tmp_headers;
  table *cookie_headers;

  tmp_headers = ap_make_table(r->pool, 50);
  cookie_headers = ap_make_table(r->pool, 2);
  *t_h = tmp_headers;
  *t_c = cookie_headers;
 
  if(b_getline(field, sizeof(field), myconn, 0)<=0) return -1;
  if((value = strchr(field, ' '))!=NULL) {
    r->status = atoi(value+1);
    field[sizeof(field)-1] = '\0';
    r->status_line = ap_pstrdup(r->pool,value+1);
  }
  numheaders++;
  while((len = b_getline(field, sizeof(field), myconn, 1)) > 0) {
    if(r->server->limit_req_fields &&
       (++fields_read > r->server->limit_req_fields)) {
      r->status = HTTP_BAD_REQUEST;
      return numheaders;
    }
    if(len > r->server->limit_req_fieldsize) {
      r->status = HTTP_BAD_REQUEST;
      return numheaders;
    }
    copy = ap_palloc(r->pool, len + 1);
    memcpy(copy, field, len + 1);
    if(!(value = strchr(copy, ':'))) {
      r->status = HTTP_BAD_REQUEST;
      return numheaders;
    }
    value[0] = '\0';
    ++value;
    while(value[0] == ' ' || value[0] == '\t')
      ++value;
    
    if (!strcasecmp(copy, "Set-Cookie")) {
      ap_table_addn(cookie_headers, copy, value);
    } else {
      ap_table_addn(tmp_headers, copy, value);
    }
    numheaders++;
  }
  return numheaders;
}

static long b_get_chunk_size(char *b)
{
    long chunksize = 0;

    while (ap_isxdigit(*b)) {
        int xvalue = 0;

        if (*b >= '0' && *b <= '9')
            xvalue = *b - '0';
        else if (*b >= 'A' && *b <= 'F')
            xvalue = *b - 'A' + 0xa;
        else if (*b >= 'a' && *b <= 'f')
            xvalue = *b - 'a' + 0xa;

        chunksize = (chunksize << 4) | xvalue;
        ++b;
    }

    return chunksize;
}
static long get_response_block(BUFF *sconn, request_rec *r, int *remaining,
			       char *buffer, int bufsiz)
{
    int c;
    long len_read, len_to_read;
    long chunk_start = 0;

    bufsiz -= 2;

    if (*remaining == 0) {    /* Start of new chunk */
      chunk_start = b_getline(buffer, bufsiz, sconn, 0);
      if ((chunk_start <= 0) || (chunk_start >= (bufsiz - 1))
	  || !ap_isxdigit(*buffer)) {
	*remaining = -1;
	return -1;
      }
      
      len_to_read = b_get_chunk_size(buffer);
      if(len_to_read < 0) {
        r->connection->keepalive = -1;
        *remaining = -1;
        return -1;
      } 
      if (len_to_read == 0) { /* Last chunk indicated, get footers */
	*remaining = -1;  /* Indicate footers in-progress */
      }
      else {
	*remaining = len_to_read;
      }
      buffer[chunk_start++] = CR;
      buffer[chunk_start++] = LF;
      buffer += chunk_start;
      bufsiz -= chunk_start;
    }
                                /* When REQUEST_CHUNKED_PASS, we are */
    if (*remaining == -1) {   /* reading footers until empty line  */
      len_read = chunk_start;
      
      while ((bufsiz > 1) &&
	     ((len_read = b_getline(buffer, bufsiz, sconn, 1)) > 0)) {
	
	if (len_read != (bufsiz - 1)) {
	  buffer[len_read++] = CR;        /* Restore footer line end  */
	  buffer[len_read++] = LF;
	}
	chunk_start += len_read;
            buffer += len_read;
            bufsiz -= len_read;
        }
        if (len_read < 0) {
	  /* keepalive = -1; */
	  return -2;
        }

        if (len_read == 0) {    /* Indicates an empty line */
            buffer[0] = CR;
            buffer[1] = LF;
            chunk_start += 2;
            *remaining = -2;
        }
	/*        r->read_length += chunk_start;*/
        return chunk_start;
    }
                                /* When REQUEST_CHUNKED_PASS, we     */
    if (*remaining == -2) {   /* finished footers when last called */
      *remaining = 0;       /* so now we must signal EOF         */
      return 0;
    }

    /* Otherwise, we are in the midst of reading a chunk of data */

    len_to_read = (*remaining > bufsiz) ? bufsiz : *remaining;

    len_read = ap_bread(sconn, buffer, len_to_read);
    if (len_read <= 0) {
        return -2;
    }

    *remaining -= len_read;

    if (*remaining == 0) {    /* End of chunk, get trailing CRLF */
        if ((c = ap_bgetc(sconn)) == CR) {
            c = ap_bgetc(sconn);
        }
        if (c != LF) {
            return -2;
        }
	buffer[len_read++] = CR;
	buffer[len_read++] = LF;
    }
    /*    r->read_length += (chunk_start + len_read);*/

    return (chunk_start + len_read);
}
