#include "structs.h"

/* file: /home/skx/cvs/mod_ifier/src/cgi.c */
static apr_array_header_t *mod_ifier_parse_cgi_parameters(request_rec *req);
static int does_any_cgi_param_value_match(apr_array_header_t *results, request_rec *req, ap_regex_t *pattern);
extern const char *get_cgi_param_value(apr_array_header_t *results, request_rec *req, const char *wanted);

/* file: /home/skx/cvs/mod_ifier/src/match.c */
static int match_header_rule(request_rec *req, mod_ifier_rule *rule);
static int match_path(request_rec *req, mod_ifier_rule *rule);
static int match_method(request_rec *req, mod_ifier_rule *rule);
static int match_cgi(request_rec *req, mod_ifier_rule *rule, apr_array_header_t *cgi);

/* file: /home/skx/cvs/mod_ifier/src/mod_ifier.c */
extern void debug_printf(const char *fmt, ...);
extern module AP_MODULE_DECLARE_DATA mod_ifier_module;
extern char *current_time(request_rec *r);
static void modifier_write_log(request_rec *r, const char *text, ...);
static void log_headers(request_rec *req, const char *path);
static void setup_action_record(cmd_parms *cmd, mod_ifier_action *act, const char *action);
static const char *add_drop_action(cmd_parms *cmd, void *dummy, const char *action);
static const char *add_drop_agent(cmd_parms *cmd, void *dummy, const char *term, const char *action);
static const char *filter_ip(cmd_parms *cmd, const char *ip, mod_ifier_rule_type type);
static const char *add_drop_blacklist(cmd_parms *cmd, void *dummy, const char *ip);
static const char *add_drop_header(cmd_parms *cmd, void *dummy, const char *header, const char *term, const char *action);
static const char *add_drop_method(cmd_parms *cmd, void *dummy, const char *type, const char *action);
static const char *add_drop_log(cmd_parms *cmd, void *dummy, const char *file);
static const char *add_drop_log_headers(cmd_parms *cmd, void *dummy, const char *file);
static const char *add_drop_param(cmd_parms *cmd, void *dummy, const char *parameter);
static const char *add_drop_param_value(cmd_parms *cmd, void *dummy, const char *parameter, const char *value, const char *action);
static const char *add_drop_param_values(cmd_parms *cmd, void *dummy, const char *value, const char *action);
static const char *add_drop_path(cmd_parms *cmd, void *dummy, const char *path, const char *action);
static const char *add_drop_referer(cmd_parms *cmd, void *dummy, const char *term, const char *action);
static const char *add_drop_whitelist(cmd_parms *cmd, void *dummy, const char *ip);
static int mod_ifier_match_ip(request_rec *req, mod_ifier_rule_type type);
static int mod_ifier_is_ip_blacklisted(request_rec *req);
static int mod_ifier_is_ip_whitelisted(request_rec *req);
static const char *filter_header(cmd_parms *cmd, const char *header, const char *pattern, const char *action);
static const char *filter_parameter(cmd_parms *cmd, const char *parameter, const char *pattern, const char *action);
static void *mod_ifier_create_server_config(apr_pool_t *p, server_rec *dummy);
static int mod_ifier_handler(request_rec *req);
static int mod_ifier_test_incoming_request(request_rec *req);
static void mod_ifier_register_hooks(apr_pool_t *p);
static int run_external_command(request_rec *req, const char *cmd);

